package edu.jhu.ece.iacl.plugins.utilities.volume;



import java.util.List;

import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;

public class MedicAlgorithmFindEqualVolume extends ProcessingAlgorithm{
	
	private ParamVolumeCollection candidateVol;
	private ParamVolume targetVolume;
	
	private ParamObject<String> matchingVolume;

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.setName("findEqualVol");
		inputParams.setLabel("Find Equal Volume");
		inputParams.add(candidateVol=new ParamVolumeCollection("Candidate Volumes"));
		inputParams.add(targetVolume=new ParamVolume("Target Volumes"));
		inputParams.setCategory("IACL.Utilities.Volume");
	}
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(matchingVolume=new ParamObject<String>("Matching Volume", new StringReaderWriter()));
	}
	protected void execute(CalculationMonitor monitor) {
		List<ImageData> candlist = candidateVol.getImageDataList();
		String out = "No Matches";

		System.out.println(targetVolume.getImageData());
		int l=0;
		boolean notfound=true;
		while(l<candlist.size() && notfound){
			System.out.println(candlist.get(l));
			if(candlist.get(l).getRows()==targetVolume.getImageData().getRows() &&
					candlist.get(l).getCols()==targetVolume.getImageData().getCols() &&
					candlist.get(l).getSlices()==targetVolume.getImageData().getSlices() &&
					candlist.get(l).getComponents()==targetVolume.getImageData().getComponents()){

				ImageData vol = candlist.get(l);
				boolean same = true;
				for(int i=0;i<vol.getRows();i++){
					for(int j=0;j<vol.getCols();j++){
						for(int k=0;k<vol.getSlices();k++){
							if(candlist.get(l).get(i, j, k).doubleValue()-targetVolume.getImageData().getDouble(i, j, k)<0.001){
								same=false;
							}
						}
					}
				}
				
				if(same){
					System.out.println(targetVolume.getName() + " <- " + vol.getName());
					out = candlist.get(l).getName();
					notfound=false;
				}
			}
			
			l++;
		}
		
		matchingVolume.setObject(out);
		matchingVolume.setFileName("Match.txt");

	
	}
	
}
