/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

import gov.nih.mipav.model.algorithms.utilities.AlgorithmReslice;
import gov.nih.mipav.model.structures.ModelImage;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmIsotropicReslice extends ProcessingAlgorithm{
	ParamVolume inVol;
	ParamVolume outVol;
	ParamOption interpMethod;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmIsotropicReslice.java,v 1.3 2009/03/25 16:35:38 blacklight Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inVol=new ParamVolume("Volume",null,-1,-1,-1,-1));
		inputParams.add(interpMethod=new ParamOption("Interpolation Method",new String[]{"Nearest Neighbor",
				 "Trilinear",
                 "Bspline 3rd order",
                 "Bspline 4th order",
                 "Cubic Lagrangian",
                 "Quintic Lagrangian",
                 "Heptic Lagrangian",
				 "Windowed Sinc"}));
		inputParams.setLabel("Reslice Volume - Isotropic");
		inputParams.setName("iso_reslice");
		inputParams.setCategory("IACL.Utilities.Volume");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("Resamples a volumetric image (using the specified interpolation method)" +
				" such that the resulting volume has isotropic volumes");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Isotropic Volume",null,-1,-1,-1,-1));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		InterpolationMethod interp=null;
		switch(interpMethod.getIndex()){
			case 0:interp=InterpolationMethod.NEAREST_NEIGHBOR;break;
			case 1:interp=InterpolationMethod.TRILINEAR;break;
			case 2:interp=InterpolationMethod.BSPLINE3;break;
			case 3:interp=InterpolationMethod.BSPLINE4;break;
			case 4:interp=InterpolationMethod.CUBIC_LAGRANGIAN;break;
			case 5:interp=InterpolationMethod.QUINTIC_LAGRANGIAN;break;
			case 6:interp=InterpolationMethod.HEPTIC_LAGRANGIAN;break; 
			case 7:interp=InterpolationMethod.WSINC;break;
		}
		outVol.setValue(IsotropicResample.resample(inVol.getImageData(),interp));
	}
	
}
