package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

import gov.nih.mipav.model.algorithms.utilities.AlgorithmMatchImages;

import java.util.List;
import java.util.ArrayList;



public class MedicAlgorithmMatchAllImages extends ProcessingAlgorithm{
	private ParamVolumeCollection matchus;
	private ParamVolume target;
	private ParamVolumeCollection matchedVols;
	private ParamBoolean doOrigins, doDims, resByRef;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmMatchAllImages.java,v 1.2 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	protected void createInputParameters(ParamCollection inputParams) {
		
		
		inputParams.add(matchus=new ParamVolumeCollection("Images to Match"));
		inputParams.add(target=new ParamVolume("Target Image"));
		inputParams.add(doOrigins=new ParamBoolean("Match Origings"));
		inputParams.add(doDims=new ParamBoolean("Match Dimensions"));
		inputParams.add(resByRef=new ParamBoolean("res By Ref"));
		doOrigins.setValue(true);
		doDims.setValue(true);
		resByRef.setValue(true);
		
		inputParams.setName("matchallimages");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Match All Images");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("Use the MIPAV 'Match Image' algorithm to match the " +
				"sizes/resolutions/origins for all volumes in a Volue Collection to a Target Volume");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		matchedVols = new ParamVolumeCollection("Matched Images");
		outputParams.add(matchedVols);
		
	}
	protected void execute(CalculationMonitor monitor) {
		
		List<ImageData> imgs = matchus.getImageDataList();
		ArrayList<ImageData> out = new ArrayList<ImageData>(imgs.size());
		
		resetHeaders(imgs);
		
		int l=0;
		for(ImageData vol : imgs){
			AlgorithmMatchImages alg = new AlgorithmMatchImages(target.getModelImage(), vol.getModelImage(), 
					doOrigins.getValue(),doDims.getValue(),resByRef.getValue());
				
			alg.runAlgorithm();
			out.add(new ImageDataMipav(alg.getResultB()));
			System.out.println("Completed " +l+"th volume");
			l++;
		}
		
		matchedVols.setValue(out);
	}
	
	private void resetHeaders(List<ImageData> imgs){
		for(ImageData vol: imgs){
			float[] res = {.828125f, .828125f, 2.2f};
			for(int i=0; i<vol.getSlices(); i++){
				vol.getModelImage().setResolutions(i, res);
			}
			
		}
	}
}
