package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageHeader;
import edu.jhu.ece.iacl.structures.image.ImageHeader.AxisOrientation;
import edu.jhu.ece.iacl.structures.image.ImageHeader.ImageOrientation;

/**
 * Sets the header information.
 * 
 * Only input values that are changed will be reflected in the header of the output
 * image.  I.e. If the default parameters are kept, then the output image will have the same 
 * header information as the input.  
 * 
 * @author John Bogovic
 *
 */
public class MedicAlgorithmSetHeaders extends ProcessingAlgorithm{
//	private ParamVolumeCollection in;
	private ParamFileCollection in;
	private ParamPointFloat res;
	private ParamPointFloat origin;
	private ParamOption imgorient;
	private ParamOption axorx;
	private ParamOption axory;
	private ParamOption axorz;
	
//	private ParamVolumeCollection out;
	private ParamFileCollection out;
	
	HashMap<String,String> axorMap;
	
	CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamFileCollection("Volumes in",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
//		inputParams.add(in=new ParamVolumeCollection("Mult-Component Volume FileCollection",null,-1,-1,-1,-1));
		inputParams.add(origin=new ParamPointFloat("Origin", new Point3f(-1f,-1f,-1f)));
		inputParams.add(res=new ParamPointFloat("Resolution", new Point3f(-1f,-1f,-1f)));
		
		inputParams.add(imgorient = new ParamOption("Image Orientation", new String[]{"AXIAL","CORONAL","SAGITTAL","UNKNOWN"}));
		imgorient.setValue(3);
		String[] orientations = new String[]{"UNKNOWN","RIGHT-LEFT", "LEFT-RIGHT", "POSTERIOR-ANTERIOR", "ANTERIOR-POSTERIOR", "INFERIOR-SUPERIOR", "SUPERIOR-INFERIOR"};
		inputParams.add(axorx = new ParamOption("X Axis Orientation", orientations));
		inputParams.add(axory = new ParamOption("Y Axis Orientation", orientations));
		inputParams.add(axorz = new ParamOption("Z Axis Orientation", orientations));
		
		inputParams.setName("setVolumeHeader");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Set Volume Header");
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(out=new ParamFileCollection("Volumes out",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
//		outputParams.add(out=new ParamVolumeCollection("Volumes Out",null,-1,-1,-1,-1));
	}
	
	protected void execute(CalculationMonitor monitor) {
		
//		ArrayList<ImageData> filesout = new ArrayList<ImageData>();
		ArrayList<File> filesout = new ArrayList<File>();
		
//		//set the output directory and create it if it doesn't exist
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){ e.printStackTrace(); }
		
		setMaps();
		
		ImageHeader hdr; 
//		for(ImageData img: in.getImageDataList()){
		for(File f: in.getValue()){
			ImageData img = rw.read(f);
			hdr = img.getHeader();
			
			//set the new header information
			//resolution
			Point3f respt = res.getValue();
			if(respt.x>0 && respt.y>0 && respt.z>0){
				hdr.setDimResolutions(new float[]{respt.x,respt.y,respt.z});
			}
			//origin
			Point3f origpt = origin.getValue();
			if(origpt.x>0 && origpt.y>0 && origpt.z>0){
				hdr.setOrigin(new float[]{origpt.x,origpt.y,origpt.z});
			}
			
			//axis orientations
			if(axorx.getIndex()>0 || axory.getIndex()>0 || axorz.getIndex()>0){
				AxisOrientation[] axisOrient = new AxisOrientation[3];
				//x
				if(axorx.getIndex()>0){ axisOrient[0]=AxisOrientation.valueOf(axorMap.get(axorx.getValue())); }
				else{ axisOrient[0]=hdr.getAxisOrientation()[0]; }
				//y
				if(axory.getIndex()>0){ axisOrient[1]=AxisOrientation.valueOf(axorMap.get(axory.getValue())); }
				else{ axisOrient[1]=hdr.getAxisOrientation()[1]; }
				//z
				if(axorz.getIndex()>0){ axisOrient[2]=AxisOrientation.valueOf(axorMap.get(axorz.getValue())); }
				else{ axisOrient[2]=hdr.getAxisOrientation()[2]; }
				
				hdr.setAxisOrientation(axisOrient);
			}
			
			//image orientation
//			hdr.setImageOrientation()
//			imgorient.getValue()
//			ImageOrientation.v
			if(imgorient.getIndex()<3){
				hdr.setImageOrientation(ImageOrientation.valueOf(imgorient.getValue())); 
			}
		
			img.setHeader(hdr);
			
			System.out.println(img.getHeader());
			
//			filesout.add(img);
			String name = img.getName();
			File f1 = new File(dir, edu.jhu.ece.iacl.utility.FileUtil.forceSafeFilename(name) + "."+rw.getExtensionFilter().getPreferredExtension());
			// write out the result
			System.out.println("Writing to file: " + f1);
			File f2 = rw.write(img, f1);
			if(f2!=null){
				filesout.add(f2);
				System.out.print("Success!\n");
			}
		}
		
		out.setValue(filesout);
		
	}

	private void setMaps(){
		axorMap = new HashMap<String,String>();
		axorMap.put("UNKNOWN", "UNKNOWN");
		axorMap.put("RIGHT-LEFT", "R2L_TYPE");
		axorMap.put("LEFT-RIGHT", "L2R_TYPE");
		axorMap.put("POSTERIOR-ANTERIOR", "P2A_TYPE");
		axorMap.put("ANTERIOR-POSTERIOR", "A2P_TYPE");
		axorMap.put("INFERIOR-SUPERIOR", "I2S_TYPE");
		axorMap.put("SUPERIOR-INFERIOR", "S2I_TYPE");
	}
	
}
