package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.util.ArrayList;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.file.FileInfoBase;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmVolumeToSlabs extends ProcessingAlgorithm {

	//output params
	private ParamFileCollection outputFiles;	// Files to be split

	//input params
	private ParamFileCollection inputFiles;		// Files to be split
	private ParamInteger numslabs;
	
	//Variables
	ArrayList<File> subVols;
	File outDir;
	CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmVolumeToSlabs.java,v 1.2 2008/12/23 01:23:29 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("Volumes To Slabs");
		inputParams.setName("VolumesToSlabs");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Converts a ");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	
		
		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Volume Files",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));				
		inputParams.add(numslabs= new ParamInteger("Number of Slabs"));
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outputFiles = new ParamFileCollection("Output Slabs",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
	}

	@Override
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		outDir = this.getOutputDirectory();//MipavController.getDefaultWorkingDirectory();
		CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();
		subVols = new ArrayList<File>();
		for(File f: inputFiles.getValue()){
			ImageData vol = rw.read(f);
			split(vol);
		}
		
		
		outputFiles.setValue(subVols);
		
	}
	
	private void split(ImageData vol){
		
		ArrayList<Integer> bounds = chooseSubsetBounds(vol);
		int ithstart=0;
		int boundind=0;
		
		for(int m=0; m<numslabs.getInt(); m++){

			//Determine number of rows this image will have...
			int ithlength = bounds.get(boundind)-ithstart+1;

			String name = vol.getName() + "_SlicesFrom_";
			if(ithstart<10){
				name += "00"+ithstart;
			}else if(ithstart>=10 && ithstart <100){
				name += "0"+ithstart;
			}else{
				name += ithstart;
			}
			ImageDataMipav nextvol = new ImageDataMipav(name,vol.getType(),vol.getRows(),
					vol.getCols(), ithlength);

			//Set appropriate values for this volume...
			int idx = 0;
			for(int k=ithstart;k<ithstart+ithlength;k++){
				for(int i=0;i<nextvol.getRows();i++){
					for(int j=0;j<nextvol.getCols();j++){
						nextvol.set(i, j, idx, vol.getDouble(i, j, k));
					}
				}
				idx++;
			}   
//
			
//			System.out.println("Completed " +m+"th slab.");
			//update header info
			ModelImage img=(nextvol).getModelImage();
			FileUtil.updateFileInfo(vol.getModelImage(),img);
			img.calcMinMax();
//			
//			//Write the volume to a file in the appropriate directory
			String fname = nextvol.getName();
//			System.out.println("got here " + rw);
			File f = new File(outDir, edu.jhu.ece.iacl.utility.FileUtil.forceSafeFilename(fname) + "."+rw.getExtensionFilter().getPreferredExtension());
			System.out.println("Completed " +m+"th slab.  Writing to file..." + f);
			File f2 = rw.write(nextvol, f);
			if(f2!=null){
				subVols.add(f2);
				System.out.print("Success!\n");
			}
		

			//and move on
			ithstart = bounds.get(boundind)+1;
			boundind++;
		}
	}

	// Breaks M (image size along input dim D) into N pieces
	private ArrayList<Integer> chooseSubsetBounds(ImageData vol){
		ArrayList<Integer> bounds = new ArrayList<Integer>();
		
		int M=vol.getSlices();
		
		int N = numslabs.getInt();
		System.out.println(N);
		System.out.println(M);
		
		if(N<=M)
			if(M>0){
				if(N==-1){		// N==-1 means we have a subcomponent for each slice
					for(int i=1; i<M; i++){
						bounds.add(i);
					}
				}else if(M%N==0){	//We can do something simple here.
					int bound = (M/N)-1;
					bounds.add(bound);
					bound+=(M/N);
					while(bound<M){
						bounds.add(bound);
						bound+=(M/N);
					}
				}else{	// have to add the 'extra' slices to the last group.
					int bound = (M/N)-1;
					bounds.add(bound);
					bound+=(M/N);
					int added = 1;
					while(bound<M){
						if(bound+(M/N)<M && added<N-1){
							bounds.add(bound);
							bound+=(M/N);
						}else{
							bounds.add(M-1);
							bound=M;
						}
					}
					added++;
				}
			}else{
				System.err.println("M must be > 0.  Check input dimension");
			}
		else{
			System.err.println("Number of subcomponents " + N + " must be <= than number" +
					" of slices " + M);
		}
		return bounds;
	}
}
