/**
 * 
 */
package edu.jhu.bme.smile.commons.math.specialFunctions;

import static org.junit.Assert.*;
import junit.framework.TestCase;

import org.junit.Test;


/**
 * @author bennett
 *
 */
public class SfuncTest extends TestCase {

	/**
	 * Test method for {@link edu.jhu.bme.smile.commons.math.specialFunctions.SFunc#factorial(int)}.
	 */
	@Test
	public void testFactorial() {
		assertEquals(1, SFunc.factorial(0));
		assertEquals(3628800, SFunc.factorial(10));
		assertEquals(0, SFunc.factorial(-10));			
	}

	/**
	 * Test method for {@link edu.jhu.bme.smile.commons.math.specialFunctions.SFunc#doubleFactorial(int)}.
	 */
	@Test
	public void testDoubleFactorial() {
		assertEquals(1.0, SFunc.doubleFactorial(0),10*Float.MIN_VALUE);
		assertEquals(1.0, SFunc.doubleFactorial(1),10*Float.MIN_VALUE);
		assertEquals(2.0, SFunc.doubleFactorial(2),10*Float.MIN_VALUE);
		assertEquals(3.0, SFunc.doubleFactorial(3),10*Float.MIN_VALUE);
		assertEquals(8.0, SFunc.doubleFactorial(4),10*Float.MIN_VALUE);
		assertEquals(15.0, SFunc.doubleFactorial(5),10*Float.MIN_VALUE);
		assertEquals(0, SFunc.doubleFactorial(-10),10*Float.MIN_VALUE);		
	}

	/**
	 * Test method for {@link edu.jhu.bme.smile.commons.math.specialFunctions.SFunc#factorialratio(int, int)}.
	 */
	@Test
	public void testFactorialratio() {
		assertEquals(1.0, SFunc.factorialratio(0, 0),10*Float.MIN_VALUE);
		assertEquals(30240, SFunc.factorialratio(10, 5),10*Float.MIN_VALUE);		
	}

}
