package edu.jhu.cs.cisst.algorithms.geometry.surface;

import javax.vecmath.Point2f;
import javax.vecmath.Vector2f;

import edu.jhu.cs.cisst.algorithms.util.DataOperations;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class ContourArray {
	public Point2f[] points;
	public int[] indexes;
	public double[][] vertexData = null;
	public double[][] edgeData = null;

	public ContourArray(Point2f[] pts, int[] indexes) {
		this.indexes = indexes;
		this.points = pts;
	}

	public void orient(float[][] img) {
		for (int i = 0; i < indexes.length; i += 2) {
			Point2f pt1 = points[indexes[i]];
			Point2f pt2 = points[indexes[i + 1]];
			Vector2f norm = DataOperations.gradient(img,
					0.5f * (pt1.x + pt2.x), 0.5f * (pt2.y + pt2.y));
			if (norm.x * (pt2.y - pt1.y) + norm.y * (pt1.x - pt2.x) > 0) {
				int tmp = indexes[i];
				indexes[i] = indexes[i + 1];
				indexes[i + 1] = tmp;
			}
		}
	}

	public void orient(ImageDataFloat img) {
		for (int i = 0; i < indexes.length; i += 2) {
			Point2f pt1 = points[indexes[i]];
			Point2f pt2 = points[indexes[i + 1]];
			Vector2f norm = DataOperations.gradient(img.toArray2d(),
					0.5f * (pt1.x + pt2.x), 0.5f * (pt2.y + pt2.y));
			if (norm.x * (pt2.y - pt1.y) + norm.y * (pt1.x - pt2.x) > 0) {
				int tmp = indexes[i];
				indexes[i] = indexes[i + 1];
				indexes[i + 1] = tmp;
			}
		}
	}

	public Point2f getCentroid(int id) {
		Point2f pt1 = points[indexes[id * 2]];
		Point2f pt2 = points[indexes[id * 2 + 1]];
		return new Point2f(0.5f * (pt1.x + pt2.x), 0.5f * (pt1.y + pt2.y));
	}

	public Point2f[] getEdgePoints(int id) {
		return new Point2f[] { new Point2f(points[indexes[id * 2]]),
				new Point2f(points[indexes[id * 2 + 1]]) };
	}

	public int getIndexCount() {
		return indexes.length;
	}

	public int getEdgeCount() {
		return indexes.length / 2;
	}

	public Point2f getVertex(int id) {
		return points[id];
	}

	public int getCoordinateIndex(int i) {
		return indexes[i];
	}
}
