/**
 * JIST Extensions for Computer-Integrated Surgery
 *
 * Center for Computer-Integrated Surgical Systems and Technology &
 * Johns Hopkins Applied Physics Laboratory &
 * The Johns Hopkins University
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.  The license is available for reading at:
 * http://www.gnu.org/copyleft/lgpl.html
 *
 * @author Blake Lucas
 */
package edu.jhu.cs.cisst.algorithms.segmentation.gac;

import java.util.LinkedList;
import java.util.List;

import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

// TODO: Auto-generated Javadoc
/**
 * The Interface ActiveContour3D.
 */
public interface ActiveContour3D {
	
	/**
	 * Sets the dice threshold.
	 *
	 * @param diceThreshold the new dice threshold
	 */
	public void setDiceThreshold(double diceThreshold);
	/**
	 * Sets the inner iterations.
	 * 
	 * @param innerIterations
	 *            the new inner iterations
	 */
	public void setInnerIterations(int innerIterations);
	/**
	 * Sets the outer iterations.
	 * 
	 * @param outerIterations
	 *            the new outer iterations
	 */
	public void setOuterIterations(int outerIterations);

	/**
	 * Gets the level set.
	 * 
	 * @return the level set
	 */
	public ImageDataFloat getLevelSet();
	

	/**
	 * Adds the force.
	 * 
	 * @param force
	 *            the force
	 */
	public void add(ActiveContourForce3D force);
	/**
	 * Gets the forces.
	 * 
	 * @return the forces
	 */
	public List<ActiveContourForce3D> getForces();

	/**
	 * Solve.
	 * 
	 * @param initialLevelset
	 *            the initial level set
	 * 
	 * @return the final level set
	 */
	public ImageDataFloat solve(ImageDataFloat initialLevelset);


	/**
	 * Attach topology rule to active contour.
	 * @param rule rule
	 */
	public void attachTopologyRule(TopologyRule3D rule);

}
