package edu.jhu.ece.iacl.jist.camino;

import imaging.B_VectorScheme;
import imaging.DW_Scheme;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;


//import edu.jhu.ece.iacl.plugins.dti.DW_Scheme;
//import edu.jhu.ece.iacl.plugins.dti.SchemeV1;

public class SchemeUtils {
	
	public static void writeSchemeXML(DW_Scheme DTIscheme, File outFileObj) {
		XStream xstream = new XStream(new Sun14ReflectionProvider());
//		xstream.alias("CaminoDWScheme-V1",DTIscheme.class);
		try {
			ObjectOutputStream out = xstream.createObjectOutputStream(new FileWriter(outFileObj));
			out.writeObject(DTIscheme);
			
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}
	}

	public static DW_Scheme readSchemeXML(File value) {
		// TODO Auto-generated method stub
		
		DW_Scheme DTIscheme = null;

		XStream xstream = new XStream(new Sun14ReflectionProvider());
//		xstream.alias("CaminoDWScheme-V1",imaging.DW_Scheme.class);
		try {
			ObjectInputStream in = xstream.createObjectInputStream(new FileReader(value));
			DTIscheme=(imaging.DW_Scheme)in.readObject();
			in.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}

		return DTIscheme;

	}
	
	public static void main(String [ ] args) {
		double [][]gradDir = new double[10][3];
		double []bVal = new double[10];
		bVal[0]=0; gradDir[0][0]=0;gradDir[0][1]=0;gradDir[0][2]=1;
		for(int i=1;i<10;i++) {
			bVal[i]=i; gradDir[i][0]=0==((i+2)%3)?1:0;gradDir[i][1]=0==((i+1)%3)?1:0;gradDir[i][2]=0==(i%3)?1:0;
		}
		B_VectorScheme scheme = new B_VectorScheme(gradDir, bVal);
		
		writeSchemeXML(scheme, new File("testScheme.xml"));
		DW_Scheme scheme2 = readSchemeXML(new File("testScheme.xml"));
		for(int i=0;i<10;i++) {
			System.out.println(i+": "+scheme2.getB_Value(i));
			double []g=scheme2.getG_Dir(i);
			System.out.println("\t"+g[0]+"\t"+g[1]+"\t"+g[2]);
		
		}
		System.out.println(scheme2.getClass().getCanonicalName());
	}
	
	

}
