/*
 *
 */
package edu.jhu.ece.iacl.plugins.dti;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import Jama.Matrix;

//import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities.InterpolationType;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleMtxReaderWriter;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
//import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRTCollection.FlirtWrapper;


/*
 * @author Min Chen (mchen55@jhu.edu)
 *
 */
public class MedicAlgorithmCombEPITransAndDeforms extends ProcessingAlgorithm{
	//Inputs
	public ParamFileCollection inParamDWtoB0Transform;
	public ParamVolume inParamEPICorrection;
	public ParamMatrix inParamRigidB0toStruct;
	
	//Outputs
	public ParamVolumeCollection outParamCombDefField;

	
	//Internal Variables
	int XN, YN, ZN; 
	//float[] dimRes;
	int chN = 3;
	ArrayDoubleReaderWriter mtxRW;
	ImageDataReaderWriter volRW; 
	
	//Other Variables
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Combines a set of transformation matrices and deformation fields into a single deformation field.";
	private static final String longDescription = "The transformations and deformations are applied in the order inputted.";


	protected void createInputParameters(ParamCollection inputParams) {
		mtxRW = ArrayDoubleReaderWriter.getInstance();
		volRW = ImageDataReaderWriter.getInstance(); 
		
		FileExtensionFilter newExtFilter = new FileExtensionFilter();
		newExtFilter.getExtensions().addAll(mtxRW.getExtensionFilter().getExtensions());
		newExtFilter.getExtensions().addAll(volRW.getExtensionFilter().getExtensions());
		newExtFilter.getExtensions().add("mtx");

		
		Matrix identityMtx = new Matrix(4,4);
		for(int i = 0; i < 4; i++){
			identityMtx.set(i,i,1);
		}
		
		
		inputParams.add(inParamDWtoB0Transform=new ParamFileCollection("DW direction to B0 Transformations",new FileExtensionFilter(new String[]{"mtx"})));
		inParamDWtoB0Transform.setMandatory(false);
		inputParams.add(inParamRigidB0toStruct=new ParamMatrix("Rigid B0 to Structural Transformation",identityMtx));
		inParamRigidB0toStruct.setMandatory(false);
		inputParams.add(inParamEPICorrection = new ParamVolume("EPI Distortion Correction Field"));
		inParamEPICorrection.setMandatory(false);
		//inputParams.add(inParamMatrix = new ParamMatrix("Transformation Matrix", 4, 4));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Combine EPI Transformations and Deformations");
		inputParams.setName("CombEPITransAndDef");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Min Chen", "", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamCombDefField=new ParamVolumeCollection("Combined Deformation Fields",null,-1,-1,-1,3));
		outParamCombDefField.setLoadAndSaveOnValidate(false);
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ExecuteWrapper wrapper=new ExecuteWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);
	}


	protected class ExecuteWrapper extends AbstractCalculation{
		public void execute(ProcessingAlgorithm alg){
			this.setLabel("combine Volumes");
			
			ImageData EPICorrectDef = inParamEPICorrection.getImageData(); 
			
			ImageData currentDef;
			//ImageData[] EPICorrectDefSplit = RegistrationUtilities.split4DImageDataIntoArray(EPICorrectDef);
			XN = EPICorrectDef.getRows();
			YN = EPICorrectDef.getCols();
			ZN = EPICorrectDef.getSlices();

			//dimRes = EPICorrectDef.getHeader().getDimResolutions();
			//Matrix inMatrix =  inParamMatrix.getValue(); 
			
			//currentDef = applyTransformation(currentDef, inMatrix);
			
			//List<File> DWtoB0Trans = inParamDWtoB0Transform.getValue();
			//List<File> correctDWtoStructTrans = inParamTransDWCorrectedToStruct.getValue();
			ArrayList<double[][]> arrayDWtoB0Trans = readMultiMatrices(inParamDWtoB0Transform.getValue());
			if(arrayDWtoB0Trans.size() == 0){
				double[][] identityMtxD = new double[4][4];
				for(int i = 0; i < 4; i++){
					identityMtxD[i][i]=1;
				}
				arrayDWtoB0Trans.add(identityMtxD);
			}
			
			
			//ArrayList<double[][]> arraycorrectDWtoStructTrans = readMultiMatrices(inParamRigidB0toStruct.getValue());
			Matrix m;
			Matrix rigidB0toStruct = inParamRigidB0toStruct.getValue();
			double[][] matarray;
			//if (arrayDWtoB0Trans.size() != arraycorrectDWtoStructTrans.size()) System.out.format("Transform Size Mismatch!");
			
			for (int i = 0; i < arrayDWtoB0Trans.size(); i++){
				//File currentFile = DWtoB0Trans.get(i);
				//apply transformations or deformations one by one
				//currentDef = new ImageDataFloat[chN];
				 
				
					m = new Matrix(4,4);
					matarray = arrayDWtoB0Trans.get(i);
					if(matarray.length!=4 || matarray[0].length!=4){
						System.err.println(getClass().getCanonicalName()+"Invalid transformation - must be 4x4");
					}else{
						for(int k=0; k<matarray.length; k++){
							for(int j=0; j<matarray[0].length; j++){
								m.set(k, j, matarray[k][j]);
							}
						}
					}
				
					m = rigidB0toStruct.times(m);
				for(int k=0;k<4;k++)for(int l=0;l<4;l++)System.out.format(m.get(k,l)+"\n");
					
				//create deformation from transformation matrix
				currentDef=RegistrationUtilities.createDefFieldFromTransMatrix(m, EPICorrectDef);
				//combine with deformation field
				currentDef=RegistrationUtilities.composeDeformations(currentDef, EPICorrectDef);
				
				
				currentDef.setName(inParamEPICorrection.getImageData().getName().replace(".","_") + "_combDefField");
				currentDef.setHeader(inParamEPICorrection.getImageData().getHeader());
				
				
				//ImageData outVolume = RegistrationUtilities.combineImageDataArrayTo4D(currentDef);
				//outVolume.setHeader(inParamEPICorrection.getImageData().getHeader());
				//outVolume.setName(inParamDWtoB0Transform.getValue().get(i).getName().replace(".","_") + "_combDefField");
				outParamCombDefField.add(currentDef);
				outParamCombDefField.writeAndFreeNow(alg);

			}
			
		}
	}
	
	private ArrayList<double[][]> readMultiMatrices(List<File> files){
		ArrayDoubleMtxReaderWriter rw = new ArrayDoubleMtxReaderWriter();
		ArrayList<double[][]> allxfms = new ArrayList<double[][]>(files.size());
		int i=0;
		while(i<files.size()){
			allxfms.add(rw.read(files.get(i)));
			i++;
		}
		return allxfms;
	}
	/*
	public ImageData[] applyDeformation(ImageData[] currentDef, ImageData[] epiDef){
		double[] currentVec = new double[chN];
		double[] newVec = new double[chN];
		
		ImageData[] newDef = new ImageDataFloat[chN];
		for (int c = 0; c < chN; c++) newDef[c] = currentDef[c].clone();
		

		for(int i = 0; i < XN; i++)
			for(int j = 0; j < YN; j++)
				for(int k = 0; k < ZN; k++){
					
					for(int c = 0; c < chN; c++) newVec[c] = epiDef[c].getDouble(i, j, k); 
					
					//get current deformation at where the new deformation is pointing
					for(int c = 0; c < chN; c++) currentVec[c] = RegistrationUtilities.Interpolation(currentDef[c], XN, YN, ZN, 
							newVec[0]+i, newVec[1]+j, newVec[2]+k, InterpolationType.TRILINEAR); 
					
					for(int c = 0; c < chN; c++) newDef[c].set(i,j,k, newVec[c]+currentVec[c]);
					
				}
		return newDef;			
		
	}
	*/
	
}