package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractDOTSCC extends ProcessingAlgorithm{
	private ParamVolume in;
	//private ParamVolume fa; //for header
	private ParamVolume ccf;
	private ParamVolume ccp;
	private ParamVolume ccs;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Extract DOTS CST labels";
	private static final String longDescription = "";
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("DOTS 4D Volume",null,-1,-1,-1,-1));
		//inputParams.add(fa=new ParamVolume("for header use",null,-1,-1,-1,-1));
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Extract DOTS CC");
		inputParams.setName("Extract_DOTS_CC");
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(ccf=new ParamVolume("CCF label",null,-1,-1,-1,1));
		outputParams.add(ccp=new ParamVolume("CCP label",null,-1,-1,-1,1));
		outputParams.add(ccs=new ParamVolume("CCS label",null,-1,-1,-1,1));
	}
	protected void execute(CalculationMonitor monitor) {
		ImageData vol = in.getImageData();
        ImageHeader hdr = vol.getHeader();
        int CCF = 4;
        int CCP = 5;
        int CCS = 6;

        //ImageDataMipav labelSCPL = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        //ImageDataMipav labelSCPR = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelCCF = new ImageDataMipav(vol.getName()+"_CCF_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelCCP = new ImageDataMipav(vol.getName()+"_CCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelCCS = new ImageDataMipav(vol.getName()+"_CCS_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelCCF.set(i, j, k, vol.getDouble(i, j, k, CCF));
					labelCCP.set(i, j, k, vol.getDouble(i, j, k, CCP));
					labelCCS.set(i, j, k, vol.getDouble(i, j, k, CCS));
				}
			}
		}
        labelCCF.setHeader(hdr);
        //ccf.setName(vol.getName()+"_CCF_labels");
        ccf.setValue(labelCCF);
        
        labelCCP.setHeader(hdr);
        //ccp.setName(vol.getName()+"_CCP_labels");
        ccp.setValue(labelCCP);
        
        labelCCS.setHeader(hdr);
       // ccs.setName(vol.getName()+"_CCS_labels");
        ccs.setValue(labelCCS);
        
        


        System.out.println("Finished");

	}
}

