package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractDOTSCST extends ProcessingAlgorithm{
	private ParamVolume in;
	private ParamOption atlas;
	//private ParamVolume fa; //for header
	private ParamVolume cstl;
	private ParamVolume cstr;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Extract DOTS CST labels";
	private static final String longDescription = "";
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("DOTS 4D Volume",null,-1,-1,-1,-1));
		String[] sel = {"atlas 39","atlas 37"};
		inputParams.add(atlas=new ParamOption("Atlas Type", sel));
		atlas.setValue("atlas 39");
		//inputParams.add(fa=new ParamVolume("for header use",null,-1,-1,-1,-1));
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Extract DOTS CST");
		inputParams.setName("Extract_DOTS_CST");
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(cstl=new ParamVolume("CSTL label",null,-1,-1,-1,1));
		outputParams.add(cstr=new ParamVolume("CSTR label",null,-1,-1,-1,1));
	}
	protected void execute(CalculationMonitor monitor) {
		ImageData vol = in.getImageData();
        ImageHeader hdr = vol.getHeader();
        int CSTL, CSTR;
        if(atlas.getValue().equals("atlas 39")){
        	CSTL = 11;
        	CSTR = 12;
        }
        else{
        	CSTL = 9;
        	CSTR = 10;
        }

        //ImageDataMipav labelSCPL = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        //ImageDataMipav labelSCPR = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        ImageDataMipav labelCSTL = new ImageDataMipav(vol.getName()+"_CSTL_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelCSTL.set(i, j, k, vol.getDouble(i, j, k, CSTL));
				}
			}
		}
        labelCSTL.setHeader(hdr);
        //cstl.setName(vol.getName()+"_CSTL_labels");
        cstl.setValue(labelCSTL);
        
        ImageDataMipav labelCSTR = new ImageDataMipav(vol.getName()+"_CSTR_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
    	
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					labelCSTR.set(i, j, k, vol.getDouble(i, j, k, CSTR));
				}
			}
		}
        labelCSTR.setHeader(hdr);
        //cstr.setName(vol.getName()+"_CSTR_labels");
        cstr.setValue(labelCSTR);
        


        System.out.println("Finished");

	}
}

