package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.io.File;
import java.io.IOException;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.jist.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.jist.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.structures.fiber.Fiber;
import edu.jhu.ece.iacl.jist.structures.fiber.FiberCollection;

public class MedicAlgorithmSubFibers extends ProcessingAlgorithm{
	
	private ParamObject<FiberCollection> fiberset;
	private ParamInteger sampling;
	
	private ParamObject<FiberCollection> fibersetout;
	
	private ArrayDoubleTxtReaderWriter arw = ArrayDoubleTxtReaderWriter.getInstance();
	//similarity table and center of mass
	private FiberCollectionReaderWriter fcrw = FiberCollectionReaderWriter.getInstance();
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Fibers Subsampling";
	private static final String longDescription = "";
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fiberset = new ParamObject<FiberCollection>("Fiber Set to Cluster", new FiberCollectionReaderWriter()));
		inputParams.add(sampling = new ParamInteger("Subsampling factor", 4));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI.Fiber");
		inputParams.setLabel("Fiber Subsampling");
		inputParams.setName("Fiber_Subsampling");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setAffiliation("Johns Hopkins University, Department of Electrical and Computer Engineering");
		info.setDescription(shortDescription);
		info.setLongDescription(longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(fibersetout = new ParamObject<FiberCollection>("Fiber Set Thresholded", new FiberCollectionReaderWriter()));
	}

	protected void execute(CalculationMonitor monitor)
	throws AlgorithmRuntimeException {
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		System.out.println("Subsampling started");
		FiberCollection fibers = fiberset.getObject();
		System.out.println("Number of input fibers: " + fibers.size());
		
		FiberCollection fiberOut = new FiberCollection();
		
		Point3f res = fiberset.getObject().getResolutions();
		fiberOut.setResolutions(res);
		fiberOut.setDimensions(fibers.getDimensions());
		fiberOut.setName(fibers.getName()+"_"+sampling.getInt()+"_subsampled");
		
		int index = 0;
		for(Fiber f:fibers){
			if(index%sampling.getInt() == 0){
				fiberOut.add(f);
			}
			index++;
		}
		System.out.println("Number of output fibers: " + fiberOut.size());
		
		fibersetout.setObject(fiberOut);
		System.out.println("Writing fibers");
		
		File f = writeFibers(fiberOut,dir);
		System.out.println("Subsampling by " + sampling.getInt()+" finished");
	}
	
	private File writeFibers(FiberCollection fibers, File dir){
		File out = null;
		out = fcrw.write(fibers, dir);
		return out;
	}
}
