package edu.jhu.ece.iacl.plugins.labeling.simulation;

import edu.jhu.ece.iacl.algorithms.manual_label.simulation.SyntheticLabeling;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataInt;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;

public class AlgorithmSyntheticLabeling extends ProcessingAlgorithm {
	
	public ParamOption typeParam;
	public ParamVolume imgParam;
	public ParamInteger nobjParam;
	public ParamInteger randseed;
	
	public ParamVolume imgOut;
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Creates a labeling";
	private static final String longDescription = "";

	
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(imgParam=new ParamVolume("Template Image",null,-1,-1,-1,-1));
		inputParams.add(nobjParam=new ParamInteger("Number of Objects",8));
		inputParams.add(typeParam=new ParamOption("Type", new String[]{"Voxelwise Random", "Small circles", "Big circles"}));
		inputParams.add(randseed=new ParamInteger("Random Seed",-1));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Labeling.Sim");
		inputParams.setLabel("Synthetic Labling");
		inputParams.setName("Synthetic_Labeling");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.NotFunctional);
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(imgOut=new ParamVolume("Image Out",null,-1,-1,-1,-1));
	}
	
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ImageData templateimg = imgParam.getImageData();
		ImageHeader hdr = templateimg.getHeader();
		int nx = templateimg.getRows();
		int ny = templateimg.getCols();
		int nz = templateimg.getSlices();
		
		int nobj = nobjParam.getInt();
		
		String typestr = typeParam.getValue();
		int[][] 	result2d = null;
		int[][][] 	result3d = null;
		if(typestr.equals("Voxelwise Random")){
			if(nz==1){
				result2d = SyntheticLabeling.genRandom(nx,ny,nobj);
			}else{
				result3d = SyntheticLabeling.genRandom(nx,ny,nz,nobj);
			}
		}
		
		
		ImageDataInt imgdatout = null;
		if(nz==1){
			imgdatout = new ImageDataInt(result2d);
		}else{
			imgdatout = new ImageDataInt(result3d);
		}
		imgdatout.setName("SytheticLabeling");
		imgdatout.setHeader(hdr);
		
		imgOut.setValue(imgdatout);
		
	}

}
