package edu.jhu.ece.iacl.plugins.qualitycontrol;

//import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample;
import edu.jhu.ece.iacl.algorithms.volume.IsotropicResample.InterpolationMethod;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataDouble;

import java.io.File;
import java.io.IOException;
import java.util.List;


public class MedicAlgorithmQualityVolumeCollection extends ProcessingAlgorithm{
	private ParamVolumeCollection inParamVolumes;
	private ParamBoolean inParamCropToBoundingBox;
	private ParamInteger inParamSliceNumber;
	private ParamOption inParamPassCondition,inParamMonitorType;	
	private ParamDouble inParamUpperRange, inParamLowerRange,inParamN;
	private ParamFileCollection outSnapShots;
	private ParamBoolean outTestPassed;


	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Takes a snap shot of a segmentation and checks if a derived measurement is within range";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamVolumes=new ParamVolumeCollection("Volumes to Monitor"));
		inputParams.add(inParamSliceNumber=new ParamInteger("Slice Number to Monitor (-1 for All Slices)",-1));
		inputParams.add(inParamCropToBoundingBox=new ParamBoolean("Crop to Union of Bounding Boxes"));
		String[] monitorType = {"Total Voxels of Label N", "Total Volume of Label N", "Average Intensity Under Label N"};
		inputParams.add(inParamMonitorType=new ParamOption("Monitor Type",monitorType));
		inputParams.add(inParamN=new ParamDouble("N",0));
		String[] passConditions = {"Inside Range", "Outside Range", "Above Upper Range", "Below Lower Range"}; 
		inputParams.add(inParamPassCondition=new ParamOption("Monitor Pass When",passConditions));
		inputParams.add(inParamUpperRange=new ParamDouble("Upper Range",0));
		inputParams.add(inParamLowerRange=new ParamDouble("Lower Range",0));
		inputParams.setPackage("IACL");
		inputParams.setCategory("Quality Control");
		inputParams.setLabel("Quality Control - Volume Collection");
		inputParams.setName("QC_Volumes");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSnapShots = new ParamFileCollection("Center of mass Snapshot of Result"));
		outputParams.add(outTestPassed = new ParamBoolean("Quality Control Passed"));
	}


	protected void execute(CalculationMonitor monitor) {
		//draw snapshot at center of mass
		
		
		List<ImageData> volList = inParamVolumes.getImageDataList();
		int[] boundingBox= new int[6]; 
		int XN = volList.get(0).getRows();
		int YN = volList.get(0).getCols();
		int ZN = volList.get(0).getSlices();
		int numOfVoxels = 0;
		double val;
		double bgVal=0;
		
		//set as smallest
		boundingBox[0] = XN-1;
		boundingBox[1] = 0;
		boundingBox[2] = YN-1;
		boundingBox[3] = 0;
		boundingBox[4] = ZN-1;
		boundingBox[5] = 0;		
		
		if(inParamCropToBoundingBox.getValue()){
			//find union of bounding boxes if checked
			int[] currentboundingBox = new int[6];
			ImageData union=volList.get(0).mimic();
			for(ImageData v: volList){
				currentboundingBox = RegistrationUtilities.calculateBoundingBox(v, v, 0);
				System.out.format(v.getName() + " " + currentboundingBox[0] + " " + currentboundingBox[1] + " " +  currentboundingBox[2] 
				     + " " +  currentboundingBox[3] + " " +  currentboundingBox[4] + " " +  currentboundingBox[5] + "\n");

				boundingBox[0] = Math.min(currentboundingBox[0], boundingBox[0]);
				boundingBox[1] = Math.max(currentboundingBox[1], boundingBox[1]);
				boundingBox[2] = Math.min(currentboundingBox[2], boundingBox[2]);
				boundingBox[3] = Math.max(currentboundingBox[3], boundingBox[3]);
				boundingBox[4] = Math.min(currentboundingBox[4], boundingBox[4]);
				boundingBox[5] = Math.max(currentboundingBox[5], boundingBox[5]);
				
				/*
				for(int i = 0; i < XN; i++)
					for(int j = 0; j < YN; j++)
						for(int k = 0; k < ZN; k++){
							val = v.getDouble(i, j, k);
							if(val <= bgVal || Double.isNaN(val)) val = 0;
							val = Math.max(union.getDouble(i, j, k), v.getDouble(i, j, k));
							union.set(i,j,k, val);
				}
				*/					
			}
		}else{//else set as full image
			boundingBox[0] = 0;
			boundingBox[1] = XN-1;
			boundingBox[2] = 0;
			boundingBox[3] = YN-1;
			boundingBox[4] = 0;		
			boundingBox[5] = ZN-1;
		}
			
		System.out.format("Final Bounding:" + boundingBox[0] + " " + boundingBox[1] + " " +  boundingBox[2] 
		  + " " +  boundingBox[3] + " " +  boundingBox[4] + " " +  boundingBox[5] + "\n");
		
		
		writeSnapshots(boundingBox);
		
		/*
		//calculate metric
		double metric = 0; 
		switch(inParamMonitorType.getIndex()){
		case 0: //Total Voxels of Label N
			metric = findNumOfVoxelsWithLabel(inParamN.getInt());
			break;
		case 1: //Total Volume of Label N 
			metric = findNumOfVoxelsWithLabel(inParamN.getInt());			
			float[] res = inParamSegmentation.getImageData().getHeader().getDimResolutions();
			metric = metric*res[0]*res[1]*res[2];
			break;
		case 2: //Average Intensity Under Label N	
			metric = findIntensityUnderLabel(inParamN.getInt());
			break;
		}
		
		System.out.format("Metric" + metric + "\n");

		//check if metric passes condition
		double upperD = inParamUpperRange.getDouble();
		double lowerD = inParamLowerRange.getDouble();
		outTestPassed.setValue(false);//we set as fail by default and set true if it passes

		switch(inParamPassCondition.getIndex()){
		case 0: //Inside Range   
			if(metric < upperD && metric > lowerD) outTestPassed.setValue(true);
			break;
		case 1: //Outside Range
			if(metric > upperD && metric < lowerD) outTestPassed.setValue(true);
			break;
		case 2: //Above Upper Range
			if(metric > upperD) outTestPassed.setValue(true);
			break;
		case 3: //Below Lower Range
			if(metric < lowerD) outTestPassed.setValue(true);
			break;
		default:
			outTestPassed.setValue(false);
			break;
		}
		*/
	}
	
	/*
	protected double findIntensityUnderLabel(int N){
		ImageData seg = inParamSegmentation.getImageData();
		ImageData intensity = inParamIntensity.getImageData();
		int XN = seg.getRows();
		int YN = seg.getCols();
		int ZN = seg.getSlices();
		double intensitySum = 0;
		int counter = 0; 
		for(int i = 0; i < XN; i++)
			for(int j = 0; j < YN; j++)
				for(int k = 0; k < ZN; k++){
					if(seg.getInt(i, j, k) == N)intensitySum+= intensity.getDouble(i, j, k);
					counter++;
				}
		return intensitySum/counter;
	}
	
	protected int findNumOfVoxelsWithLabel(int N){
		ImageData seg = inParamSegmentation.getImageData(); 
		int XN = seg.getRows();
		int YN = seg.getCols();
		int ZN = seg.getSlices();
		int numOfVoxels = 0;
		
		for(int i = 0; i < XN; i++)
			for(int j = 0; j < YN; j++)
				for(int k = 0; k < ZN; k++){
					if(seg.getInt(i, j, k) == N)numOfVoxels++;
				}

		return numOfVoxels; 
	}
	*/
	protected void writeSnapshots(int[] boundingBox) {
		File outputDir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		
		try{
			if(!outputDir.isDirectory()){
				(new File(outputDir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}

		
		List<ImageData> volList = inParamVolumes.getImageDataList();
		//double[] segMaxMin = RegistrationUtilities.calculateMinAndMaxVals(seg, seg);
		//double[] intensityMaxMin = RegistrationUtilities.calculateMinAndMaxVals(intensity, intensity);
		int counter=0;
		outSnapShots.setLoadAndSaveOnValidate(false);
		ImageDataReaderWriter imageRW = new ImageDataReaderWriter();
		for(ImageData v: volList){
		//double[] segMaxMin = calculateMinAndMaxVals(v, v);
		
		double[][] snapshot = new double[boundingBox[1]-boundingBox[0]+1][boundingBox[3]-boundingBox[2]+1];//create output snapshot
		//write screenshots at At Slice k = 
		//X-Y slice first
		int k = inParamSliceNumber.getInt();
		for(int i = boundingBox[0]; i <= boundingBox[1]; i++)
			for(int j = boundingBox[2]; j <= boundingBox[3]; j++){
				snapshot[i-boundingBox[0]][j-boundingBox[2]] = v.getDouble(i, j, k);
			}
		
		ImageData out = new ImageDataDouble(snapshot);
		out.setHeader(volList.get(0).getHeader());
		//out = IsotropicResample.resample(out, InterpolationMethod.NEAREST_NEIGHBOR);
		File outFile = new File(outputDir+File.separator+"Image_"+counter+"_"+v.getName()+".png");
		imageRW.write(out, outFile);
		outSnapShots.add(outFile);
		counter++;
		}
	
	}
	
	
	//Calculate Max and Min of the two images
	static public double[] calculateMinAndMaxVals(ImageData sub, ImageData tar) {

		int ch;
		int CH;
		int i, j, k;
		int x = 0, y = 0, z = 0;
		int mx = 0, my = 0, mz = 0;

		int XN, YN, ZN;
		XN = sub.getRows();
		YN = sub.getCols();
		ZN = sub.getSlices();
		double MinandMaxValsD[] = new double[2];
		double max = Double.NEGATIVE_INFINITY;
		double min = Double.POSITIVE_INFINITY;
		for (i = 0; i < XN; i++) {
			for (j = 0; j < YN; j++) {
				for (k = 0; k < ZN; k++) {

					if (sub.getDouble(i, j, k) > max) {
						max = sub.getDouble(i, j, k);
						mx = i;
						my = j;
						mz = k;
					}
					if (sub.getDouble(i, j, k) < min) {
						min = sub.getDouble(i, j, k);
						x = i;
						y = j;
						z = k;
					}
					if (tar.getDouble(i, j, k) > max) {
						max = tar.getDouble(i, j, k);
						mx = i;
						my = j;
						mz = k;
					}
					if (tar.getDouble(i, j, k) < min) {
						min = tar.getDouble(i, j, k);
						x = i;
						y = j;
						z = k;
					}

				}
			}
		}

		MinandMaxValsD[0] = min;
		MinandMaxValsD[1] = max;
		//System.out.format("Max: " + MinandMaxValsD[0] + " Min" + MinandMaxValsD[1] + "\n");
		return MinandMaxValsD;

	}


}
