/*
 *
 */
package edu.jhu.ece.iacl.plugins.registration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import Jama.Matrix;

//import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities.InterpolationType;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleMtxReaderWriter;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
//import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRTCollection.FlirtWrapper;


/*
 * @author Min Chen (mchen55@jhu.edu)
 *
 */
public class MedicAlgorithmMultiplyTransByMatrix extends ProcessingAlgorithm{
	//Inputs
	public ParamFileCollection inParamTransforms;
	public ParamMatrix inParamLeftMatrix,inParamRightMatrix;
	public ParamModel test;
	//Outputs
	public ParamFileCollection outParamMultipliedTransforms;

	
	//Internal Variables
	int XN, YN, ZN; 
	int chN = 3;
	File dir;
	ArrayDoubleMtxReaderWriter mtxRW;

	
	//Other Variables
	private static final String revnum = RegistrationUtilities.getVersion();
	private static final String shortDescription = "Multiplies a set of transformation matrices by a left or right matrix.";
	private static final String longDescription = "Multiplies a set of transformation matrices by a left or right matrix. Outputs a set of matrices.";


	protected void createInputParameters(ParamCollection inputParams) {
		//Set initial matrices as identity.(You do need two separate ones or setting one will affect the other).
		Matrix identityLeftMtx = new Matrix(4,4);
		Matrix identityRightMtx = new Matrix(4,4);
		for(int i = 0; i < 4; i++){
			identityLeftMtx.set(i,i,1);
			identityRightMtx.set(i,i,1);
		}
		
		inputParams.add(inParamLeftMatrix=new ParamMatrix("Matrix to Left Multiply By (Optional)",identityLeftMtx));
		inputParams.add(inParamTransforms=new ParamFileCollection("Transformations Matrices to Multiply",new FileExtensionFilter(new String[]{"mtx"})));

		inputParams.add(inParamRightMatrix=new ParamMatrix("Matrix to Right Multiply By (Optional)",identityRightMtx));
		
		//inputParams.add(inParamMatrix = new ParamMatrix("Transformation Matrix", 4, 4));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Registration.Volume");
		inputParams.setLabel("Multiply Transformation Matrices");
		inputParams.setName("MultTransMatx");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Min Chen", "", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamMultipliedTransforms=new ParamFileCollection("Multiplied Transformations", new FileExtensionFilter(new String[]{"mtx","xfm"})));
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ExecuteWrapper wrapper=new ExecuteWrapper();
		monitor.observe(wrapper);
		mtxRW = new ArrayDoubleMtxReaderWriter();
		dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		wrapper.execute(this);
	}


	protected class ExecuteWrapper extends AbstractCalculation{
		public void execute(ProcessingAlgorithm alg){
			this.setLabel("combine Volumes");
			
			ArrayList<double[][]> transforms = readMultiMatrices(inParamTransforms.getValue());
			//ArrayList<double[][]> arraycorrectDWtoStructTrans = readMultiMatrices(inParamRigidB0toStruct.getValue());
			Matrix m,finalMatrix;
			Matrix leftMatrix = inParamLeftMatrix.getValue();
			Matrix rightMatrix = inParamRightMatrix.getValue();
			double[][] matarray;

			
			//set as identify if null
			if(leftMatrix == null){
				leftMatrix = new Matrix(4,4);
				for(int i = 0; i < 4; i++) leftMatrix.set(i,i,1);				
			}
			
			if(rightMatrix == null){
				rightMatrix = new Matrix(4,4);
				for(int i = 0; i < 4; i++) rightMatrix.set(i,i,1);				
			}

			
			
			//check column dimensions
			if (leftMatrix.getColumnDimension() == 4 && rightMatrix.getRowDimension() == 4){
				ArrayList<File> mtxs = new ArrayList<File>();
				
				for (int c= 0; c < transforms.size(); c++){
					//File currentFile = DWtoB0Trans.get(i);
					//apply transformations or deformations one by one
	
						m = new Matrix(4,4);
						matarray = transforms.get(c);
						if(matarray.length!=4 || matarray[0].length!=4){
							System.err.println(getClass().getCanonicalName()+"Invalid transformation - must be 4x4");
						}else{
							for(int k=0; k<matarray.length; k++){
								for(int j=0; j<matarray[0].length; j++){
									m.set(k, j, matarray[k][j]);
								}
							}
						}
						
						for(int i=0;i<4;i++){
							for(int j=0;j<4;j++){
								System.out.format(leftMatrix.get(i,j)+"\n");
							}
						}
						
						for(int i=0;i<4;i++){
							for(int j=0;j<4;j++){
								System.out.format(rightMatrix.get(i,j)+"\n");
							}
						}



						finalMatrix = leftMatrix.times(m.times(rightMatrix));

						//write to file
						double[][] tmp=new double[4][4];
						for(int i=0;i<4;i++){
							for(int j=0;j<4;j++){
								tmp[i][j] = finalMatrix.get(i, j);
							}
						}
						
						File f=null;
						File ff=null;
						try {
							f = new File(dir.getCanonicalPath()+File.separator+c+"multiplied.mtx");
							ff = mtxRW.write(tmp, f);
						} catch (IOException e) {
							e.printStackTrace();
						}
						if(ff!=null){
							mtxs.add(ff);
						}	
						
						
				}
				
				outParamMultipliedTransforms.setValue(mtxs);
				
			}
			else{
				System.out.format("Invalid dimensions for multiplied matrices");
			}

			
		}
	}
	
	private ArrayList<double[][]> readMultiMatrices(List<File> files){
		ArrayDoubleMtxReaderWriter rw = new ArrayDoubleMtxReaderWriter();
		ArrayList<double[][]> allxfms = new ArrayList<double[][]>(files.size());
		int i=0;
		while(i<files.size()){
			allxfms.add(rw.read(files.get(i)));
			i++;
		}
		return allxfms;
	}
	
}