/*
 *
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile.DialogType;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;

import java.io.File;
import java.util.Vector;
import java.util.Collections;

import javax.swing.ProgressMonitor;
/*
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class MedicAlgorithmDeserializeVolumes extends ProcessingAlgorithm{
	ParamVolumeCollection outcoll;
	ParamFile directory;
	ParamVolume volume;
	ParamInteger index;
	ParamBoolean	delete;

	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(true);
		inputParams.add(volume=new ParamVolume("Volume",null,-1,-1,-1,-1));
		
		inputParams.add(directory=new ParamFile("Collection directory", DialogType.DIRECTORY));
		
		inputParams.add(index=new ParamInteger("Max index",0));

		inputParams.add(delete=new ParamBoolean("delete intermediate results",true));


		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Logic");
		inputParams.setLabel("De-serialize Volumes");
		inputParams.setName("Deserialize_Volumes");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outcoll=new ParamVolumeCollection("Collection",null,-1,-1,-1,-1));
		outcoll.setMandatory(false);		
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		System.out.println("find the previously collected volumes");
		
		// select every image in directory as collection
		ParamVolumeCollection incoll = findCollectionFiles();
		
		System.out.println(" number: "+incoll.size());

		
		if (incoll.size()>=index.getInt() && delete.getValue()) {
			// empty the result directory (to reset the counter)
			File dir = directory.getValue();
			
			File[] files = dir.listFiles();
			for (File f : files) {
				if (f.isFile()) {
					f.delete();
				}
			}
			// reset the collection to zero
			incoll.clear();
		}
		
		// add the new volume
		incoll.add(volume.getValue());
		
		System.out.println(" added: "+incoll.size());
		
		// write to directory; if collection is sufficiently big, pass the parameter
		System.out.println("write image data to: "+directory.getURI());
		
		volume.setLoadAndSaveOnValidate(false);
		volume.getImageData();
		volume.writeAndFreeNow(directory.getValue());
		
		
		if (incoll.size()>=index.getInt()) {
			outcoll.setValue(incoll.getValue());
		}
	}
	
	// from PipeVolumeDirectoryCollectionSource
	protected ParamVolumeCollection findCollectionFiles(){
		Vector<File> fileList = new Vector<File>();
		File dir = directory.getValue();
		if (dir == null) {
			// create directory
			dir.mkdir();
		}
		ProgressMonitor monitor= new ProgressMonitor(null, "Searching directory "+dir.getAbsolutePath(),"Searching...", 0,2);

		File[] files = dir.listFiles();
		for (File f : files) {
			if (f.isFile()) {
				fileList.add(f);
			}
		}
		monitor.close();
		Collections.sort(fileList);
		
		ParamVolumeCollection coll = new ParamVolumeCollection("VolDirColl");
		for(File file : fileList) {
			System.out.println(getClass().getCanonicalName()+"\t"+"Debug: "+file.getName());
			coll.add(file);	
		}
		return coll;
	}
	

}
