/*
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.List;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;


/*
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class MedicAlgorithmCombineVolumeComponents extends ProcessingAlgorithm{
	ParamVolumeCollection inVols;
	ParamOption	catdim;
	ParamVolume outVol;

	private static final String cvsversion = "$Revision: 1.10 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Concatenates volumes in the input Volume Collection into a " +
			"single multi-component Volume (ie. 4D Volume).";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inVols=new ParamVolumeCollection("Volumes"));
		inputParams.add(catdim=new ParamOption("Dim to cat", new String[]{"3","4"}));
		catdim.setValue(1);
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Volume");
		inputParams.setLabel("Concatenate Volumes");
		inputParams.setName("Concatenate_Volumes");


		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("IACL","",""));
		info.setWebsite("iacl.ece.jhu.edu");
		info.setAffiliation("");
		info.setDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Multi-Component Volume",null,-1,-1,-1,-1));

	}


	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#execute(edu.jhu.ece.iacl.pipeline.CalculationMonitor)
	 */
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		List<ImageData> vols=inVols.getImageDataList();
		
		String catoption = catdim.getValue();
		if(catoption.equals("4")){
			cat4(vols);
		}else if(catoption.equals("3")){
			cat3(vols);
		}else{
			System.err.println("INVALID CONCATINATION OPTION");
		}
	}
	
	private void cat3(List<ImageData> vols){
		ImageDataMipav cvol = null;

		int num = vols.size();
		
		int totnz = 0;
		// what will the z dim have to be?
		for(int l=0;l<num;l++){
			totnz  += vols.get(l).getSlices();
		}
		
		int l = 0;

		int slccounter = 0;
		while(l<num){

			
			ImageData thisvol = vols.get(l);

			if(l==0){

				if(thisvol.getSlices()==1){
					cvol=new ImageDataMipav(thisvol.getName()+"_vec",thisvol.getType(),
							thisvol.getRows(),thisvol.getCols(),totnz,1);
					cvol.setHeader(thisvol.getHeader());
				}else{

					cvol=new ImageDataMipav(thisvol.getName()+"_vec",thisvol.getType(),
							thisvol.getRows(),thisvol.getCols(),totnz,thisvol.getComponents());
					cvol.setHeader(thisvol.getHeader());
				}

			}else {
				
				if(!thisvol.getHeader().isSameOrientation(cvol.getHeader())){
					System.err.println( 
					"**********************************************\n" +
					"WARNING: Images have different orientations...\n" + 
					"**" +
					"********************************************\n" );
				}
				if(!thisvol.getHeader().isSameResolution(cvol.getHeader())){
					System.err.println( 
					"**********************************************\n" +
					"WARNING: Images have different resolutions ...\n" + 
					"**********************************************\n" );
				}

			}

			if( thisvol.getRows()!=cvol.getRows() || thisvol.getCols()!=cvol.getCols() ){
				
				System.err.println("Volume " + l + " has inconsistent dimensions!\n" +
				"ABORTING!");
				return;
			}
			
			if(thisvol.getComponents()==0){
				for(int k=0;k<thisvol.getSlices();k++){
					for(int i=0;i<thisvol.getRows();i++)for(int j=0;j<thisvol.getCols();j++){
						cvol.set(i,j,slccounter,0,thisvol.getDouble(i, j, k));

					}
					slccounter++;
				}
			}else{
				for(int k=0;k<thisvol.getSlices();k++){
					for(int i=0;i<thisvol.getRows();i++)for(int j=0;j<thisvol.getCols();j++)for(int c=0;c<thisvol.getComponents();c++){
						cvol.set(i,j,slccounter,c,thisvol.getDouble(i, j, k, c));

					}
					slccounter++;
				}
			}
			
			
			
			thisvol.dispose();
			thisvol=null;
			vols.get(l).dispose();
			
			l++;
			
		} // end loop over list of images
			
		
		outVol.setValue(cvol);
	}
	
	private void cat4(List<ImageData> vols){
		ImageDataMipav cvol = null;
		boolean are2d = false;
		int volind = 0;
		int l = 0;
		
		int numcomps = 0;
		if(vols.get(0).getSlices()==1){
			numcomps = vols.size();
		}else{
			for(int s=0; s<vols.size(); s++){
				numcomps += vols.get(s).getComponents();
			}
			System.out.println("final volume will have: " + numcomps + " components");
		}
		
		
		while(volind<vols.size()){
			
			ImageData thisvol = vols.get(volind);
			
			if(volind==0){
				if(thisvol.getSlices()==1){
					are2d = true;
					cvol=new ImageDataMipav(vols.get(0).getName()+"_vec",thisvol.getType(),
							thisvol.getRows(),thisvol.getCols(),numcomps,1);
					cvol.setHeader(thisvol.getHeader());
				}else{
					cvol=new ImageDataMipav(vols.get(0).getName()+"_vec",thisvol.getType(),
							thisvol.getRows(),thisvol.getCols(),thisvol.getSlices(),numcomps);
					cvol.setHeader(thisvol.getHeader());
				}
				
			}else {
//				if(!thisvol.getHeader().isSameOrientation(cvol.getHeader())){
//					System.err.println( "**********************************************\n" +
//										"WARNING: Images have different orientations...\n" + 
//										"**********************************************\n");
//				}
//				if(!thisvol.getHeader().isSameResolution(cvol.getHeader())){
//					System.err.println( "**********************************************\n" +
//										"WARNING: Images have different resolutions ...\n" + 
//										"**********************************************\n");
//				}
					
			}
			
			if(are2d){
				if(thisvol.getRows()!=cvol.getRows() || thisvol.getCols()!=cvol.getCols()){
					System.err.println("Volume " + l + " has inconsistent dimensions!\n" +
							"ABORTING!");
					return;
				}
				for(int i=0;i<cvol.getRows();i++){
					for(int j=0;j<cvol.getCols();j++){
						cvol.set(i,j,l,0,thisvol.getDouble(i, j));
					}
				}
				
			}else{
				if(thisvol.getRows()!=cvol.getRows() || thisvol.getCols()!=cvol.getCols() ||
						thisvol.getSlices()!=cvol.getSlices()){
					System.err.println("Volume " + l + " has inconsistent dimensions!\n" +
							"ABORTING!");
				}
				for(int c=0;c<thisvol.getComponents();c++){
					for(int i=0;i<thisvol.getRows();i++)for(int j=0;j<thisvol.getCols();j++)for(int k=0;k<thisvol.getSlices();k++){
						cvol.set(i,j,k,l,thisvol.getDouble(i, j, k, c));
					}
					l++;
				}
				
			}
			
			thisvol.dispose();
			thisvol=null;
			vols.get(volind).dispose();
			
			volind++;
			
		}
		outVol.setValue(cvol);
	}
}
