package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;


public class MedicAlgorithmReplaceValues extends ProcessingAlgorithm{
	public ParamVolumeCollection inParamInVols;
	public ParamOption inParamReplaceType;
	public ParamDouble inParamRangeMax;
	public ParamDouble inParamRangeMin;
	public ParamDouble inParamValueToReplaceWith;
	public ParamVolumeCollection outParamOutVols;

	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Replaces a value in the volume with another.";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamInVols=new ParamVolumeCollection("Input Volumes",null,-1,-1,-1,-1));

		String[] replaceTypeStr = new String[]{"NaN", "Infinity", "Neg Infinity", "Number Range"};
		inputParams.add(inParamReplaceType = new ParamOption("Type of Value to Replace",replaceTypeStr) );
		inputParams.add(inParamRangeMax = new ParamDouble("Value Range Max",0) );
		inputParams.add(inParamRangeMin = new ParamDouble("Value Range Min",0) );
		inputParams.add(inParamValueToReplaceWith = new ParamDouble("Value to Replace With",0) );

		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Volume");
		inputParams.setLabel("Replace Value");
		inputParams.setName("ReplaceValue");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamOutVols=new ParamVolumeCollection("Output Volumes",null,-1,-1,-1,-1));
		outputParams.setLabel("Replace Value");
		outputParams.setName("ReplaceValue");
	}


	@Override
	protected void execute(CalculationMonitor monitor) {
		List<ImageData> volList = inParamInVols.getImageDataList();

		for(ImageData vol : volList){
			int rows=vol.getRows();
			int cols=vol.getCols();
			int slices=vol.getSlices();
			int comps=vol.getComponents();
			boolean replaceFlag=false;
			double currentVal;
			vol.setName(vol.getName()+"_replaced");
			for(int i=0;i<rows;i++){
				for(int j=0;j<cols;j++){
					for(int k=0;k<slices;k++){
						for(int c=0;c<comps;c++){

							currentVal = vol.getDouble(i, j, k, c);
							switch (inParamReplaceType.getIndex()){
							case 0:
								if(Double.isNaN(currentVal)) replaceFlag = true;
							case 1:
								if(Double.isInfinite(currentVal)) replaceFlag = true;
							case 2:
								if(Double.isInfinite(-currentVal)) replaceFlag = true;
							case 3:
								if(currentVal <= inParamRangeMax.getDouble() && currentVal >= inParamRangeMin.getDouble() ) replaceFlag = true;

							}

							if(replaceFlag) vol.set(i, j, k, c, inParamValueToReplaceWith.getDouble());

							replaceFlag = false;
						}
					}
				}
			}
		}
		outParamOutVols.setValue(volList);
	}
}
