/*
 *
 */
package edu.jhu.ece.iacl.plugins.vbm;

import java.util.ArrayList;
import java.util.Collections;

//import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataDouble;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
//import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRTCollection.FlirtWrapper;


/*
 * @author Min Chen (mchen55@jhu.edu)
 *
 */
public class MedicAlgorithmRAVENS extends ProcessingAlgorithm{
	//Inputs
	public ParamVolume inParamSegmentation;
	public ParamVolume inParamTemplate;
	public ParamVolume inParamInverseDeformation;

	//Outputs
	public ParamVolumeCollection outParamRAVENSMaps;


	//Internal Variables
	private static int backgroundVal = 0;


	//Other Variables
	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Creates RAVENS map for a given segmentation and deformation to a template. Ported From DRAMMS-RAVEN. http://www.rad.upenn.edu/sbia/software/dramms/tools/ravens.html";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamSegmentation=new ParamVolume("Tissue Segmentation of Subject"));
		inputParams.add(inParamTemplate=new ParamVolume("Template Image (Reference For Target Space)"));
		inputParams.add(inParamInverseDeformation=new ParamVolume("Displacement Field From Subject to Template (in Subject Space)"));

		inputParams.setPackage("IACL");
		inputParams.setCategory("VBM");
		inputParams.setLabel("Create RAVENS Maps");
		inputParams.setName("RAVENS");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Min Chen", "", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamRAVENSMaps=new ParamVolumeCollection("RAVENS Maps", null, -1, -1, -1, -1));
		outParamRAVENSMaps.setLoadAndSaveOnValidate(false);
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ExecuteWrapper wrapper=new ExecuteWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);
	}

	//Port of DRAMMS-RAVEN from SBI
	protected class ExecuteWrapper extends AbstractCalculation{
		public void execute(ProcessingAlgorithm alg){


			/* Unsed Parameters
			  float         level, weight, thres ;
			  boolean DeformationSmoothOrNot=false;
			  boolean DRAMMSDeformationOrNot=true;
			  boolean templateSizeGivenOrNot=false;
			  int smoothWindowSizeXY, smoothWindowSizeZ;
			  float smoothKernelXY, smoothKernelZ;
			  float warpedX, warpedY, warpedZ;
			 */

			int NumOfDim = 3;
			int[]	imageSizeSubj = new int[NumOfDim];
			int[] 	imageSizeTemp = new int[NumOfDim];
			float[]  Subj_subVoxel  = new float[NumOfDim];
			float[] Displace_subVoxel  = new float[NumOfDim];

			float[] voxelSizeSubj;
			float[] voxelSizeTemp;
			float 	voxelSizeRatioS2T;
			float[][][] Mass;
			float[][][] RAVENSMap;

			int       scaleFactor;

			//boolean maskOrNot = false;
			//int[] foregroundIntensity = {0, 0, 0, 0, 0};
			int numRAVENSMaps=1;
			float volumeOriginal=0.0f;
			float volumeRAVENS=0.0f;
			float volumeOutOfBounds=0.0f;
			float ii,jj,kk;
			float volumePreservePercentage,volumePreservePercentageAll;
			float scaledMass;
			float massOverflow;


			//Subvoxel sampling of deformation field 
			int sampleNum= 2;// how much to subsample in each direction, was 1 in earlier version in SBIA
			float interval = 1.0f/(sampleNum*2+1) ;

			scaleFactor = 1000;  // to scale original RAVENS values (typically <10) into short values

			//load label images (should be in subject space)
			ImageData labelimage =  inParamSegmentation.getImageData();
			imageSizeSubj[0] = labelimage.getRows();
			imageSizeSubj[1] = labelimage.getCols();
			imageSizeSubj[2] = labelimage.getSlices();
			voxelSizeSubj = labelimage.getHeader().getDimResolutions();

			// load template image (for image and voxel dimension in template space)
			ImageData tempimage  = inParamTemplate.getImageData(); 
			imageSizeTemp[0] = tempimage.getRows();
			imageSizeTemp[1] = tempimage.getCols();
			imageSizeTemp[2] = tempimage.getSlices();
			voxelSizeTemp = tempimage.getHeader().getDimResolutions();

			// calculate voxel size ratio
			voxelSizeRatioS2T = (voxelSizeSubj[0] * voxelSizeSubj[1] * voxelSizeSubj[2])/(voxelSizeTemp[0] * voxelSizeTemp[1] * voxelSizeTemp[2]);
			if ( (voxelSizeRatioS2T != voxelSizeRatioS2T)||(voxelSizeRatioS2T==0) )
				voxelSizeRatioS2T=1.0f;


			// load deformation (should be in subject space)
			ImageDataFloat deformation  = new ImageDataFloat(inParamInverseDeformation.getImageData());
			float[][][][] DeformFld = deformation.toArray4d();

			// verify that the input deformation is in the same space as the input label image (both in subject space)
			if (deformation.getRows() != imageSizeSubj[0] ||
					deformation.getCols() != imageSizeSubj[1] ||
					deformation.getSlices() != imageSizeSubj[2]) {

				System.out.format("\nError: input label image and input deformation should be in the same space (both subject space)!\n");
				System.exit(1);
			}
			System.out.format("image size of RAVENS maps = (%d,%d,%d)\n\n", imageSizeTemp[0], imageSizeTemp[1], imageSizeTemp[2]);

			Mass = new float[imageSizeTemp[0]][imageSizeTemp[1]][imageSizeTemp[2]];

			/* Masking, not relevant for our implementation
			if (maskOrNot) {
				numRAVENSMaps=0;
				for (i=0;i<5;i++) {
					if (foregroundIntensity[i] != 0) numRAVENSMaps++;
				}
				maskoutImage(labelimage, imageSizeSubj, foregroundIntensity, numRAVENSMaps);
			}
			 */

			//------------------------------
			//------------------------------
			System.out.format("Calculate RAVENS values...\n");
			ArrayList<Integer> labelList = findLabels(labelimage);


			//ArrayList<Integer> labelList = new ArrayList<Integer>();
			//labelList.add(new Integer(1));
			//labelList.add(new Integer(2));
			numRAVENSMaps = labelList.size();
			for (Integer currentLabel : labelList) {
				if (numRAVENSMaps > 1) {
					System.out.format("------------\n");
					System.out.format("RAVENS map for tissue type %d out of %d\n", currentLabel.intValue(), numRAVENSMaps);
				}
				volumeOriginal=0;
				volumeRAVENS=0;

				for (int i=0;i<imageSizeTemp[0];i++)
					for (int j=0;j<imageSizeTemp[1];j++)
						for (int k=0;k<imageSizeTemp[2];k++){
							Mass[i][j][k]=0.0f;
						}

				RAVENSMap = new float[imageSizeTemp[0]][imageSizeTemp[1]][imageSizeTemp[2]];


				for (int i=0;i<imageSizeSubj[0];i++)
					for (int j=0;j<imageSizeSubj[1];j++)
						for (int k=0;k<imageSizeSubj[2];k++){

							if (labelimage.getInt(i,j,k)==currentLabel.intValue()){
								volumeOriginal+=1.0;

								//subdivide volumeinto subsamples, assuming its in bounds
								for(int x=-sampleNum; x<=sampleNum; x++)
									for(int y=-sampleNum; y<=sampleNum; y++)
										for(int z=-sampleNum; z<=sampleNum; z++){		
											Subj_subVoxel[0] = x*interval + i ;
											Subj_subVoxel[1] = y*interval + j ;
											Subj_subVoxel[2] = z*interval + k ;
											
											//check if interpolated displacement is in bounds
											if(Subj_subVoxel[0] >=0 && Subj_subVoxel[0] < imageSizeSubj[0] 
											    && Subj_subVoxel[1] >=0 && Subj_subVoxel[1] < imageSizeSubj[1]
											     && Subj_subVoxel[2] >=0 && Subj_subVoxel[2] < imageSizeSubj[2]){

												InterpolatedDisplacement(Displace_subVoxel, Subj_subVoxel[0], Subj_subVoxel[1], Subj_subVoxel[2], DeformFld, imageSizeSubj[0], imageSizeSubj[1], imageSizeSubj[2]) ;
	
												ii = Subj_subVoxel[0] + Displace_subVoxel[0] ;
												jj = Subj_subVoxel[1] + Displace_subVoxel[1] ;
												kk = Subj_subVoxel[2] + Displace_subVoxel[2] ;   // (ii,jj,kk) is in template space now
												
												//check if location to distribute is in bounds
												if(ii >=0 && ii < imageSizeTemp[0] && jj >=0 && jj < imageSizeTemp[1] && kk >=0 && kk < imageSizeTemp[2]){
													//DistributingVolume(1.0/pow((sampleNum*2+1),3.0), ii, jj, kk, Mass, imageSizeTemp[0], imageSizeTemp[1], imageSizeTemp[2]) ;
													DistributingVolume((float)(voxelSizeRatioS2T/Math.pow((sampleNum*2+1),3.0)), ii, jj, kk, Mass, imageSizeTemp[0], imageSizeTemp[1], imageSizeTemp[2]) ;
												}else{
													volumeOutOfBounds+=voxelSizeRatioS2T/Math.pow((sampleNum*2+1),3.0);//else record what's tossed out
												}
											}
											else{
												volumeOutOfBounds+=voxelSizeRatioS2T/Math.pow((sampleNum*2+1),3.0);//else record what's tossed out
											}
												
										}
							} // if
						} // for...for...for...

				/***** added on Sept 16, 2011  (start)
				// avoid overflow of short value; typically the original ravens value in Mass should not be greater than 32.767,
				// otherwise it might be due to over-aggressive deformations. In practice, we have observed this happening in
				// about 30 subjects out of 606 subjects (at baseline) in accord dataset. So below is a way to avoid negative
				// RAVENS caused by data overflow.
				float numNbhVoxels;
				float upperlim=32767.0f/(float)scaleFactor;
				for (int i=0;i<imageSizeTemp[0];i++)
					for (int j=0;j<imageSizeTemp[1];j++)
						for (int k=0;k<imageSizeTemp[2];k++){

							if (Mass[i][j][k]>upperlim)
							{
								massOverflow=Mass[i][j][k]-upperlim;
								Mass[i][j][k]=upperlim;   

								// in rear cases when overflow happens, distribute the mass to nearby 3*3*3 box
								numNbhVoxels=0.0f;
								for (int x=Math.max(-i,-1);x<=Math.min(1,(imageSizeTemp[0]-1-i));x++)
									for (int y=Math.max(-j,-1);y<=Math.min(1,(imageSizeTemp[1]-1-j));y++)
										for (int z=Math.max(-k,-1);z<=Math.min(1,(imageSizeTemp[2]-1-k));z++)
										{
											if (Mass[i+x][j+y][k+z]<upperlim)
												numNbhVoxels += 1.0;    // count how many voxels in the neighborhood can be used to distribute mass to 
										}
								if (numNbhVoxels>0.0)
								{
									massOverflow /= numNbhVoxels;

									for (int x=Math.max(-i,-1);x<=Math.min(1,(imageSizeTemp[0]-1-i));x++)
										for (int y=Math.max(-j,-1);y<=Math.min(1,(imageSizeTemp[1]-1-j));y++)
											for (int z=Math.max(-k,-1);z<=Math.min(1,(imageSizeTemp[2]-1-k));z++)
											{
												Mass[i+x][j+y][k+z] += massOverflow;

												if (Mass[i+x][j+y][k+z]>upperlim)
													Mass[i+x][j+y][k+z]=upperlim;
											}
								}
							}
						}
				// ***** added on Sept 16, 2011  (end)
				 */

				for (int i=0;i<imageSizeTemp[0];i++)
					for (int j=0;j<imageSizeTemp[1];j++)
						for (int k=0;k<imageSizeTemp[2];k++)
						{
							//scaledMass = Mass[i][j][k]*(float)scaleFactor+0.5f;
							//if (scaledMass>32767) scaledMass=32767;
							//if (scaledMass<0) scaledMass=0;
							scaledMass = Mass[i][j][k]*(float)scaleFactor;
							RAVENSMap[i][j][k] = scaledMass;
							volumeRAVENS += Mass[i][j][k];
						}

				volumeOriginal *= (voxelSizeSubj[0] * voxelSizeSubj[1] * voxelSizeSubj[2]);
				volumeRAVENS   *= (voxelSizeTemp[0] * voxelSizeTemp[1] * voxelSizeTemp[2]);
				volumeOutOfBounds *= (voxelSizeTemp[0] * voxelSizeTemp[1] * voxelSizeTemp[2]);
				volumePreservePercentage = volumeRAVENS/volumeOriginal;
				volumePreservePercentageAll = (volumeRAVENS+volumeOutOfBounds)/volumeOriginal;
				System.out.format("Current Label " + currentLabel.intValue()+"\n");
				System.out.format("\tVolume of original image (in subject space) = %f\n", volumeOriginal);
				System.out.format("\tVolume of RAVENS map (in template space)    = %f\n", volumeRAVENS);
				System.out.format("\tVolume pushed out of bounds (in template space)    = %f\n", volumeOutOfBounds);
				System.out.format("\t%2.2f%% of the volume has been preserved in RAVENS calculation.\n", volumePreservePercentage*100);
				System.out.format("\t%2.2f%% of the volume has been preserved in RAVENS calculation (including out of bounds).\n", volumePreservePercentageAll*100);
				System.out.format("\tMinor difference (<1%%) should be due to interpolation errors and shouldn't matter.\n");
				System.out.format("\tMajor difference (>5%%) should be due to overflow of signed short datatype at places where ravens values are large as a result of aggressive deformations.\n");
				System.out.format("\n");

				ImageDataFloat ravensimage = new ImageDataFloat(RAVENSMap);
				ravensimage.setHeader(tempimage.getHeader());
				ravensimage.setName(labelimage.getName()+"RAVEN_Label_"+currentLabel.intValue());
				outParamRAVENSMaps.add(ravensimage);
				outParamRAVENSMaps.writeAndFreeNow(alg);
			}

		}

	}


	// ===========================================================================
	// auxiliary functions
	// ===========================================================================

	// ---------------------------------------------------------------------------
	void maskoutImage(ImageData Img, int[] imageSize, int[] foregroundIntensity, int num)
	{
		int i,j,k,n;
		float[][][] labelImg = new float[imageSize[0]][imageSize[1]][imageSize[2]];

		for (i=0;i<imageSize[0];i++)
			for (j=0;j<imageSize[1];j++)
				for (k=0;k<imageSize[2];k++)
				{
					labelImg[i][j][k]=0;
					for (n=0;n<num;n++)
					{
						if (Img.getInt(i, j, k)==foregroundIntensity[n])
							labelImg[i][j][k]=n+1;
					}
				}

		for (i=0;i<imageSize[0];i++)
			for (j=0;j<imageSize[1];j++)
				for (k=0;k<imageSize[2];k++)
					Img.set(i,j,k,labelImg[i][j][k]);
	}

	// ---------------------------------------------------------------------------
	float InterpolatedIntensity(float ii, float jj, float kk, float[][][] Img, int x_size, int y_size, int z_size)
	{
		float CurrentV ;
		float b,c,d, b1,c1,d1;
		int   ni,nj,nk, niP1,njP1,nkP1;
		float GreyValue ;


		ni = (int)ii ;
		nj = (int)jj ;
		nk = (int)kk ;

		niP1 = ni+1 ;
		njP1 = nj+1 ;
		nkP1 = nk+1 ;

		GreyValue = 0;
		if(ni>=0 && ni<x_size-1  &&  nj>=0 && nj<y_size-1  &&  nk>=0 && nk<z_size-1 )
		{
			b = ii-ni ;        b1 = 1.0f-b ;
			c = jj-nj ;        c1 = 1.0f-c ;
			d = kk-nk ;        d1 = 1.0f-d ;

			CurrentV = ( d1*(Img[ni][nj][nk]*(b1*c1) + Img[niP1][nj][nk]*(b*c1) + Img[ni][njP1][nk]*(b1*c) + Img[niP1][njP1][nk]*(b*c)) + d*(Img[ni][nj][nkP1]*(b1*c1) + Img[niP1][nj][nkP1]*(b*c1) + Img[ni][njP1][nkP1]*(b1*c) + Img[niP1][njP1][nkP1]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 


			GreyValue = CurrentV ;
		}

		if ( (ni==x_size-1 && nj>=0 && nj<y_size-1 && nk>=0 && nk<z_size-1) || (ni>=0 && ni<x_size-1 && nj==y_size-1 && nk>=0 && nk<z_size-1)  || (ni>=0 && ni<x_size-1 && nj>=0 && nj<y_size-1 && nk==z_size-1) )
			GreyValue = (float)Img[ni][nj][nk] ;

		return GreyValue ;
	}

	// ---------------------------------------------------------------------------
	void InterpolatedDisplacement(float[] Displace_subVoxel, float ii, float jj, float kk, float[][][][] DeformFld, int x_size, int y_size, int z_size)
	{
		float CurrentV ;
		float b,c,d, b1,c1,d1;
		int   ni,nj,nk, niP1,njP1,nkP1, GreyValue ;


		ni = (int)ii ;
		nj = (int)jj ;
		nk = (int)kk ;

		niP1 = ni+1 ;
		njP1 = nj+1 ;
		nkP1 = nk+1 ;

		if(ni>=0 && ni<x_size-1  &&  nj>=0 && nj<y_size-1  &&  nk>=0 && nk<z_size-1 )
		{
			b = ii-ni ;        b1 = 1.0f-b ;
			c = jj-nj ;        c1 = 1.0f-c ;
			d = kk-nk ;        d1 = 1.0f-d ;

			Displace_subVoxel[0] = ( d1*(DeformFld[ni][nj][nk][0]*(b1*c1) + DeformFld[niP1][nj][nk][0]*(b*c1) + DeformFld[ni][njP1][nk][0]*(b1*c) + DeformFld[niP1][njP1][nk][0]*(b*c)) + d*(DeformFld[ni][nj][nkP1][0]*(b1*c1) + DeformFld[niP1][nj][nkP1][0]*(b*c1) + DeformFld[ni][njP1][nkP1][0]*(b1*c) + DeformFld[niP1][njP1][nkP1][0]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 

			Displace_subVoxel[1] = ( d1*(DeformFld[ni][nj][nk][1]*(b1*c1) + DeformFld[niP1][nj][nk][1]*(b*c1) + DeformFld[ni][njP1][nk][1]*(b1*c) + DeformFld[niP1][njP1][nk][1]*(b*c)) + d*(DeformFld[ni][nj][nkP1][1]*(b1*c1) + DeformFld[niP1][nj][nkP1][1]*(b*c1) + DeformFld[ni][njP1][nkP1][1]*(b1*c) + DeformFld[niP1][njP1][nkP1][1]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 

			Displace_subVoxel[2] = ( d1*(DeformFld[ni][nj][nk][2]*(b1*c1) + DeformFld[niP1][nj][nk][2]*(b*c1) + DeformFld[ni][njP1][nk][2]*(b1*c) + DeformFld[niP1][njP1][nk][2]*(b*c)) + d*(DeformFld[ni][nj][nkP1][2]*(b1*c1) + DeformFld[niP1][nj][nkP1][2]*(b*c1) + DeformFld[ni][njP1][nkP1][2]*(b1*c) + DeformFld[niP1][njP1][nkP1][2]*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
		}

		if(ni==x_size-1 && nj>=0 && nj<y_size-1 && nk>=0 && nk<z_size-1 || ni>=0 && ni<x_size-1 && nj==y_size-1 && nk>=0 && nk<z_size-1  || ni>=0 && ni<x_size-1 && nj>=0 && nj<y_size-1 && nk==z_size-1)
		{
			Displace_subVoxel[0] = DeformFld[ni][nj][nk][0] ;
			Displace_subVoxel[1] = DeformFld[ni][nj][nk][1] ;
			Displace_subVoxel[2] = DeformFld[ni][nj][nk][2] ;
		}
	}

	// ---------------------------------------------------------------------------
	void DistributingVolume(float weight, float ii, float jj, float kk, float[][][] Mass, int x_size, int y_size, int z_size)
	{
		float CurrentV ;
		float b,c,d, b1,c1,d1, combined;
		int   ni,nj,nk, niP1,njP1,nkP1, GreyValue ;


		ni = (int)ii ;
		nj = (int)jj ;
		nk = (int)kk ;

		niP1 = ni+1 ;
		njP1 = nj+1 ;
		nkP1 = nk+1 ;


		if(ni>=0 && ni<x_size-1  &&  nj>=0 && nj<y_size-1  &&  nk>=0 && nk<z_size-1 )
		{
			b = ii-ni ;			b1 = 1.0f-b ;
			c = jj-nj ;	      	c1 = 1.0f-c ;
			d = kk-nk ;			d1 = 1.0f-d ;

			combined = ( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ;

			Mass[ni][nj][nk]      += weight*d1*(b1*c1)/combined ;
			Mass[niP1][nj][nk]    += weight*d1*(b*c1)/combined ;
			Mass[ni][njP1][nk]    += weight*d1*(b1*c)/combined ;
			Mass[niP1][njP1][nk]  += weight*d1*(b*c)/combined ;
			Mass[ni][nj][nkP1]    += weight*d*(b1*c1)/combined ;
			Mass[niP1][nj][nkP1]  += weight*d*(b*c1)/combined ;
			Mass[ni][njP1][nkP1]  += weight*d*(b1*c)/combined ;
			Mass[niP1][njP1][nkP1]+= weight*d*(b*c)/combined ;
		}

		if(ni==x_size-1 && nj>=0 && nj<y_size-1 && nk>=0 && nk<z_size-1 || ni>=0 && ni<x_size-1 && nj==y_size-1 && nk>=0 && nk<z_size-1  || ni>=0 && ni<x_size-1 && nj>=0 && nj<y_size-1 && nk==z_size-1)
			Mass[ni][nj][nk]      += weight*1 ;
	}




	/*This my initial implimentation of RAVEN from the paper
	protected class ExecuteWrapper extends AbstractCalculation{
		public void execute(ProcessingAlgorithm alg){

			ImageData segVol =  inParamSegmentation.getImageData();
			ImageData defField = inParamInverseDeformation.getImageData();


			int XN = segVol.getRows();
			int YN = segVol.getCols();
			int ZN = segVol.getSlices();



			ArrayList<Integer> labelList = findLabels(segVol);
			double[][][][] outVolD = new double[XN][YN][ZN][labelList.size()];//make a volume for each label except background

			for(int i = 0; i < XN ; i++)
				for(int j = 0; j < YN ; j++)
					for(int k = 0; k < ZN ; k++){

						for(int l=0; l < labelList.size(); l++){
							if(segVol.getInt(i, j, k) == labelList.get(l).intValue() && segVol.getInt(i, j, k) > backgroundVal){

								if(i+defField.getDouble(i, j, k,0) < XN-1 && j+defField.getDouble(i, j, k,1) < YN-1 && k+defField.getDouble(i, j, k,2) < ZN-1){
									if(i+defField.getDouble(i, j, k,0) >= 0 && j+defField.getDouble(i, j, k,1) >=0 && k+defField.getDouble(i, j, k,2) >=0){
										incrementAtLoc(outVolD, i+defField.getDouble(i, j, k,0), j+defField.getDouble(i, j, k,1), k+defField.getDouble(i, j, k,2), l);
									}
								}

							}
						}
					}


			ImageData outVol = new ImageDataDouble(outVolD);
			outVol.setHeader(segVol.getHeader());
			outVol.setName(segVol.getName() + "_RAVENSmaps");
			outParamRAVENSMaps.setValue(outVol);

		}
	}

	//increments value at target location
	private void incrementAtLoc(double[][][][] vol, double atLocX, double atLocY, double atLocZ, int labelIndex ){

		int x = (int)Math.floor(atLocX);
		int y = (int)Math.floor(atLocY);
		int z = (int)Math.floor(atLocZ);

		double dx = atLocX - x;
		double dy = atLocY - y;
		double dz = atLocZ - z;

		//find how much to add to each of the nearest 8 vertices
		double[][][] indexWeight = new double[2][2][2];

		double sumWeight = 0;
		for (int i = 0; i <=1; i++)
			for (int j = 0; j <=1; j++)
				for (int k = 0; k <=1; k++){
					indexWeight[i][j][k] = 1/Math.sqrt((i-dx)*(i-dx) + (j-dy)*(j-dy) + (k-dz)*(k-dz));
					if(Double.isInfinite(indexWeight[i][j][k])){//if hitting exactly on a voxel then increment that location and exit 
						vol[x+i][y+j][z+k][labelIndex] +=1;
						return;	
					}
					sumWeight += indexWeight[i][j][k]; 
				}

		for (int i = 0; i <=1; i++)
			for (int j = 0; j <=1; j++)
				for (int k = 0; k <=1; k++){
				vol[x+i][y+j][z+k][labelIndex] += indexWeight[i][j][k]/sumWeight;//normalize by total so it adds up to one
			}

	}
	 */
	public ArrayList<Integer> findLabels(ImageData truth){
		ArrayList<Integer> labels = new ArrayList<Integer>();
		if(truth!=null){
			int rows = truth.getRows();
			int cols = truth.getCols();
			int slcs = truth.getSlices();
			for(int i=0; i<rows; i++){
				for(int j=0; j<cols; j++){
					for(int k=0; k<slcs; k++){
						if(truth.getComponents() > 1){
							for(int c=0; c<truth.getComponents(); c++){
								if(!labels.contains(new Integer(truth.getInt(i,j,k,c)))){
									labels.add(new Integer(truth.getInt(i,j,k,c)));
								}	
							}
						}
						else{
							if(!labels.contains(new Integer(truth.getInt(i,j,k)))){
								labels.add(new Integer(truth.getInt(i,j,k)));
							}
						}
					}
				}
			}
		}else{
			System.err.println("No data!");
		}
		labels.trimToSize();
		Collections.sort(labels);
		System.out.println("Found Labels: ");
		System.out.println(labels);
		return labels;
	}

}