package edu.jhu.ece.iacl.structures.image;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;

/**
 * 
 * @author John Bogovic
 * @version alpha
 *
 */
public class SubImage {
   
    private int nxOrig, nyOrig, nzOrig;
    private int nxSub, nySub, nzSub;
    private int offsetX, offsetY, offsetZ;
   
    private ImageData subImage;
    private double outOfBoundsReturnValue = 0;
   
    public SubImage(int nxOrig, int nyOrig, int nzOrig, int offsetX, int offsetY, int offsetZ, int nxSub, int nySub, int nzSub ){
        this.nxOrig=nxOrig;
        this.nyOrig=nyOrig;
        this.nzOrig=nzOrig;
       
        this.nxSub=nxSub;
        this.nySub=nySub;
        this.nzSub=nzSub;
       
        this.offsetX=offsetX;
        this.offsetY=offsetY;
        this.offsetZ=offsetZ;
    }
   
    public int getNxSub(){
        return nxSub;
    }
    public int getNySub(){
        return nySub;
    }
    public int getNzSub(){
        return nzSub;
    }
    public int getNxOrig(){
        return nxOrig;
    }
    public int getNyOrig(){
        return nyOrig;
    }
    public int getNzOrig(){
        return nzOrig;
    }
    public int getOffsetX(){
        return offsetX;
    }
    public int getOffsetY(){
        return offsetY;
    }
    public int getOffsetZ(){
        return offsetZ;
    }
    public int getMaxOrigX(){
        return offsetX+nxSub;
    }
    public int getMaxOrigY(){
        return offsetY+nySub;
    }
    public int getMaxOrigZ(){
        return offsetZ+nzSub;
    }
   
    public void setSubImage(ImageData img){
        if( img.getRows()==nxSub  &&
            img.getCols()==nySub  &&
            img.getSlices()==nzSub ){
           
            subImage=img;
            
        }
        
        float[] origin = subImage.getHeader().getOrigin();
        origin[0]+=offsetX;
        origin[1]+=offsetY;
        origin[2]+=offsetZ;
        subImage.getHeader().setOrigin(origin);
        
    }
    
    public double getDouble(int x, int y, int z){
    	if(inSubImage(x,y,z)){
    		return subImage.getDouble(originalToSubX(x), originalToSubY(y), originalToSubZ(z));
    	}else{
    		return outOfBoundsReturnValue;
    	}
    }
    public double getDouble(int x, int y, int z, int c){
    	if(inSubImage(x,y,z)){
    		return subImage.getDouble(originalToSubX(x), originalToSubY(y), originalToSubZ(z), c);
    	}else{
    		return outOfBoundsReturnValue;
    	}
    }
    
    public int getInt(int x, int y, int z){
    	if(inSubImage(x,y,z)){
    		return subImage.getInt(originalToSubX(x), originalToSubY(y), originalToSubZ(z));
    	}else{
    		return (int)outOfBoundsReturnValue;
    	}
    }
    
    public int getInt(int x, int y, int z, int c){
    	if(inSubImage(x,y,z)){
    		return subImage.getInt(originalToSubX(x), originalToSubY(y), originalToSubZ(z), c);
    	}else{
    		return (int)outOfBoundsReturnValue;
    	}
    }
    
    public float getFloat(int x, int y, int z){
    	if(inSubImage(x,y,z)){
    		return subImage.getFloat(originalToSubX(x), originalToSubY(y), originalToSubZ(z));
    	}else{
    		return (float)outOfBoundsReturnValue;
    	}
    }
    
    public float getFloat(int x, int y, int z, int c){
    	if(inSubImage(x,y,z)){
    		return subImage.getFloat(originalToSubX(x), originalToSubY(y), originalToSubZ(z), c);
    	}else{
    		return (float)outOfBoundsReturnValue;
    	}
    }
    
    /**
     * Specify the value to be returned by the get methods if a coordinate outside of the sub-image is passed 
     */
    public void setOutOfBoundsValue(double outOfBoundsReturnValue){
    	this.outOfBoundsReturnValue = outOfBoundsReturnValue;
    }
    
    public double getOutOfBoundsValue(){
    	return outOfBoundsReturnValue;
    }
    
    public boolean inSubImage(int x, int y, int z){
    	return ( (originalToSubX(x)>=0) && (originalToSubY(y)>=0) && (originalToSubZ(z)>=0) );
    }
   
    public int originalToSubX(int xOrig){
        if(xOrig>=getMaxOrigX() || xOrig<offsetX){
            return -1;
        }
        return xOrig-offsetX;
    }
    public int originalToSubY(int yOrig){
        if(yOrig>=getMaxOrigY() || yOrig<offsetY){
            return -1;
        }
        return yOrig-offsetY;
    }
    public int originalToSubZ(int zOrig){
        if(zOrig>=getMaxOrigZ() || zOrig<offsetZ){
            return -1;
        }
        return zOrig-offsetZ;
    }
   
    public ImageData getSubImage(){
        return subImage;
    }
   
    public static SubImage subImageFromMinMax(int nx, int ny, int nz, int minx, int miny, int minz, int maxx, int maxy, int maxz){
        return new SubImage(nx,ny,nz,minx,miny,minz,maxx-minx,maxy-miny,maxz-minz);
    }
   
    public static SubImage subImageFromMinMax(ImageData img, int minx, int miny, int minz, int maxx, int maxy, int maxz){
        return new SubImage(img.getRows(),img.getCols(),img.getSlices(),minx,miny,minz,maxx-minx,maxy-miny,maxz-minz);
    }
    
    public static SubImage mimec(SubImage template){
    	return new SubImage(template.getNxOrig(), template.getNyOrig(), template.getNzOrig(), 
    			template.getOffsetX(), template.getOffsetY(), template.getOffsetZ(),
    			template.getNxSub(), template.getNySub(), template.getNzSub());
    }
    
    public String printParameters(){
    	String s = "offset: " + getOffsetX() + " " + getOffsetY() + " " + getOffsetZ() +"\n"+
    	"si dim: " + getNxSub() + " " + getNySub() + " " + getNzSub() + "\n" + 
    	"orgdim: " + getNxOrig() + " " + getNyOrig() + " " + getNzOrig() + "\n" + 
    	"maxorig : " + getMaxOrigX() + " " + getMaxOrigY() + " " + getMaxOrigZ();
    	System.out.println(s);
    	return s;
    }
    
    public void dispose(){
    	if(subImage!=null){
    		subImage.dispose();
    	}
    }
   
    public static void main(String[] args){
        System.out.println("Starting");
       
//        SubImage si = new SubImage(5,5,5,1,1,1,2,2,2);
        SubImage si = new SubImage(146,104,104,
        		18,31,38,
        		57,57,34);
       
        int ox = 74;
        int oy = 31+57-1;
        int oz = 71;
        
//        System.out.println(ox + " to " + si.originalToSubX(ox));
//        System.out.println(oy + " to " + si.originalToSubY(oy));
//        System.out.println(oz + " to " + si.originalToSubZ(oz));
        
        System.out.println("Finished");
        System.exit(0);
    }
   
}