package edu.umcu.algorithms.volume;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import edu.jhu.ece.iacl.jist.utility.JistLogger;

/**
 * The ParV3Info class parses par version 4 files for information relevant to SPAR_mask.
 * 
 * @author Daniel Polders, based on extensive work by John Bogovic
 *
 */
public class SParInfo {
	
	String filename;
	String date;
	String parversion;
	//String bvals;
	//String foldover;
//	String patposition;
//	String patorient;
	//String sliceOrientation;
	//int slcor;
	
	double[] VoxelAng;
	double[] offCentre;
	double[] volumesizes;
	int numvolumes;
	//int numvolumes2;
	
	//int bvalCol;
	//int SlcOrCol;
	
	public SParInfo(String filename){
		this.filename=toSPAR(filename);
		System.out.println("jist.plugins"+"\t"+"Found file: "+filename);
	}
	
	/**
	 * 
	 * @param filename - The path of the file under consideration
	 * @return A String representing the path of the corresponding Par file if the input
	 * string was a .Rec file.  The ouput equals the input param if the filename is a par file.
	 */
	public static String toSPAR(String filename){
		String[] parts = filename.split(File.separatorChar+".");
		System.out.println("jist.plugins"+"\t"+parts.length);
		for(String s : parts){
			System.out.println("jist.plugins"+"\t"+s);
		}
		
		String out = filename;
		if(parts[parts.length-1].equals("SREC") || parts[parts.length-1].equals("srec")){
			out = combineFirst(parts)+"SPAR";
			File f = new File(out);
			if(f.exists()){
				return out;
			}else{
				out = combineFirst(parts)+"spar";
				f = new File(out);
				if(f.exists()){
					return out;
				}
			}
		}
		return out;
	}
	private static String combineFirst(String[] parts){
		String out = "";
		for(int i=0; i<parts.length-1; i++){
			out=out+parts[i]+".";
		}
		return out;
	}
	
	//"Get" methods below...
	/**
	 * @return The scan date as found in the spar file
	 * Format: YYYY.MM.DD
	 */
	public String getDate(){
		if(date==null)
			return "1900.01.01 / 00:00:01";
		return date;
	}
//	public String getSParVersion(){
//		return sparversion;
//	}
	/**
	 * @return the angulations of the spectro voxel
	 * Format: (ap, rl, fh)
	 */
	public double[] getVoxelAngulation(){
		return VoxelAng;
	}
	/**
	 * @return the Offcenters of the spectro voxel
	 * Format: (ap, rl, fh)
	 */
	public double[] getOffCentre(){
		return offCentre;
	}
	/**
	 * @return the sizes of the spectro voxel
	 * Format: (ap, rl, fh)
	 */
	public double[] getSizes(){
		return volumesizes;
	}
//	public int getNumVolumes(){
//		return numvolumes;
//	}

//	public String getPatientPosition(){
//		return patposition;
//	}
//	public String getPatientOrientation(){
//		return patorient;
//	}

	/**
	 * The getInfo method parses the par file and sets the global variables.
	 */
	public void getInfo(){
		try{
			BufferedReader rdr = new BufferedReader(new FileReader(new File(filename)));
			String thisline = "";
			int cnt = 0;
			thisline = rdr.readLine();
			++cnt;
			VoxelAng = new double[3];
			offCentre = new double[3];
			volumesizes = new double[3];
			JistLogger.logOutput(4, getClass().getCanonicalName()+": Thisline("+cnt+") = "+thisline.toString());
			
			while(cnt < 217){ // Try until the end of file
				thisline = rdr.readLine(); //SPAR files always have an empty line for all even lines, so skip it.
				++cnt;
				thisline = rdr.readLine();
				++cnt;
				if(thisline.isEmpty()){
					JistLogger.logOutput(4, getClass().getCanonicalName()+": Thisline("+cnt+") is EMPTY! (probably end of file)");
					return;
				}
				JistLogger.logOutput(4, getClass().getCanonicalName()+": Thisline("+cnt+") = "+thisline.toString());
				
				//Extract Date
				if(thisline.contains("scan_date")){
					int ind = thisline.indexOf(":");
					date = thisline.substring(ind+1);
					date=date.trim();
					date = date.substring(0,date.indexOf(" "));
					date=date.substring(0, 4)+date.substring(5, 7)+date.substring(8, 10);
				}
				if(thisline.contains("Last revised")){
					int ind = thisline.indexOf("d");
					String checkstring = thisline.substring(ind+2,ind+13);
					JistLogger.logOutput(5, getClass().getCanonicalName()+": Checkstring = "+checkstring);
					if (!checkstring.equals("15-Mar-2006")){
						JistLogger.logError(2, getClass().getCanonicalName()+"Only SPAR versions last revised 15-Mar-2006 are supported. Aborting. Please contact the author of this module for an update.");
						return;
					}
				}

				// retrieve Voxel angulations
				
				if(thisline.contains("ap_angulation")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					VoxelAng[0]= Double.parseDouble(info.substring(0, info.length()));
				}
				if(thisline.contains("lr_angulation")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					VoxelAng[1]= Double.parseDouble(info.substring(0, info.length()));
				}
				if(thisline.contains("cc_angulation")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					VoxelAng[2]= Double.parseDouble(info.substring(0, info.length()));
				}
				
				
//				if(thisline.contains("patient_position")){
//					String line = thisline.substring(thisline.indexOf(":")+1).trim();
//					patposition = line.substring(0 , line.lastIndexOf(' ')).trim();
//					patposition = patposition.replace(' ', '-');
//					patorient = line.substring(line.lastIndexOf(' ')).trim();
//				}
//				if(thisline.contains("Preparation direction")){
//					foldover = thisline.substring(thisline.indexOf(":")+1).trim();
//				}
				
				if(thisline.contains("ap_off_center")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					offCentre[0] = Double.parseDouble(info.substring(0, info.length()));
				}
				if(thisline.contains("lr_off_center")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					offCentre[1] = Double.parseDouble(info.substring(0, info.length()));
				}				
				if(thisline.contains("cc_off_center")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					offCentre[2] = Double.parseDouble(info.substring(0, info.length()));
				}
				if(thisline.contains("ap_size")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					volumesizes[0] = Double.parseDouble(info);
				}
				if(thisline.contains("lr_size")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					volumesizes[1] = Double.parseDouble(info.substring(0, info.length()));
				}				
				if(thisline.contains("cc_size")){
					String info = thisline.substring(thisline.indexOf(":")+1);
					info=info.trim();
					volumesizes[2] = Double.parseDouble(info.substring(0, info.length()));
				}
				
			}
			JistLogger.logOutput(4, getClass().getCanonicalName()+"End of file reached");
		
		}catch(IOException e){
			JistLogger.logError(2,e.getMessage());
			e.printStackTrace();
		}
	}

}
