package edu.vanderbilt.masi.algorithms.adaboost;

import java.util.Comparator;

public class ArrayIndexComparator implements Comparator<Integer> {
    private final float [] array;
    private int length;

    public ArrayIndexComparator(float [] array, int length) {
        this.array = array;
        this.length = length;
    }

    public Integer [] createIndexArray() {
        Integer [] indexes = new Integer [length];
        for (int i = 0; i < length; i++)
            indexes[i] = i;
        return indexes;
    }

    @Override
    public int compare(Integer index1, Integer index2) {
        return Float.compare(array[index1], array[index2]);
    }
}