package edu.vanderbilt.masi.algorithms.clasisfication;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;

public abstract class FeatureCalculator extends AbstractCalculation {
	
	protected ArrayList<String> names;
	
	public abstract ArrayList<Float> calculateFeatures(float[][][] im, int r, int c, int s);
	
	public abstract ArrayList<Float> calculateFeatures(int[][][] im, int r, int c, int s);
	
	public abstract ArrayList<String> getFeatureNames();
	
	public abstract boolean takesIntensity();
	
	public abstract boolean takesLabels();

}
