package edu.vanderbilt.masi.algorithms.clasisfication;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class ImageMasker extends AbstractCalculation {

	private int radius;
	private boolean[][][] mask;

	public ImageMasker(ImageData labels, int radius){
		this.radius = radius;
		this.mask = new boolean[labels.getRows()][labels.getCols()][labels.getSlices()];
		JistLogger.logOutput(JistLogger.INFO, "Calculating Mask");
		int r = labels.getRows();
		int c = labels.getCols();
		int s = labels.getSlices();
		for(int i=0;i<r;i++){
			for(int j=0;j<c;j++){
				for(int k=0;k<s;k++){
					if(labels.getFloat(i,j,k)>0){
						int xl = Math.max(i- this.radius, 0);
						int xh = Math.min(i+ this.radius, r-1);
						int yl = Math.max(j- this.radius, 0);
						int yh = Math.min(j+ this.radius, c-1);
						int zl = Math.max(k- this.radius, 0);
						int zh = Math.min(k+ this.radius, s-1);
						for(int l= xl;l<xh;l++)
							for(int p= yl;p<yh;p++)
								for(int n = zl;n<zh;n++)
									mask[l][p][n]=true;
					}
				}
			}
		}
	}

	public boolean[][][] getMask(){
		return this.mask;
	}
}
