package edu.vanderbilt.masi.algorithms.clasisfication;

import java.util.ArrayList;

public class IntensityFeatureCalculator extends FeatureCalculator {

	private int radius;
	
	
	public IntensityFeatureCalculator(int radius){
		this.radius = radius;
		this.names = new ArrayList<String>();
		this.names.add("Voxel Intensity");
		this.names.add("Mean Intensity Radius "+this.radius);
		this.names.add("Standard Deviation Radius "+this.radius);
		this.names.add("Mean Intensity Above Radius "+this.radius);
		this.names.add("Standard Deviation Above Radius "+this.radius);
		this.names.add("Mean Intensity Below Radius "+this.radius);
		this.names.add("Standard Deviation Below Radius "+this.radius);
		this.names.add("Mean Intensity Anterior Radius "+this.radius);
		this.names.add("Standard Deviation Anteroir Radius "+this.radius);
		this.names.add("Mean Intensity Posterior Radius "+this.radius);
		this.names.add("Standard Deviation Posterior Radius "+this.radius);
		this.names.add("Mean Intensity Superior Radius "+this.radius);
		this.names.add("Standard Deviation Superior Radius "+this.radius);
		this.names.add("Mean Intensity Inferior Radius "+this.radius);
		this.names.add("Standard Deviation Inferior Radius "+this.radius);
	}
	
	@Override
	public ArrayList<Float> calculateFeatures(float[][][] im, int r, int c, int s){
		ArrayList<Float> features = new ArrayList<Float>(15);
		features.add(im[r][c][s]);
		int xl = Math.max(0, r-radius);
		int xh = Math.min(r+radius, im.length-1);
		int yl = Math.max(0, c-radius);
		int yh = Math.min(c+radius, im[0].length-1);
		int zl = Math.max(0, s-radius);
		int zh = Math.min(s+radius, im[0][0].length-1);
		features.add(calculateMean(im,xl,xh,yl,yh,zl,zh));
		features.add(calculateSTD(im,features.get(1),xl,xh,yl,yh,zl,zh));
		features.add(calculateMean(im,r+1,xh,yl,yh,zl,zh));
		features.add(calculateSTD(im,features.get(3),r+1,xh,yl,yh,zl,zh));
		features.add(calculateMean(im,xl,r-1,yl,yh,zl,zh));
		features.add(calculateSTD(im,features.get(5),xl,r-1,yl,yh,zl,zh));
		features.add(calculateMean(im,xl,xh,c+1,yh,zl,zh));
		features.add(calculateSTD(im,features.get(7),xl,xh,c+1,yh,zl,zh));
		features.add(calculateMean(im,xl,xh,yl,c-1,zl,zh));
		features.add(calculateSTD(im,features.get(9),xl,xh,yl,c-1,zl,zh));
		features.add(calculateMean(im,xl,xh,yl,yh,s+1,zh));
		features.add(calculateSTD(im,features.get(11),xl,xh,yl,yh,s+1,zh));
		features.add(calculateMean(im,xl,xh,yl,yh,zl,s-1));
		features.add(calculateSTD(im,features.get(13),xl,xh,yl,yh,zl,s-1));
		return features;
	}
	
	public ArrayList<String> getFeatureNames(){
		
		return this.names;
	}
	
	private float calculateMean(float[][][] im, int xl,int xh, int yl, int yh, int zl,int zh){
		float value=0;
		int num=0;
		for(int i=xl;i<=xh;i++){
			for(int j=yl;j<yh;j++){
				for(int k=zl;k<zh;k++){
					value += im[i][j][k];
					num++;
				}
			}
		}
		float mean;
		if(num>0)
			mean = value/num;
		else mean = 0;
		return mean;
	}
	
	private float calculateSTD(float[][][] im,float mean, int xl,int xh, int yl,int yh, int zl, int zh){
		float value = 0;
		int num = 0;
		for(int i=xl;i<=xh;i++){
			for(int j=yl;j<=yh;j++){
				for(int k=zl;k<=zh;k++){
					value += (im[i][j][k]-mean)*(im[i][j][k]-mean);
					num++;
				}
			}
		}
		float std;
		if(num>0)
			std = (float) Math.sqrt(value/num);
		else std = 0;
		return std;
	}

	@Override
	public boolean takesIntensity() {
		return true;
	}

	@Override
	public boolean takesLabels() {
		return false;
	}

	@Override
	public ArrayList<Float> calculateFeatures(int[][][] im, int r, int c, int s) {
		return null;
	}

}
