package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;

public class FMAPParams {
	protected File filename;
	protected int acq_vox_m;
	protected int acq_vox_p;
	protected int slice_thickness;
	protected int rec_vox_m;
	protected String slice_orientation;
	protected String fold_over_dir;
	protected int fitorder;
	protected int[] fitsize;
	protected int vox_dilate;
	protected float vox_kern;
	protected String fitregion;
	
	public FMAPParams(File filename, int acq_vox_m, int acq_vox_p, int slice_thickness, int rec_vox_m,
			String slice_orientation, String fold_over_dir, int fitorder, int[] fitsize, int vox_dilate,
			float vox_kern, String fitregion){
		this.filename = filename;
		this.acq_vox_m = acq_vox_m;
		this.acq_vox_p = acq_vox_p;
		this.slice_thickness = slice_thickness;
		this.rec_vox_m = rec_vox_m;
		this.slice_orientation = slice_orientation;
		this.fold_over_dir = fold_over_dir;
		this.fitorder = fitorder;
		this.fitsize = fitsize;
		this.vox_dilate = vox_dilate;
		this.vox_kern = vox_kern;
		this.fitregion = fitregion;
		
	}
	
	public File get_filename(){
		return this.filename;
	}
	public int get_acq_vox_m(){
		return this.acq_vox_m;
	}
	public int get_acq_vox_p(){
		return this.acq_vox_p;
	}
	public int get_slice_thickness(){
		return this.slice_thickness;
	}
	public int get_rec_vox_m(){
		return this.rec_vox_m;
	}
	public String get_slice_orientation(){
		return this.slice_orientation;
	}
	public String get_fold_over_dir(){
		return this.fold_over_dir;
	}
	public int get_fitorder(){
		return this.fitorder;
	}
	public int[] get_fitsize(){
		return this.fitsize;
	}
	public int get_vox_dilate(){
		return this.vox_dilate;
	}
	public float get_vox_kern(){
		return this.vox_kern;
	}
	public String get_fitregion(){
		return this.fitregion;
	}
}
