package edu.vanderbilt.masi.algorithms.dti;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Collections;
import java.util.TreeSet;

import org.apache.commons.lang.ArrayUtils;

import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class ListDataParser {
	
	
	static String typ;
	static String mix;
	static String dyn;
	static String card;
	static String echo;
	static String loca;
	static String chan;
	static String extr1;
	static String extr2;
	static String ky;
	static String kz;
	static String na;
	static String aver;
	static String sign;
	static String rf;
	static String grad;
	static String enc;
	static String rtop;
	static String rr;
	static String size;
	static String offset;
	final static String[] dataTypes = {"STD", "PHX", "FRX", "NOI", "PHC"};
	final static String[] attributes = {"mix","dyn","card","echo","loca","chan","extr1","extr2",
										"ky","kz","na","aver","sign","rf","grad","enc","rtop",
										"rr","size","offset"};
	
	/*
	 * Constant data orders 
	 */
	final static String[] STD_DATA_ORDER = {"kx","ky","kz","loca","dyn","card","echo","mix","aver","chan","extr1","extr2"};
	final static String[] PHX_DATA_ORDER = {"kx","loca","echo","mix","chan","sign"};
	final static String[] FRX_DATA_ORDER = {"kx","loca","echo","mix","chan","sign"};
	final static String[] NOI_DATA_ORDER = {"kx","loca","chan"};
	final static String[] PHC_DATA_ORDER = {"kx","ky","kz","loca","dyn","card","echo","mix", "chan","aver","sign","grad"};
	static float[][][][][][][][][][][][] STD_REAL;
	static float[][][][][][][][][][][][] STD_IMAG;
	static float[][][][][][] PHX_REAL;
	static float[][][][][][] PHX_IMAG;
	static float[][][][][][] FRX_REAL;
	static float[][][][][][] FRX_IMAG;
	static float[][][] NOI_REAL;
	static float[][][] NOI_IMAG;
	static float[][][][][][][][][][][][] PHC_REAL;
	static float[][][][][][][][][][][][] PHC_IMAG;
	
	
	public static void main(String args[]) throws IOException{
		File listFile = new File(args[0]);
		File dataFile = new File(args[1]);
		Map hashParams = parseListFile(listFile);
		readListData(dataFile, hashParams);
		
	}
	
	/**
	 * Java version of f_read_listdata.m
	 * @param f the fullpath to the data filename
	 * @param m the map of typ, mix etc to the values in arraylist string format (info in f_read_listdata.m)
	 * @throws IOException 
	 */
	protected static void readListData(File dataFile, Map<String, ArrayList<String>> m) throws IOException{
		ArrayList<String> typ = m.get("typ");
		boolean[] matches;
		for (String thisDataType: dataTypes){
			matches = getIndices(thisDataType,typ);
			boolean hasType = false;
			for (boolean bool: matches){
				if (bool){
					hasType = true;
					break;
				}
			}
			if (thisDataType.equals("STD") && hasType){
				System.out.println("BEGIN STD DATA READ");
				int[] d = initRealAndImag(matches,m,thisDataType,STD_DATA_ORDER);
				//STD_REAL = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]][d[6]][d[7]][d[8]][d[9]][d[10]][d[11]];
				//STD_IMAG = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]][d[6]][d[7]][d[8]][d[9]][d[10]][d[11]];
				JistLogger.logOutput(JistLogger.FINE, "Finished initializing STD REAL and IMAG Data");
				System.out.println("END STD DATA READ");
			}else if (thisDataType.equals("PHX") && hasType){
				int[] d = initRealAndImag(matches,m,thisDataType,PHX_DATA_ORDER);
				PHX_REAL = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]];
				PHX_IMAG = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]];
				JistLogger.logOutput(JistLogger.FINE, "Finished initializing PHX REAL and IMAG Data");
			}else if (thisDataType.equals("FRX") && hasType){
				int[] d = initRealAndImag(matches,m,thisDataType,FRX_DATA_ORDER);
				FRX_REAL = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]];
				FRX_IMAG = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]];
				JistLogger.logOutput(JistLogger.FINE, "Finished initializing FRX REAL and IMAG Data");
			}else if (thisDataType.equals("NOI") && hasType){
				int[] d = initRealAndImag(matches,m,thisDataType,STD_DATA_ORDER);
				int[] dims = initRealAndImag(matches,m,thisDataType,NOI_DATA_ORDER);
				Map<String,int[]> noi_map = fetchListDataValues(matches, m,"NOI");
				int[] locaArray = noi_map.get("loca");		//The locations in the matrix
				
				//These values need to be re-indexed due to an issue with the body coil and receive coil
				//See around line 464 in f_read_listdata.m
				//Note that this is really stupid. We have lots of null values are a result.
				int[] channelArray = noi_map.get("chan");		//The channel used to receive
				List<Integer> channelList = Arrays.asList(ArrayUtils.toObject(channelArray));
				final int channelOffset = Collections.min(channelList);
				int chanDim=0;
				int[] fixedChannelArray = new int[channelArray.length];
				for (int i=0;i<channelArray.length;i++){
					if (channelArray[i]==channelArray[channelArray.length-1]){
						chanDim = channelArray[channelArray.length-2]+2-channelOffset;
						fixedChannelArray[i]=chanDim-1;
					}else{
						fixedChannelArray[i] = channelArray[i]-channelOffset;
					}
				}
				channelArray=null;
				NOI_REAL = new float[dims[0]][dims[1]][chanDim];
				NOI_IMAG = new float[dims[0]][dims[1]][chanDim];
				
				JistLogger.logOutput(JistLogger.FINE, "Finished initializing NOI REAL and IMAG Data");
				
				FileInputStream fis = new FileInputStream(dataFile);
				DataInputStream dis = new DataInputStream(fis);
				
				//Find out how many lines we need to read.
				int linesToRead = noi_map.get("offset").length;
				
				JistLogger.logOutput(JistLogger.INFO,"Found "+linesToRead+" lines to read of type NOI");
				for ( int ln=0; ln<linesToRead; ln++){
					int thisLocation = locaArray[ln];
					int thisChannel = fixedChannelArray[ln];
					System.out.println("Reading in location "+thisLocation+" channel "+thisChannel);
					
					byte[] buffer = new byte[noi_map.get("size")[ln]];
					
					dis.readFully(buffer);
					
					//Get the real values for the buffer
					int count=0;
					for (int i=0; i<buffer.length;i+=8){
						byte[] temp = new byte[4];
						for (int j=0;j<4;j++){
							temp[j] = buffer[i+j];
						}
						float myfloat = ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getFloat();
						NOI_REAL[count][thisLocation][thisChannel] = myfloat;
						count+=1;
					}
					
					//Get the imaginary values for the buffer
					count=0;
					for (int i=4; i<buffer.length;i+=8){
						byte[] temp = new byte[4];
						for (int j=0;j<4;j++){
							temp[j] = buffer[i+j];
						}
						float myfloat = ByteBuffer.wrap(temp).order(ByteOrder.LITTLE_ENDIAN).getFloat();
						NOI_IMAG[count][thisLocation][thisChannel] = myfloat;
						count+=1;
					}
				}
					
				dis.close();
				fis.close();
				ReferenceUtils refUtils = new ReferenceUtils(NOI_REAL,NOI_IMAG);
				float[][] PSI_IMAG = refUtils.getImagPSI();
//				for (int i=0;i<8;i++){
//					for (int j=0;j<8;j++){
//						System.out.format("%f " ,PSI_IMAG[i][j]);
//					}
//					System.out.println("");
//				}
				
				System.out.println("NOI - Data read in");
			}else if (thisDataType.equals("PHC")&& hasType ){
				int[] d = initRealAndImag(matches,m,thisDataType,PHC_DATA_ORDER);
				PHC_REAL = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]][d[6]][d[7]][d[8]][d[9]][d[10]][d[11]];
				PHC_IMAG = new float[d[0]][d[1]][d[2]][d[3]][d[4]][d[5]][d[6]][d[7]][d[8]][d[9]][d[10]][d[11]];
				JistLogger.logOutput(JistLogger.FINE, "Finished initializing PHC REAL and IMAG Data");
			}
		}
		
		
		
		
		
		
	}
	
	protected static int[] initRealAndImag(boolean[] matches, Map<String, ArrayList<String>> m, String thisDataType, String[] order){
		int[] theseDimensions = new int[order.length];
		
		try {
			//This is a map of JUST the values for the specific datatype since we read everything and put it into one huge hashmap
			Map<String,int[]> tempDataTypeValues = fetchListDataValues(matches, m,thisDataType);
			int counter = 0;
			
			for (String s: order){
				System.out.format("TYPE = %s\n",s);
				int[] tmp = tempDataTypeValues.get(s);
				if (s.equals("kx")){
					int kxSize = get_kx_size(tempDataTypeValues.get("size"));
					theseDimensions[counter] = kxSize;
				}else if (s.equals("chan")){
					int chanSize = get_chan_size(tempDataTypeValues.get(s));
					theseDimensions[counter] = chanSize;
				}
				else{
					int thisTempSize = get_gen_size(tempDataTypeValues.get(s));
					int[] temp = tempDataTypeValues.get(s);
					theseDimensions[counter] = thisTempSize;
				}
				counter+=1;
			}			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return theseDimensions;
		
	}
	
	/**
	 * Method to return the values ONLY corresponding to the specifc paramType. 
	 * @param matches the vector of true/false match values
	 * @param map the hashmap for each type
	 * @throws IOException 
	 */
	protected static Map<String,int[]> fetchListDataValues(boolean[] matches, Map<String, ArrayList<String>> map, String datakey) throws IOException{
		Map<String,int[]> outputMultiMap = new HashMap<String,int[]>();
		
		//OK so we're going to iterate each attribute and get all of the values associated with them
		//lucky for use they're all integers but saved as strings so we need 10 million calls to Integer.valueOf().
		//This should be fixed at some point.
		ArrayList<String> typeList = map.get("typ");
		for (String attributekey: attributes){
			ArrayList<String> myValues = map.get(attributekey); // Get the values from the predefined map
			
			ArrayList<Integer> tempList = new ArrayList<Integer>(); // Get a temporary list to shove into a temp hashmap
			for (int i=0; i < matches.length;i++){
				if (matches[i] && typeList.get(i).equals(datakey)){
					tempList.add(Integer.valueOf(myValues.get(i)));
				}
			}
			int[] tempIntArr = new int[tempList.size()];
			for (int z = 0; z<tempList.size(); z++){
				tempIntArr[z]=tempList.get(z);
			}
			outputMultiMap.put(attributekey, tempIntArr);
		}
			
		
		
		//Now we need to just get the unique values and sort the arrays.
		return outputMultiMap;
	}
	
	
	protected static int get_kx_size(int[] arr){
		return arr[arr.length-1]/4/2;
	}
	
	/**
	 * So a lot of the attributes use the same call. Let's just make a generic function for this rather than a specific getter
	 * @param arr
	 * @return
	 */
	protected static int get_gen_size(int[] arr){
		//Some of the params are negative. So we need to know the true range
		int maxval = arr[0];
		int minval = arr[0];
		for (int i=1;i<arr.length;i++){
			if (arr[i]>maxval){
				maxval=arr[i];
			}
			if (arr[i]<minval){
				minval=arr[i];
			}
			
		}
		return 1-minval+maxval;
	}
	
	protected static int get_chan_size(int[] arr){
	HashSet<Integer> distinct = new HashSet<Integer>();
	for (int i=0; i<arr.length;i++){
		distinct.add(arr[i]);
	}
	return distinct.size();
	}
	
	/**
	 * Method to return a boolean array if the type matches the iterator type
	 * @param s the sting to match
	 * @param list the arraylist of strings of each row in the .data file's type
	 * @return boolean array of matches
	 */
	protected static boolean[] getIndices(String s, ArrayList<String> list){
		boolean[] matches = new boolean[list.size()];
	
		for (int i=0; i < list.size();i++){
			if (s.equals(list.get(i))){
				matches[i] = true;
			}else{
				matches[i] = false;
			}
		}
		return matches;
	}
	
	/**
	 * Method to read the header file and put it into a hashmap
	 * @param f the list data file
	 * @return Hashmap of the types to their associated values
	 * @throws IOException
	 */
	protected static Map parseListFile(File f) throws IOException{
		BufferedReader br = new BufferedReader(new FileReader(f));
		String line;
		// build up our map
		Map<String,ArrayList<String>> multiMap = new HashMap<String,ArrayList<String>>();
		// This is so stupid. There has got to be a better way to do this
		ArrayList<String> arr_typ = new ArrayList<String>();
		ArrayList<String> arr_mix = new ArrayList<String>();
		ArrayList<String> arr_dyn = new ArrayList<String>();
		ArrayList<String> arr_card = new ArrayList<String>();
		ArrayList<String> arr_echo = new ArrayList<String>();
		ArrayList<String> arr_loca = new ArrayList<String>();
		ArrayList<String> arr_chan = new ArrayList<String>();
		ArrayList<String> arr_extr1 = new ArrayList<String>();
		ArrayList<String> arr_extr2 = new ArrayList<String>();
		ArrayList<String> arr_ky = new ArrayList<String>();
		ArrayList<String> arr_kz = new ArrayList<String>();
		ArrayList<String> arr_na = new ArrayList<String>();
		ArrayList<String> arr_aver = new ArrayList<String>();
		ArrayList<String> arr_sign = new ArrayList<String>();
		ArrayList<String> arr_rf = new ArrayList<String>();
		ArrayList<String> arr_grad = new ArrayList<String>();
		ArrayList<String> arr_enc = new ArrayList<String>();
		ArrayList<String> arr_rtop = new ArrayList<String>();
		ArrayList<String> arr_rr = new ArrayList<String>();
		ArrayList<String> arr_size = new ArrayList<String>();
		ArrayList<String> arr_offset = new ArrayList<String>();
		while((line=br.readLine())!=null){
			if (!line.startsWith(".") && !line.startsWith("#")){
				processLine(line);

				arr_typ.add(typ);
				arr_mix.add(mix);
				arr_dyn.add(dyn);
				arr_card.add(card);
				arr_echo.add(echo);
				arr_loca.add(loca);
				arr_chan.add(chan);
				arr_extr1.add(extr1);
				arr_extr2.add(extr2);
				arr_ky.add(ky);
				arr_kz.add(kz);
				arr_na.add(na);
				arr_aver.add(aver);
				arr_sign.add(sign);
				arr_rf.add(rf);
				arr_grad.add(grad);
				arr_enc.add(enc);
				arr_rtop.add(rtop);
				arr_rr.add(rr);
				arr_size.add(size);
				arr_offset.add(offset);
			}
		}
		multiMap.put("typ", arr_typ);
		multiMap.put("mix", arr_mix);
		multiMap.put("dyn", arr_dyn);
		multiMap.put("card", arr_card);
		multiMap.put("echo", arr_echo);
		multiMap.put("loca", arr_loca);
		multiMap.put("chan", arr_chan);
		multiMap.put("extr1", arr_extr1);
		multiMap.put("extr2", arr_extr2);
		multiMap.put("ky", arr_ky);
		multiMap.put("kz", arr_kz);
		multiMap.put("na", arr_na);
		multiMap.put("aver", arr_aver);
		multiMap.put("sign", arr_sign);
		multiMap.put("rf", arr_rf);
		multiMap.put("grad", arr_grad);
		multiMap.put("enc", arr_enc);
		multiMap.put("rtop", arr_rtop);
		multiMap.put("rr", arr_rr);
		multiMap.put("size", arr_size);
		multiMap.put("offset", arr_offset);
		return multiMap;
	}

	/* Split the line and assign each part of the line to its associated variable. 
	This should be replaced with something less stupid
	*/
	protected static void processLine(String aLine){
		    Scanner scanner = new Scanner(aLine.trim());
		    if (scanner.hasNext()){
			      typ = scanner.next();
			      mix= scanner.next();
				  dyn= scanner.next();
				  card= scanner.next();
				  echo= scanner.next();
				  loca= scanner.next();
				  chan= scanner.next();
				  extr1 = scanner.next();
				  extr2 = scanner.next();
				  ky = scanner.next();
				  kz = scanner.next();
				  na = scanner.next();
				  aver = scanner.next();
				  sign = scanner.next();
				  rf = scanner.next();
				  grad = scanner.next();
				  enc = scanner.next();
				  rtop = scanner.next();
				  rr = scanner.next();
				  size = scanner.next();
				  offset = scanner.next();
		    }
		    scanner.close();
		
		  }

}
