package edu.vanderbilt.masi.algorithms.dti;

public class RECONParams {

	private int[] oversample_resolutions;
	private int[] oversample_factors;
	private int[] scan_resolutions;
	private int[] profiles;
	private int[] interp_factors;
	private int[] ft_lengths;
	private int[] recon_resolutions;
	private int[] epi_factors;
	private int[] partial_matrix_factors;
	private int[] sense_factors;
	private int[] max_encoding_numbers;
	private int[] min_encoding_numbers;
	private int[] lca_pre_sense_samples;
	private int[] lca_samples;
	private int[] lca_oversample_factors;
	private int[] lca_sense_factors;
	private int aspect_ratio;
	private int[] ACQ_matrix_MxP;
	private int[] ACQ_voxel_MPS;
	private int[] REC_voxel_MPS;
	private int number_of_shots;
    private int s_N_res_m;
    private int s_N_final_m;
    private int s_N_res_p;
    private int s_N_final_p;
    private int s_cut_vox_m;
    private int s_zeropad_vox_m;
    private int s_cut_vox_p;
    private int s_zeropad_vox_p;
    private int a_N_recon_m;
    private int a_N_recon_p;
    private int a_N_final_interp_p;
    private int a_N_final_interp_recon_p;
    private int a_zeropad_vox_p;
    
    public RECONParams(int[] oversample_resolutions,int[] oversample_factors,int[] scan_resolutions,
    		int[] profiles,int[] interp_factors,int[] ft_lengths,int[] recon_resolutions,int[] epi_factors,
    		int[] partial_matrix_factors,int[] sense_factors,int[] max_encoding_numbers,
    		int[] min_encoding_numbers,int[] lca_pre_sense_samples,int[] lca_samples,
    		int[] lca_oversample_factors,int[] lca_sense_factors,int aspect_ratio,int[] ACQ_matrix_MxP,
    		int[] ACQ_voxel_MPS,int[] REC_voxel_MPS,int number_of_shots,int s_N_res_m,int s_N_final_m,
    		int s_N_res_p,int s_N_final_p,int s_cut_vox_m,int s_zeropad_vox_m,int s_cut_vox_p,
    		int s_zeropad_vox_p,int a_N_recon_m,int a_N_recon_p,int a_N_final_interp_p,
    		int a_N_final_interp_recon_p,int a_zeropad_vox_p){
    		
    	this.oversample_resolutions=oversample_resolutions;
    	this.oversample_factors=oversample_factors;
    	this.scan_resolutions=scan_resolutions;
    	this.profiles=profiles;
    	this.interp_factors=interp_factors;
    	this.ft_lengths=ft_lengths;
    	this.recon_resolutions=recon_resolutions;
    	this.epi_factors=epi_factors;
    	this.partial_matrix_factors=partial_matrix_factors;
    	this.sense_factors=sense_factors;
    	this.max_encoding_numbers=max_encoding_numbers;
    	this.min_encoding_numbers=min_encoding_numbers;
    	this.lca_pre_sense_samples=lca_pre_sense_samples;
    	this.lca_samples=lca_samples;
    	this.lca_oversample_factors=lca_oversample_factors;
    	this.lca_sense_factors=lca_sense_factors;
    	this.aspect_ratio=aspect_ratio;
    	this.ACQ_matrix_MxP=ACQ_matrix_MxP;
    	this.ACQ_voxel_MPS=ACQ_voxel_MPS;
    	this.REC_voxel_MPS=REC_voxel_MPS;
    	this.number_of_shots=number_of_shots;
    	this.s_N_res_m=s_N_res_m;
    	this.s_N_final_m=s_N_final_m;
    	this.s_N_res_p=s_N_res_p;
    	this.s_N_final_p=s_N_final_p;
    	this.s_cut_vox_m=s_cut_vox_m;
    	this.s_zeropad_vox_m=s_zeropad_vox_m;
    	this.s_cut_vox_p=s_cut_vox_p;
    	this.s_zeropad_vox_p=s_zeropad_vox_p;
    	this.a_N_recon_m=a_N_recon_m;
    	this.a_N_recon_p=a_N_recon_p;
    	this.a_N_final_interp_p=a_N_final_interp_p;
    	this.a_N_final_interp_recon_p=a_N_final_interp_recon_p;
    	this.a_zeropad_vox_p=a_zeropad_vox_p;
    		
    }
    
    public int[] get_oversample_resolutions(){
    	return this.oversample_resolutions;
    }
	public int[] get_oversample_factors(){
		return this.oversample_factors;
	}
	public int[] get_scan_resolutions(){
		return this.scan_resolutions;
	}
	public int[] get_profiles(){
		return this.profiles;
	}
	public int[] get_interp_factors(){
		return this.interp_factors;
	}
	public int[] get_ft_lengths(){
		return this.ft_lengths;
	}
	public int[] get_recon_resolutions(){
		return this.recon_resolutions;
	}
	public int[] get_epi_factors(){
		return this.epi_factors;
	}
	public int[] get_partial_matrix_factors(){
		return this.partial_matrix_factors;
	}
	public int[] get_sense_factors(){
		return this.sense_factors;
	}
	public int[] get_max_encoding_numbers(){
		return this.max_encoding_numbers;
	}
	public int[] get_min_encoding_numbers(){
		return this.min_encoding_numbers;
	}
	public int[] get_lca_pre_sense_samples(){
		return this.lca_pre_sense_samples;
	}
	public int[] get_lca_samples(){
		return this.lca_samples;
	}
	public int[] get_lca_oversample_factors(){
		return this.lca_oversample_factors;
	}
	public int[] get_lca_sense_factors(){
		return this.lca_sense_factors;
	}
	public int get_aspect_ratio(){
		return this.aspect_ratio;
	}
	public int[] get_ACQ_matrix_MxP(){
		return this.ACQ_matrix_MxP;
	}
	public int[] get_ACQ_voxel_MPS(){
		return this.ACQ_voxel_MPS;
	}
	public int[] get_REC_voxel_MPS(){
		return this.REC_voxel_MPS;
	}
	public int get_number_of_shots(){
		return this.number_of_shots;
	}
    public int get_s_N_res_m(){
    	return this.s_N_res_m;
    }
    public int get_s_N_final_m(){
    	return this.s_N_final_m;
    }
    public int get_s_N_res_p(){
    	return this.s_N_res_p;
    }
    public int get_s_N_final_p(){
    	return this.s_N_final_p;
    }
    public int get_s_cut_vox_m(){
    	return this.s_cut_vox_m;
    }
    public int get_s_zeropad_vox_m(){
    	return this.s_zeropad_vox_m;
    }
    public int get_s_cut_vox_p(){
    	return this.s_cut_vox_p;
    }
    public int get_s_zeropad_vox_p(){
    	return this.s_zeropad_vox_p;
    }
    public int get_a_N_recon_m(){
    	return this.a_N_recon_m;
    }
    public int get_a_N_recon_p(){
    	return this.a_N_recon_p;
    }
    public int get_a_N_final_interp_p(){
    	return this.a_N_final_interp_p;
    }
    public int get_a_N_final_interp_recon_p(){
    	return this.a_N_final_interp_recon_p;
    }
    public int get_a_zeropad_vox_p(){
    	return this.a_zeropad_vox_p;
    }
}
