package edu.vanderbilt.masi.algorithms.external;

import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.vanderbilt.masi.algorithms.external.JSONValidate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExternalModuleBuilder {
	ArrayList<String> theHeader;
	ArrayList<String> theInputs;
	ArrayList<String> theOutputs;
	ArrayList<String> theExecution;
	JSONValidate jsonValidator;
	File thePlugin; 
	File thePluginFile;
	
	//Validate the input file and set it so we can iterate through it
	public ExternalModuleBuilder(File f,File outputPath){
		JSONValidate jsonValidator = new JSONValidate( f);
		this.jsonValidator=jsonValidator;
		importAndBuild(outputPath); 	//build the plugin
	}
	
	private void importAndBuild(File out) {
		buildHeader();
		buildInputs();
		buildOutputs();
		buildExecution();
		writePlugin(out);
	}

	//Build the header of the module. 
	public void buildHeader(){
		theHeader = new ArrayList<String>();
		theHeader.add("package "+jsonValidator.getPackageName()+";\n\n");
		
		//The default imports. Param collection alawys has to be added.
		String[] defaultImports = {"import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;",
								   "import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;",
								   "import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;",
								   "import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;",
								   "import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;",
								   "import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;",
								   "import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;"};
		//Add the default imports
		for (String el:defaultImports){
			theHeader.add(el+"\n");
		}
		
		//Grab the imports based on the required file types.
		ArrayList<String> theRequiredInputs = jsonValidator.getRequiredParamImports();
		for (String el:theRequiredInputs){
			theHeader.add(el+"\n");
		}
		//Add the inputs/outputs based on the required type. 
		
		
		
		
		
		
		
		theHeader.add("public class "+jsonValidator.getPluginClassName()+" extends ProcessingAlgorithm{\n");
		theHeader.add("\t/****************************************************\n");
		theHeader.add("\t* CVS Version Control\n");
		theHeader.add("\t****************************************************/\n");
		theHeader.add("\tprivate static final String cvsversion = \"$Revision: 1.4 $\";\n");
		theHeader.add("\tprivate static final String revnum = cvsversion.replace(\"Revision: \", \"\").replace(\"$\", \"\").replace(\" \", \"\");\n");
		theHeader.add("\tprivate static final String shortDescription = "+jsonValidator.getShortDescription()+";\n");
		theHeader.add("\tprivate static final String longDescription = "+jsonValidator.getLongDescription()+";\n");
		
		//CVS Version control section
		
		
	}
	
	//Build the inputs section of the module
	public void buildInputs(){
		theInputs = new ArrayList<String>();
		
		theInputs.add("\t@Override\n");
		theInputs.add("\tprotected void createInputParameters(ParamCollection inputParams) {\n");
		
		//Inputs
		JSONArray inputs = jsonValidator.setInputObjs();
		for (int i=0;i<inputs.length();i++){
			try {
				JSONObject theObj = inputs.getJSONObject(i);
				theHeader.add("\t"+theObj.getString("type")+" "+theObj.getString("varName")+";\n");
			} catch (JSONException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		//Outputs
		JSONArray outputs = jsonValidator.setOutputObjs();
		for (int i=0;i<outputs.length();i++){
			try {
				JSONObject theObj = outputs.getJSONObject(i);
				theHeader.add("\t"+theObj.getString("type")+" "+theObj.getString("varName")+";\n");
			} catch (JSONException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}		
		
		//TODO: set the outputs - by default add the std out, stderr, and exit status to their own files.
		theHeader.add("\tParamFile exitStatusFile;\n");
		theHeader.add("\tParamFile externalCommandStdOut;\n");
		theHeader.add("\tParamFile externalCommandStdErr;\n");
		//TODO: add each input param and set mandatory status
		
		theInputs.add("\t\tinputParams.setPackage(\""+jsonValidator.getPackageName()+"\");\n");
		theInputs.add("\t\tinputParams.setCategory(\""+jsonValidator.getPluginCategory()+"\");\n");
		theInputs.add("\t\tinputParams.setLabel(\""+jsonValidator.getPluginLabel()+"\");\n");
		theInputs.add("\t\tinputParams.setName(\""+jsonValidator.getPluginName()+"\");\n");
		
		theInputs.add("\t\tAlgorithmInformation info = getAlgorithmInformation();\n");
		theInputs.add("\t\tinfo.setWebsite(\""+jsonValidator.getPluginAlgorithmWebsite()+"\");\n");
		theInputs.add("\t\tinfo.setAffiliation(\""+jsonValidator.getPluginAlgorithmAuthorAffiliation()+"\");\n");
		
		theInputs.add("\t\tinfo.setDescription(shortDescription);\n");
		theInputs.add("\t\tinfo.setLongDescription(longDescription);\n");
		theInputs.add("\t\tinfo.setVersion(revnum);\n");
		theInputs.add("\t\tinfo.setEditable("+jsonValidator.getPluginEditableStatus()+");\n");
		theInputs.add("\t\tinfo.setStatus(DevelopmentStatus."+jsonValidator.getPluginDevelopmentStatus()+");\n");
		
		JSONArray inputsStr = jsonValidator.setInputObjs();
		for (int i=0;i<inputsStr.length();i++){
			try {
				JSONObject theObj = inputsStr.getJSONObject(i);
				theInputs.add("\t\tinputParams.add("+theObj.getString("varName")+" = new "+theObj.getString("type")+"(\""+theObj.getString("name")+"\"));\n");
				theInputs.add("\t\t"+theObj.getString("varName")+".setMandatory("+theObj.getString("required")+");\n");
				
			} catch (JSONException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		theInputs.add("\t}\n");
				
	}
	
	//Build the outputs section of the module
	public void buildOutputs(){
		theOutputs = new ArrayList<String>();
		theOutputs.add("\t@Override\n");
		theOutputs.add("\tprotected void createOutputParameters(ParamCollection outputParams) {\n");
		
		//iterate throught the output params
		
		//The default outputs.
		JSONArray outputs = jsonValidator.setOutputObjs();
		for (int i=0;i<outputs.length();i++){
			try {
				JSONObject theObj = outputs.getJSONObject(i);
				theOutputs.add("\t\toutputParams.add("+theObj.getString("varName")+" = new "+theObj.getString("type")+"(\""+theObj.getString("name")+"\"));\n");
				theOutputs.add("\t\t"+theObj.getString("varName")+".setMandatory("+theObj.getString("required")+");\n");
				
			} catch (JSONException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		theOutputs.add("\t\toutputParams.add(exitStatusFile = new ParamFile(\"File which has the exit status\"));\n");
		theOutputs.add("\t\toutputParams.add(externalCommandStdOut = new ParamFile(\"File which has the std out of the external command\"));\n");
		theOutputs.add("\t\toutputParams.add(externalCommandStdErr = new ParamFile(\"File which has the std err of the external command\"));\n");
		
		theOutputs.add("\t}\n");
	}
	
	//Build the execution context;
	public void buildExecution(){
		theExecution = new ArrayList<String>();
		theExecution.add("\t@Override\n");
		
		theExecution.add("\tprotected void execute(CalculationMonitor monitor)\n");
		theExecution.add("\t\tthrows AlgorithmRuntimeException {\n");
		theExecution.add("\t}\n");
	}
	
	//Write the information to a plugin
	private void writePlugin(File outputPath){
		String pluginName = jsonValidator.getPluginClassName();
		FileWriter fw;
		try {
			thePluginFile = new File(outputPath.toString()+File.separator+pluginName+".java");
			fw = new FileWriter(thePluginFile);
			BufferedWriter bw = new BufferedWriter(fw);
			for (String el:theHeader){
				bw.write(el);
				bw.flush();
			}
			for(String elIn:theInputs){
				System.out.println(elIn);
				bw.write(elIn);
				bw.flush();
			}
			for (String elOut:theOutputs){
				bw.write(elOut);
				bw.flush();
			}
			for (String elExec:theExecution){
				bw.write(elExec);
				bw.flush();
			}
			bw.close();
		} catch (IOException e) {
			JistLogger.logError(JistLogger.SEVERE, "Could not write the plugin file");
			e.printStackTrace();
		}
        
	}
	
	
	public File getPluginFile(){
		return thePluginFile;
	}
}
