package edu.vanderbilt.masi.algorithms.labelfusion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public abstract class AbstractMultiSetVoting extends AbstractCalculation {
	
	private HashMap<String,Integer> classToInt;
	private HashMap<Integer,String> intToClass;
	protected List<Integer> classes;
	protected String[] classNames;
	private ImageData segmentation;
	private int numClasses;
	protected int numRaters;
	private String targetClass;
	protected int numTarget;
	private double[][][] probabilities;
	
	public AbstractMultiSetVoting(File raterMap,File thetaFile,String tc){
		super();
		setRaterMap(raterMap);
		targetClass = tc;
		loadTheta(thetaFile);
		log(String.format("There are %d classes", numClasses));
		log(String.format("There are %d raters", numRaters));
		log(String.format("There are %d labels in the target class", numTarget));
	}

	abstract public void run();
	
	abstract public ImageData getSegmentation();
	
	private void setRaterMap(File f){
		try 
		{
			BufferedReader br = new BufferedReader(new FileReader(f));
			String line;

			classes = new ArrayList<Integer>();
			intToClass = new HashMap<Integer,String>();
			classToInt = new HashMap<String,Integer>();
			int n = 0;
			while((line=br.readLine())!=null){
				if(!classToInt.containsKey(line)){
					classToInt.put(line, n);
					intToClass.put(n, line);
					n++;
				}
				classes.add(classToInt.get(line));
			}
			numClasses = classToInt.values().size();
			numRaters = classes.size();
			br.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		classNames = new String[numRaters];
		for(int i=0;i<numRaters;i++){
			classNames[i] = intToClass.get(classes.get(i));
		}
	}
	
	private void loadTheta(File f){
		try{
			probabilities = new double[numClasses][][];
			BufferedReader br = new BufferedReader(new FileReader(f));
			String line;
			line = br.readLine();
			while((line=br.readLine())!=null){
				String[] lineBits = line.split(",");
				if(lineBits[1].equals(targetClass)){
					loadMat(br,lineBits[0]);
				}else{
					skipMat(br,lineBits[0]);
				}
			}
			br.close();
		} catch (IOException e){
			e.printStackTrace();
		}
		numTarget=probabilities[0][0].length;
	}
	
	private void skipMat(BufferedReader br,String oc) throws IOException{
		log("Skipping: "+oc);
		String line;
		line = br.readLine(); // row count
		String[] lineBits = line.split(",");
		int numRows = Integer.parseInt(lineBits[0]);
		for(int i=0;i<numRows;i++)
			br.readLine();
	}
	
	private void loadMat(BufferedReader br,String oc) throws IOException{
		log("Loading Class "+oc);
		if(!classToInt.containsKey(oc)){
			skipMat(br,oc);
			return;
		}
		int classNum = classToInt.get(oc);
		String line = br.readLine();
		String[] lineBits = line.split(",");
		int numRows = Integer.parseInt(lineBits[0]);
		int numCols = Integer.parseInt(lineBits[1]);
		probabilities[classNum] = new double[numRows][numCols];
		for(int i=0;i<numRows;i++){
			line = br.readLine();
			lineBits = line.split(",");
			for(int j=0;j<numCols;j++){
				probabilities[classNum][i][j] = Double.parseDouble(lineBits[j]);
			}
		}
	}
	
	protected void log(String s){
		JistLogger.logOutput(JistLogger.WARNING, "[Abstract Multi-Set Voting] "+s);
	}
	
	protected double[] getProbabilities(int r,int lab){
		double[] vec = null;
		int c = classes.get(r);
		vec = probabilities[c][lab];
		return vec;
	}
	
}










