package edu.vanderbilt.masi.algorithms.regression;

public class Box {
	int left;
	int right;
	int top;
	int buttom;
	int front;
	int back;
	
	Point center;
	
	public Box(int left, int right, int top, int buttom, int front, int back)
	{
		this.left = left;
		this.right = right;
		this.top = top;
		this.buttom =  buttom;
		this.front = front;
		this.back  = back;
		
		int x = (left + right) / 2;
		int y = (top + buttom) / 2;
		int z = (front + buttom) / 2;
		this.center = new Point(x, y, z);
	}
	
	public Box(Point center, int xDim, int yDim, int zDim)
	{
		this.center = center;
		this.left = center.GetX() - xDim / 2;
		this.right = center.GetX() + xDim / 2;
		this.top = center.GetY() - yDim / 2;
		this.buttom =  center.GetY() + yDim / 2;
		this.front = center.GetZ() - zDim / 2;
		this.back  = center.GetZ() + zDim / 2;
	}
	
	public int GetLeft() {
		return this.left;
	}
	
	public int GetRight() {
		return this.right;
	}
	
	public int GetTop() {
		return this.top;
	}
	
	public int GetButtom() {
		return this.buttom;
	}
	
	public int GetFront() {
		return this.front;
	}
	
	public int GetBack() {
		return this.back;
	}
}
