package edu.vanderbilt.masi.algorithms.regression;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.*;


public class Forest {
	private List<Tree> trees = new ArrayList<Tree>();
	private int[][] leafNodeIndices;
	private boolean[] flags;
	
	public void AddTree(Tree tree) {
		tree.CheckValid();
		
		trees.add(tree);
	}
	
	public Tree GetTree(int index) {
		return trees.get(index);
	}
	
	public int GetTreeCount() {
		return trees.size();
	}
	
	public int[][] Apply(DataCollection data) throws InterruptedException
    {
		leafNodeIndices = new int[GetTreeCount()][];
		flags = new boolean[GetTreeCount()];
		int nCpus = Runtime.getRuntime().availableProcessors();
		ExecutorService pool =  Executors.newFixedThreadPool(nCpus);

		for (int t = 0; t < GetTreeCount(); t++)
		{
			ApplyRunnable r = new ApplyRunnable(t, data);
			pool.submit(r);
		}

		boolean flag = true;
    	while (flag) {
    		Thread.sleep(30);
    		int i = 0;
    		for (i = 0; i < GetTreeCount(); ++i) {
    			if (!flags[i]) break;
    		}
    		if (i == GetTreeCount()) flag = false;
    	}
    	pool.shutdown();
    	
		return leafNodeIndices;
    }
	
	public Document BuildDocument() throws ParserConfigurationException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document doc = builder.newDocument();
		Element rootElement = doc.createElement("Forest");
		for (Tree item : trees) {
			Element treeElement = doc.createElement("tree");
			item.CreateTreeElement(doc, treeElement);
			rootElement.appendChild(treeElement);
		}
		doc.appendChild(rootElement);
		return doc;
	}
	
	public void XmlParse(Document doc) throws Exception {
		NodeList children = doc.getElementsByTagName("tree");
		Element e = (Element) children.item(0);
		int n = e.getElementsByTagName("node").getLength();
		n = (int)(Math.log(n + 1) / Math.log(2)) - 1;
		for (int i = 0; i < children.getLength(); ++i) {
			Element treeElement = (Element) children.item(i);
			Tree tree = new Tree(n);
			tree.XmlParse(treeElement);
			trees.add(tree);
		}
	}
	
	/////////////////////////////////////////////
	public int[][][] GetNodeIdForBoxes(int boxCount) {
		int[][][] ids = new int[GetTreeCount()][boxCount][2];
		for (int i = 0; i < GetTreeCount(); ++i) {
			ids[i] = trees.get(i).GetNodeIdForBoxes(boxCount);
		}
		return ids;
	}
	
	class ApplyRunnable implements Runnable {
		private int _index;
		private DataCollection _data;
		
		public ApplyRunnable(int index, DataCollection data) {
			_index = index;
			_data = data;
		}
		
		public void run() {
			leafNodeIndices[_index] = trees.get(_index).Apply(_data);
			flags[_index] = true;
		}
	}
}
