package edu.vanderbilt.masi.algorithms.regression;

public class MatrixComputor {
	public static double[][] Copy(double[][] matrix) {
		int x = matrix.length;
		int y = matrix[0].length;
		double[][] result = new double[x][y];
		
		for (int i = 0; i < x; ++i) {
			for (int j = 0; j < y; ++j) {
				result[i][j] = matrix[i][j];
			}
		}
		
		return result;
	}
	
	public static double[] Copy(double[] matrix) {
		int x = matrix.length;
		double[] result = new double[x];
		
		for (int i = 0; i < x; ++i) {
				result[i] = matrix[i];
		}
		
		return result;
	}
	
	public static int[] Copy(int[] matrix) {
		int x = matrix.length;
		int[] result = new int[x];
		
		for (int i = 0; i < x; ++i) {
				result[i] = matrix[i];
		}
		
		return result;
	}
	
	public static double Multiply(double[] d1, double[] d2) {
		if (d1.length != d2.length) 
			return -1;
		
		double sum = 0.0;
		for (int i = 0; i < d1.length; ++i) {
			sum += d1[i] * d2[i];
		}
		
		return sum;
	}
	
	public static double[] Add(double[] d1, double[] d2) {
		if (d1.length != d2.length) 
			return null;
		
		double[] result = new double[d1.length];
		for (int i = 0; i < d1.length; ++i) {
			result[i]= d1[i] + d2[i];
		}
		
		return result;
	}
	
	public static double[][] Add(double[][] d1, double[][] d2) {
		int x1 = d1.length, x2 = d2.length;
		int y1 = d1[0].length, y2 = d2[0].length;
		
		if (x1 != x2 || y1 != y2) 
			return null;
		
		double[][] result = new double[x1][y1];
		for (int i = 0; i < x1; ++i) {
			for (int j = 0; j < y1; ++j) {
				result[i][j] = d1[i][j] + d2[i][j];
			}
		}
		
		return result;
	}
	
	public static double[] Scale(double[] d, double x) {
		int len = d.length;
		double[] result = new double[len];
		for (int i =0; i < len; ++i) {
			result[i] = d[i] * x;
		}
		return result;
	}
}
