package edu.vanderbilt.masi.algorithms.solar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;

public class Polygenic {

	public static String solarStringBuilder(ParamFileCollection pedigree,ParamFileCollection phenotypes,ParamFileCollection trait,ParamFileCollection covariates,ParamVolume imageData, ParamBoolean screen,
			ParamFloat prob, ParamFileCollection fix, ParamBoolean all, ParamFileCollection testcovar, ParamBoolean testrhoe, ParamBoolean testrhog, ParamBoolean testrhoc, 
			ParamBoolean testrhop, ParamBoolean rhopse, ParamBoolean sporadic, ParamBoolean keephouse,ParamBoolean house, File outDir,int i){
		String command = "solar";
		
		//Build the command
		command+=" load pedigree "+pedigree.getValue(i)+" ;";
		command+=" load phenotypes "+phenotypes.getValue(i)+" ;";
		command+=" model new ;";
		command+=" trait "+readFileToString(trait.getValue(i))+" ;";
		command+=" covar "+readFileToString(covariates.getValue(i))+" ;";
		//Comes before polygenic
		if (house.getValue()){
			command+=" house;";
		}
		command+=" outdir "+outDir.getAbsolutePath()+" ;";
		command+=" polygenic";
		//These are all optional arguments
		File thisFix = fix.getValue(i);
		if (thisFix != null){
			String theseFix = readFileToString(thisFix);
			String[] parts = theseFix.split(" ");
			for(String el:parts){
				command+=" -f "+el+" ;";
			}				
		}
		if (all.getValue() && thisFix!=null){
			command+=" -all";
		}
		File thisCovar = testcovar.getValue(i);
		if (thisCovar !=null){
			String theseCovar = readFileToString(thisCovar);
			command+=" -testcovar "+theseCovar;
		}
		if (testrhoe.getValue()){
			command+=" -testrhoe";
		}
		if (prob.getValue() != null){
			command+=" -prob "+prob.getValue();
		}
		if (testrhog.getValue()){
			command+=" -testrhog";
		}
		if (testrhoc.getValue()){
			command+=" -testrhoc";
		}
		if (testrhop.getValue()){
			command+=" -testrhop";
		}
		if (rhopse.getValue()){
			command+=" -rhopse";
		}
		if (sporadic.getValue()){
			command+=" -sporadic";
		}
		if (screen.getValue()){
			command+=" -screen";
		}
		return command;
		
	}
	
	//Reads a line from the text file
    protected static String	readFileToString(File temp){
    	String output = "";
    	try {
			BufferedReader reader = new BufferedReader(new FileReader(temp));
			output = reader.readLine();
			reader.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
    	return output;
    }
}
