package edu.vanderbilt.masi.plugins.classification;

import java.io.File;
import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import edu.vanderbilt.masi.algorithms.clasisfication.decisiontree.DecisionTreeClassifier;
import edu.vanderbilt.masi.algorithms.clasisfication.decisiontree.SplitCriterion;

public class DecisionTreePlugin extends LearnerPlugin {

	// Input Parameters
	public ParamOption split_criterion;
	public ParamInteger max_depth;
	public ParamInteger min_split;
	public ParamInteger min_leaf;

	// Output Parameters

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Sets up the framework to build a decision tree";
	private static final String longDescription = "";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.ALPHA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Classification");
		inputParams.setLabel("Decision Tree");
		inputParams.setName("Decision_Tree");
		ArrayList<String> options = new ArrayList<String>();
		options.add("Entropy");
		options.add("Gini");
		options.add("Random");
		inputParams.add(split_criterion = new ParamOption("Split Criterion",options));
		split_criterion.setMandatory(false);
		split_criterion.setValue("Entropy");

		inputParams.add(max_depth = new ParamInteger("Maximum Tree Depth"));
		max_depth.setMandatory(false);
		max_depth.setValue(10);

		inputParams.add(min_split = new ParamInteger("Minimum Number of Elements to Split a Node"));
		min_split.setMandatory(false);
		min_split.setValue(25);

		inputParams.add(min_leaf = new ParamInteger("Minimum Number of Elements to Have in a Leaf"));
		min_leaf.setMandatory(false);
		min_leaf.setValue(10);


	}

	

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		ExecuteWrapper wrapper=new ExecuteWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);


	}

	protected class ExecuteWrapper extends AbstractCalculation {
		protected void execute(ProcessingAlgorithm alg)
				throws AlgorithmRuntimeException {
			DecisionTreeClassifier DTC = new DecisionTreeClassifier();
			DTC.setMaxDepth(max_depth.getInt());
			DTC.setMinLeaf(min_leaf.getInt());
			DTC.setMinSplit(min_split.getInt());
			String split = split_criterion.getValue();
			if(split.equals("Entropy")) DTC.setSplitCriterion(SplitCriterion.ENTROPY);
			else if(split.equals("Gini")) DTC.setSplitCriterion(SplitCriterion.GINI);
			else DTC.setSplitCriterion(SplitCriterion.RANDOM);
			File outdir = new File(
					alg.getOutputDirectory() +
					File.separator +
					FileUtil.forceSafeFilename(alg.getAlgorithmName()) +
					File.separator);
			outdir.mkdirs();
			File f = new File(outdir, "classifier.json");
			DTC.writeToFile(f);
			classifiers.setValue(f);
		}
	}



}
