package edu.vanderbilt.masi.plugins.classification;

import java.io.File;
import java.io.FileNotFoundException;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import edu.vanderbilt.masi.algorithms.clasisfication.ClassificationRunner;
import edu.vanderbilt.masi.algorithms.clasisfication.ErrorClassificationRunner;
import edu.vanderbilt.masi.plugins.classification.ClassifierPlugin.ExecuteWrapper;

public class ErrorClassificationTesterPlugin extends ProcessingAlgorithm {
	
	public ParamFileCollection input_classifiers;
	public ParamFile input_features;
	public ParamVolume host_labels;
	public ParamVolume manual_labels;
	public ParamBoolean ignore_background;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Tests Classifier";
	private static final String longDescription = "";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Classification");
		inputParams.setLabel("Test Classifier");
		inputParams.setName("Test_Classifier");
		
		inputParams.add(this.input_classifiers = new ParamFileCollection("Classifier"));
		this.input_classifiers.setMandatory(true);
		
		inputParams.add(this.input_features = new ParamFile("Image Features"));
		this.input_features.setMandatory(true);
		
		inputParams.add(this.host_labels = new ParamVolume("Host Labels"));
		this.host_labels.setMandatory(true);
		
		inputParams.add(this.manual_labels = new ParamVolume("Manual Labels"));
		this.manual_labels.setMandatory(true);
		
		inputParams.add(this.ignore_background = new ParamBoolean("Ignore Background?"));
		this.ignore_background.setMandatory(false);
		this.ignore_background.setValue(true);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		try {
			ExecuteWrapper wrapper=new ExecuteWrapper();
			monitor.observe(wrapper);
			wrapper.execute(this);

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	protected class ExecuteWrapper extends AbstractCalculation {
		public void execute(ProcessingAlgorithm alg) throws FileNotFoundException{
			ErrorClassificationRunner ECR = new ErrorClassificationRunner(input_classifiers.getValue(),input_features.getValue(),host_labels.getImageData(),manual_labels.getImageData(),ignore_background.getValue());
			
		}
	}

}
