package edu.vanderbilt.masi.plugins.classification;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.vanderbilt.masi.algorithms.clasisfication.ImageMasker;

public class ImageMaskerPlugin extends ProcessingAlgorithm {

	// Input Parameters
	public ParamInteger mask_dilation;
	public ParamVolumeCollection labels;

	// Output Parameters
	public ParamVolumeCollection mask;


	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Creates an image mask";
	private static final String longDescription = "";

	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Feature Calculation");
		inputParams.setLabel("Create Mask");
		inputParams.setName("Create_Mask");

		inputParams.add(labels=new ParamVolumeCollection("Estimated Labels"));
		labels.setLoadAndSaveOnValidate(false);
		labels.setMandatory(true);

		inputParams.add(mask_dilation = new ParamInteger("Mask Dilation Distance"));
		mask_dilation.setLoadAndSaveOnValidate(false);
		mask_dilation.setMandatory(false);
		mask_dilation.setValue(10);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(mask = new ParamVolumeCollection("Image Mask"));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {

		for(int l=0;l<this.labels.size();l++){
			ImageMasker IM = new ImageMasker(this.labels.getParamVolume(l).getImageData(),this.mask_dilation.getInt());

			boolean[][][] mask = IM.getMask();
			ImageData mask_im = this.labels.getParamVolume(l).getImageData();
			for(int i=0;i<mask.length;i++){
				for(int j=0;j<mask[0].length;j++){
					for(int k=0;k<mask[0][0].length;k++){
						mask_im.set(i, j, k,mask[i][j][k]);
					}
				}
			}

			this.mask.add(mask_im);
		}
	}



}
