package edu.vanderbilt.masi.plugins.labelfusion;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.*;
import edu.vanderbilt.masi.algorithms.labelfusion.LabelSetGenericIdealSTAPLE;

public class PluginLabelSetGenericIdealSTAPLE extends ProcessingAlgorithm {
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Determines the Ideal Confusion Matrices for a set of input volumes and a truth  volume.";
	private static final String longDescription = "";
	
	//input parameters
	public ParamVolume truth;
	public ParamVolumeCollection raters;
	
	//output parameters
	public ParamVolume theta;
	public ParamVolume segmentation;
	

	@Override
	protected void createInputParameters(ParamCollection arg0) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.BETA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("Label_Set_Generic_Ideal_STAPLE");
		inputParams.setLabel("Label Set Generic Ideal STAPLE");

		inputParams.add(truth = new ParamVolume("Truth"));
		truth.setMandatory(true);
		
		inputParams.add(raters = new ParamVolumeCollection("Observed Rater Volumes"));
		raters.setMandatory(true);
	}

	@Override
	protected void createOutputParameters(ParamCollection arg0) {
		outputParams.add(segmentation = new ParamVolume("Segmentation"));
		outputParams.add(theta = new ParamVolume("Theta"));
	}

	@Override
	protected void execute(CalculationMonitor arg0)
			throws AlgorithmRuntimeException {
		LabelSetGenericIdealSTAPLE sf = new LabelSetGenericIdealSTAPLE(raters.getImageDataList(),truth.getImageData());
		segmentation.setValue(sf.getEstimate());
		theta.setValue(sf.getThetaImage());

	}

}
