package edu.vanderbilt.masi.plugins.labelfusion;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.vanderbilt.masi.algorithms.labelfusion.MultiSetNonLocalSpatialSTAPLE;

public class PluginMultiSetNonLocalSpatialSTAPLE extends ProcessingAlgorithm{

	private static final String cvsversion = "$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Runs the Non-Local Spatial STAPLE Label Fusion Algorithm on a Generic set of labels with a target.";
	private static final String longDescription = "";
	
	//Main Input Parameters
	public transient ParamVolume targetImage;
	public transient ParamVolumeCollection regIms;
	public transient ParamVolumeCollection regLabs;
	public ParamFile raterMap;
	public ParamString targetClass;
	public ParamFloat consThresh;
	public ParamFile thetaFile;
	
	//Weighting Input Parameters
	public ParamInteger searchVolume;
	public ParamInteger patchVolume;
	public ParamFloat   searchWeight;
	public ParamFloat   corrWeight;
	public ParamFloat   selectThresh;
	public ParamInteger patchCount;
	
	
	//Output Parameters
	public transient ParamVolume labels;
	public transient ParamVolume labelProbabilities;
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.BETA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("MSNLSSTAPLE");
		inputParams.setLabel("Multi-Set Non-Local Spatial STAPLE");
		
		// Required and major STAPLE parameters
		ParamCollection main = new ParamCollection("Main");
		main.add(targetImage = new ParamVolume("Target Image"));
		targetImage.setMandatory(true);
		main.add(regIms = new ParamVolumeCollection("Registered Atlas Images"));
		regIms.setMandatory(true);
		main.add(regLabs = new ParamVolumeCollection("Registered Atlas Labels"));
		regLabs.setMandatory(true);
		main.add(raterMap = new ParamFile("Rater Map"));
		raterMap.setMandatory(true);
		main.add(targetClass = new ParamString("Target Class"));
		targetClass.setMandatory(true);
		main.add(thetaFile = new ParamFile("Initial Theta File"));
		thetaFile.setMandatory(true);
		main.add(consThresh = new ParamFloat("Consensus Threshold"));
		consThresh.setMandatory(false);
		consThresh.setValue(0.99f);
		
		inputParams.add(main);
		
		// NL-Correspondence Parameters
		ParamCollection weighting       = new ParamCollection("Weighting Parameters");
		ParamCollection correspondence  = new ParamCollection("Correspondence Parameters");
		ParamCollection patch           = new ParamCollection("Patch Selection");
		correspondence.add(searchVolume = new ParamInteger("Search Volume (Image Units)"));
		correspondence.add(patchVolume  = new ParamInteger("Patch Volume (Image Units)"));
		correspondence.add(corrWeight   = new ParamFloat("STD for Correlation metric (1/std)"));
		correspondence.add(searchWeight = new ParamFloat("Search Volume STD"));
		searchVolume.setMandatory(false);
		searchVolume.setValue(3);
		patchVolume.setMandatory(false);
		patchVolume.setValue(2);
		corrWeight.setMandatory(false);
		corrWeight.setValue(.5f);
		searchWeight.setMandatory(false);
		searchWeight.setValue(1.5f);
		patch.add(selectThresh = new ParamFloat("Local Selection Threshold"));
		patch.add(patchCount = new ParamInteger("Number of Patches to Keep"));
		selectThresh.setMandatory(false);
		selectThresh.setValue(0.05f);
		patchCount.setMandatory(false);
		patchCount.setValue(-1);
		weighting.add(correspondence);
		weighting.add(patch);
		
		inputParams.add(weighting);
		
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(labels = new ParamVolume("Labels"));
		outputParams.add(labelProbabilities = new ParamVolume("Label_Probabilities"));
		labelProbabilities.setMandatory(false);
		
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		int weight_type = 1;
		int sel_type = 1;
		int probability_index = -1;
		boolean use_intensity_normalization = true;
		MultiSetNonLocalSpatialSTAPLE sf = new MultiSetNonLocalSpatialSTAPLE(targetImage,regIms,regLabs,weight_type,searchVolume.getInt(),
				patchVolume.getInt(),searchWeight.getFloat(),corrWeight.getFloat(),sel_type,selectThresh.getFloat(),patchCount.getInt(),
				consThresh.getFloat(),probability_index, use_intensity_normalization,targetClass.getValue(),raterMap.getValue(),thetaFile.getValue());
		labels.setValue(sf.getSegmentation());
	}

}
