package edu.vanderbilt.masi.plugins.labelfusion;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.vanderbilt.masi.algorithms.labelfusion.HierarchyMapper;

public class PluginSingleHierarchyMapper extends ProcessingAlgorithm {
	
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Maps an input label volume to a particular level of the hierarchy";
	private static final String longDescription = "";
	
	//Input Parameters
	ParamVolume inputVolume;
	ParamFile hierarchy;
	ParamInteger level;

	//Output Parameters
	ParamVolume mappedLabels;
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.ALPHA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Hierarchy_Tools");
		inputParams.setName("Single_Hierarchy_Mapper");
		inputParams.setLabel("Single Hierarchy Mapper");
		
		inputParams.add(inputVolume = new ParamVolume("Input Labels"));
		inputVolume.setMandatory(true);
		
		inputParams.add(hierarchy = new ParamFile("Hierarchy Text File"));
		hierarchy.setMandatory(true);
		
		inputParams.add(level = new ParamInteger("Hierarchy Level"));
		level.setMandatory(true);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(mappedLabels = new ParamVolume("Mapped Labels"));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {

		HierarchyMapper HM = new HierarchyMapper(hierarchy.getValue(),level.getInt());
		mappedLabels.setValue(HM.map(inputVolume.getImageData()));
		
	}

}
