/*

@Copyright (c) 2007-2008 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in all
copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

						PT_COPYRIGHT_VERSION_2
						COPYRIGHTENDKEY



 */

package ptolemy.actor.gt.util;

import java.util.Set;

import ptolemy.data.Token;
import ptolemy.data.expr.ModelScope;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.Type;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

/**

 @author Thomas Huining Feng
 @version $Id: VariableScope.java,v 1.2.4.1 2008/03/25 22:12:16 cxh Exp $
 @since Ptolemy II 6.1
 @Pt.ProposedRating Red (tfeng)
 @Pt.AcceptedRating Red (tfeng)
 */
public class VariableScope extends ModelScope {

    public VariableScope(NamedObj container) {
        _container = container;
    }

    public Token get(String name) throws IllegalActionException {
        Variable result = getScopedVariable(null, _container, name);

        if (result != null) {
            return result.getToken();
        } else {
            return null;
        }
    }

    public Type getType(String name) throws IllegalActionException {
        Variable result = getScopedVariable(null, _container, name);

        if (result != null) {
            return result.getType();
        } else {
            return null;
        }
    }

    public InequalityTerm getTypeTerm(String name)
            throws IllegalActionException {
        Variable result = getScopedVariable(null, _container, name);

        if (result != null) {
            return result.getTypeTerm();
        } else {
            return null;
        }
    }

    public Set<?> identifierSet() {
        return getAllScopedVariableNames(null, _container);
    }

    private NamedObj _container;

}
