/* Key/Value Pair

 Copyright (c) 2006-2007 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */

package ptolemy.actor.ptalon.lib;

//////////////////////////////////////////////////////////////////////////
////KeyValuePair

/**
 A pair of Strings, one a key, and one a value.

 @author Adam Cataldo
 @version $Id: KeyValuePair.java,v 1.2 2007/03/15 15:45:14 cxh Exp $
 @since Ptolemy II 6.1
 @Pt.ProposedRating Red (cxh)
 @Pt.AcceptedRating Red (cxh)
 */

public class KeyValuePair {
    /**
     * Create a new KeyValuePair with the given key
     * and value.
     * @param key The key.
     * @param value The value.
     */
    public KeyValuePair(String key, String value) {
        _key = key;
        _value = value;
    }

    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** The key of this KeyValuePair.
     * @return The key of this KeyValuePair.
     */
    public String getKey() {
        return _key;
    }

    /** The value of this KeyValuePair.
     * @return The value of this KeyValuePair.
     */
    public String getValue() {
        return _value;
    }

    ///////////////////////////////////////////////////////////////////
    ////                        private members                    ////

    /** The key. */
    private String _key;

    /** The value. */
    private String _value;
}
