/* A method is duplicated in a class declaration.

 Copyright (c) 2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.backtrack.eclipse.ast.transform;

import ptolemy.backtrack.eclipse.ast.ASTRuntimeException;

//////////////////////////////////////////////////////////////////////////
//// ASTDuplicatedMethodException

/**
 Thrown on an attempt to create a method in a class declaration, which
 already contains a method with the same name and an argument of the
 same type.

 @author Thomas Feng
 @version $Id: ASTDuplicatedMethodException.java,v 1.1 2006/04/12 22:54:49 tfeng Exp $
 @since Ptolemy II 5.1
 @Pt.ProposedRating Red (tfeng)
 @Pt.AcceptedRating Red (tfeng)
 */
public class ASTDuplicatedMethodException extends ASTRuntimeException {
    /** Construct an exception about creating a duplicated method in a class.
     *
     *  @param className The class name.
     *  @param methodName The method name.
     */
    public ASTDuplicatedMethodException(String className, String methodName) {
        super("Trying to create a duplicated method \"" + methodName
                + "\" in class \"" + className + "\".");
    }
}
