/*
PCCG run-time library.

Copyright (c) 2001-2005 The University of Maryland.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF MARYLAND BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
THE UNIVERSITY OF MARYLAND HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

THE UNIVERSITY OF MARYLAND SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
MARYLAND HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

@ProposedRating Red (ssb@eng.umd.edu)
@AcceptedRating Red (ssb@eng.umd.edu)

@author Shuvra S. Bhattacharyya
@version $Id: pccg_runtime.c,v 1.8 2005/02/28 20:12:38 cxh Exp $
*/

#include "pccg.h"
#include "pccg_runtime.h"
#include <stdlib.h>

#ifdef GC
#include "include/gc.h"
#define malloc(x) GC_MALLOC(x)
#endif

/* Data to enable exception-catching */
jmp_buf env;
int epc;
_EXCEPTION_INSTANCE exception_id;

void* PCCG_malloc(size_t size) {
    void* block;
    /* Allocate memory. */
    block = malloc(size);

    #ifdef sun
        /* Zero out allocated memory */
        memset(block, 0, size);
    #endif

    return block;
}
