/* Utilities for building 2D actors.

 Copyright (c) 2003-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.domains.gr.kernel;

import java.awt.Color;

import ptolemy.data.DoubleMatrixToken;

//////////////////////////////////////////////////////////////////////////
//// Utilities2D

/**
 Utilities that are useful for building 2D GR actors.

 @author Steve Neuendorffer
 @version $Id: GRUtilities2D.java,v 1.15 2005/12/30 03:30:52 cxh Exp $
 @since Ptolemy II 4.0
 @Pt.ProposedRating yellow (chf)
 @Pt.AcceptedRating yellow (vogel)
 */
public class GRUtilities2D {
    /** Given a 1x3 DoubleMatrixToken, return the corresponding
     *  java.awt.Color object.
     *  @param colorVector A 1x3 DoubleMatrixToken of where the
     *  first element is the red value, the second is the green
     *  value and the third is the blue value.
     *  @return The corresponding color.
     */
    public static Color makeColor(DoubleMatrixToken colorVector) {
        Color color = new Color((float) colorVector.getElementAt(0, 0),
                (float) colorVector.getElementAt(0, 1), (float) colorVector
                        .getElementAt(0, 2));
        return color;
    }
}
