/* Class defining a large matrix containing real antenna data.

 Copyright (c) 1999-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.domains.pn.demo.QR;

//////////////////////////////////////////////////////////////////////////
//// Source Matrix

/**

 This class defines a large matrix containing 500 real measured data
 from an array of 16 antenna's. This matrix is used by the QR demo.
 Defining the Matrix in this way makes loading the matrix fast and
 allows for flexible interaction, as required by the QR demo that is
 parameterized.

 @author Bart Kienhuis
 @version $Id: SourceMatrix.java,v 1.25 2005/07/08 19:58:34 cxh Exp $
 @since Ptolemy II 0.4
 @Pt.ProposedRating Red (kienhuis)
 @Pt.AcceptedRating Red (kienhuis)
 */
public class SourceMatrix {
    ///////////////////////////////////////////////////////////////////
    ////                         public variable                   ////
    public static final double[][] sourcematrix_0 = {
            { -100.0, -62.0, 2.0, 45.0, 35.0, 14.0, -8.0, -20.0, 8.0, 59.0,
                    105.0, 120.0, 90.0, 50.0, -19.0, -40.0 },
            { 86.0, 19.0, -22.0, -63.0, -62.0, -15.0, 13.0, -2.0, -29.0, -83.0,
                    -111.0, -104.0, -53.0, -4.0, 36.0, 53.0 },
            { -56.0, 23.0, 55.0, 80.0, 62.0, 7.0, 8.0, 15.0, 59.0, 96.0, 102.0,
                    67.0, 29.0, -46.0, -83.0, -80.0 },
            { -6.0, -66.0, -95.0, -82.0, -54.0, -12.0, -11.0, -21.0, -57.0,
                    -80.0, -76.0, -38.0, 18.0, 64.0, 97.0, 79.0 },
            { 48.0, 96.0, 92.0, 75.0, 25.0, -4.0, 6.0, 23.0, 61.0, 66.0, 39.0,
                    -13.0, -75.0, -87.0, -88.0, -47.0 },
            { -77.0, -117.0, -91.0, -60.0, -21.0, -1.0, -4.0, -40.0, -50.0,
                    -57.0, -19.0, 59.0, 87.0, 116.0, 89.0, 46.0 },
            { 96.0, 113.0, 70.0, 31.0, -5.0, -12.0, -3.0, 38.0, 37.0, 13.0,
                    -40.0, -89.0, -119.0, -91.0, -51.0, -1.0 },
            { -107.0, -107.0, -48.0, 2.0, 33.0, 26.0, -2.0, -21.0, -17.0, 14.0,
                    72.0, 102.0, 102.0, 87.0, 25.0, -22.0 },
            { 117.0, 74.0, 8.0, -22.0, -41.0, -16.0, 9.0, 28.0, -4.0, -34.0,
                    -100.0, -107.0, -88.0, -38.0, -1.0, 47.0 },
            { -101.0, -43.0, 32.0, 51.0, 61.0, 15.0, -15.0, -1.0, 29.0, 62.0,
                    112.0, 105.0, 77.0, 17.0, -37.0, -66.0 },
            { 49.0, 4.0, -47.0, -74.0, -63.0, -10.0, 13.0, 0.0, -42.0, -95.0,
                    -109.0, -70.0, -17.0, 21.0, 59.0, 62.0 },
            { -11.0, 53.0, 94.0, 72.0, 47.0, 3.0, 1.0, 13.0, 63.0, 97.0, 80.0,
                    39.0, -6.0, -68.0, -95.0, -75.0 },
            { -22.0, -93.0, -101.0, -67.0, -34.0, -12.0, -3.0, -25.0, -68.0,
                    -82.0, -64.0, 6.0, 64.0, 100.0, 97.0, 57.0 },
            { 71.0, 99.0, 92.0, 60.0, 24.0, -16.0, 0.0, 30.0, 63.0, 67.0, 18.0,
                    -48.0, -79.0, -101.0, -87.0, -33.0 },
            { -97.0, -104.0, -94.0, -34.0, -5.0, 7.0, 1.0, -34.0, -42.0, -27.0,
                    28.0, 85.0, 99.0, 106.0, 59.0, 26.0 },
            { 108.0, 94.0, 63.0, -5.0, -35.0, -29.0, 18.0, 36.0, 24.0, 4.0,
                    -69.0, -92.0, -123.0, -75.0, -41.0, 1.0 },
            { -105.0, -90.0, -18.0, 24.0, 39.0, 18.0, -3.0, -23.0, -16.0, 43.0,
                    86.0, 108.0, 110.0, 47.0, -9.0, -46.0 },
            { 105.0, 51.0, -5.0, -61.0, -42.0, -20.0, 8.0, 0.0, -28.0, -67.0,
                    -110.0, -97.0, -64.0, -18.0, 30.0, 60.0 },
            { -72.0, 5.0, 58.0, 67.0, 44.0, 9.0, -3.0, 4.0, 36.0, 93.0, 93.0,
                    76.0, 40.0, -31.0, -53.0, -77.0 },
            { 30.0, -51.0, -80.0, -75.0, -58.0, -14.0, -10.0, -25.0, -62.0,
                    -84.0, -89.0, -55.0, 15.0, 54.0, 86.0, 60.0 },
            { 33.0, 80.0, 106.0, 81.0, 36.0, -5.0, 10.0, 40.0, 76.0, 79.0,
                    70.0, 2.0, -46.0, -99.0, -82.0, -66.0 },
            { -72.0, -109.0, -104.0, -71.0, -22.0, 12.0, 4.0, -38.0, -54.0,
                    -71.0, -29.0, 28.0, 74.0, 95.0, 86.0, 55.0 },
            { 101.0, 124.0, 80.0, 33.0, -10.0, -14.0, 0.0, 47.0, 54.0, 42.0,
                    -20.0, -82.0, -117.0, -109.0, -76.0, -12.0 },
            { -105.0, -100.0, -73.0, -4.0, 29.0, 25.0, -16.0, -25.0, -24.0,
                    -1.0, 57.0, 105.0, 111.0, 86.0, 36.0, -7.0 },
            { 123.0, 74.0, 39.0, -26.0, -47.0, -13.0, 17.0, 32.0, 1.0, -29.0,
                    -82.0, -102.0, -102.0, -67.0, -15.0, 33.0 },
            { -97.0, -40.0, 11.0, 58.0, 45.0, 15.0, -16.0, -22.0, 7.0, 59.0,
                    90.0, 110.0, 73.0, 13.0, -32.0, -47.0 },
            { 72.0, 9.0, -36.0, -67.0, -50.0, -29.0, -7.0, -3.0, -48.0, -73.0,
                    -104.0, -80.0, -50.0, 23.0, 57.0, 63.0 },
            { -36.0, 31.0, 83.0, 69.0, 58.0, 5.0, -8.0, 27.0, 65.0, 98.0, 86.0,
                    64.0, -3.0, -61.0, -91.0, -70.0 },
            { -19.0, -65.0, -85.0, -67.0, -39.0, 2.0, -11.0, -33.0, -74.0,
                    -86.0, -56.0, -9.0, 36.0, 76.0, 83.0, 72.0 },
            { 64.0, 97.0, 90.0, 73.0, 31.0, 6.0, 5.0, 44.0, 74.0, 70.0, 24.0,
                    -37.0, -71.0, -96.0, -80.0, -47.0 },
            { -84.0, -113.0, -98.0, -32.0, -10.0, 16.0, 0.0, -48.0, -45.0,
                    -28.0, 1.0, 62.0, 110.0, 99.0, 78.0, 14.0 },
            { 114.0, 99.0, 67.0, 5.0, -30.0, -12.0, 0.0, 30.0, 27.0, 4.0,
                    -47.0, -106.0, -112.0, -82.0, -37.0, 13.0 },
            { -126.0, -82.0, -43.0, 18.0, 36.0, 21.0, -13.0, -16.0, -9.0, 37.0,
                    70.0, 111.0, 113.0, 75.0, 15.0, -32.0 },
            { 111.0, 58.0, -16.0, -36.0, -40.0, -13.0, -3.0, 10.0, -15.0,
                    -65.0, -108.0, -101.0, -87.0, -38.0, 29.0, 59.0 },
            { -82.0, -22.0, 45.0, 57.0, 43.0, 22.0, -14.0, 11.0, 46.0, 86.0,
                    106.0, 85.0, 53.0, -8.0, -67.0, -61.0 },
            { 22.0, -42.0, -83.0, -68.0, -40.0, -12.0, 11.0, -8.0, -49.0,
                    -80.0, -92.0, -69.0, -13.0, 62.0, 89.0, 68.0 },
            { 20.0, 66.0, 101.0, 86.0, 45.0, 3.0, -8.0, 26.0, 73.0, 84.0, 78.0,
                    11.0, -32.0, -83.0, -101.0, -57.0 },
            { -68.0, -107.0, -92.0, -55.0, -32.0, 1.0, -15.0, -27.0, -57.0,
                    -76.0, -25.0, 27.0, 87.0, 93.0, 87.0, 41.0 },
            { 96.0, 120.0, 85.0, 38.0, 5.0, -5.0, 8.0, 40.0, 55.0, 45.0, 2.0,
                    -64.0, -102.0, -106.0, -68.0, -36.0 },
            { -118.0, -108.0, -57.0, -17.0, 9.0, 13.0, -14.0, -42.0, -29.0,
                    2.0, 39.0, 97.0, 104.0, 102.0, 52.0, -11.0 },
            { 122.0, 96.0, 28.0, -26.0, -36.0, -19.0, 18.0, 32.0, 12.0, -18.0,
                    -89.0, -118.0, -116.0, -66.0, -13.0, 25.0 },
            { -93.0, -65.0, 9.0, 40.0, 42.0, 33.0, 3.0, -8.0, 8.0, 57.0, 96.0,
                    103.0, 84.0, 24.0, -21.0, -58.0 },
            { 69.0, 16.0, -33.0, -73.0, -42.0, -27.0, 3.0, 7.0, -43.0, -88.0,
                    -100.0, -91.0, -50.0, 1.0, 65.0, 76.0 },
            { -40.0, 38.0, 70.0, 69.0, 60.0, 13.0, -10.0, 18.0, 49.0, 98.0,
                    84.0, 57.0, 5.0, -47.0, -89.0, -66.0 },
            { -9.0, -61.0, -99.0, -88.0, -40.0, -13.0, -7.0, -38.0, -64.0,
                    -78.0, -78.0, -11.0, 49.0, 84.0, 94.0, 60.0 },
            { 47.0, 91.0, 92.0, 75.0, 30.0, 8.0, 16.0, 44.0, 67.0, 59.0, 27.0,
                    -15.0, -70.0, -100.0, -95.0, -59.0 },
            { -95.0, -119.0, -80.0, -33.0, 0.0, 1.0, -11.0, -44.0, -49.0,
                    -30.0, 6.0, 67.0, 103.0, 113.0, 71.0, 36.0 },
            { 104.0, 98.0, 65.0, 11.0, -19.0, -28.0, 19.0, 43.0, 42.0, 7.0,
                    -37.0, -105.0, -122.0, -104.0, -41.0, -10.0 },
            { -120.0, -78.0, -32.0, 15.0, 42.0, 12.0, -19.0, -17.0, -24.0,
                    26.0, 69.0, 118.0, 110.0, 71.0, 24.0, -23.0 },
            { 106.0, 49.0, -12.0, -52.0, -37.0, -12.0, 3.0, 14.0, -6.0, -54.0,
                    -97.0, -120.0, -91.0, -26.0, 19.0, 54.0 },
            { -68.0, -12.0, 37.0, 56.0, 62.0, 19.0, 5.0, 11.0, 42.0, 72.0,
                    98.0, 103.0, 38.0, -4.0, -65.0, -70.0 },
            { 26.0, -41.0, -73.0, -86.0, -56.0, -17.0, -9.0, -7.0, -57.0,
                    -95.0, -84.0, -66.0, 1.0, 57.0, 69.0, 73.0 },
            { 12.0, 61.0, 100.0, 68.0, 28.0, -4.0, 4.0, 39.0, 57.0, 77.0, 58.0,
                    21.0, -32.0, -73.0, -92.0, -65.0 },
            { -70.0, -94.0, -107.0, -67.0, -11.0, -4.0, -16.0, -47.0, -75.0,
                    -77.0, -26.0, 28.0, 83.0, 96.0, 92.0, 59.0 },
            { 100.0, 102.0, 97.0, 50.0, 6.0, -21.0, 16.0, 50.0, 46.0, 47.0,
                    -13.0, -75.0, -95.0, -115.0, -83.0, -37.0 },
            { -118.0, -118.0, -60.0, -21.0, 21.0, 21.0, -2.0, -28.0, -38.0,
                    -9.0, 55.0, 101.0, 103.0, 86.0, 39.0, -3.0 },
            { 109.0, 92.0, 35.0, -18.0, -30.0, -30.0, 15.0, 24.0, 23.0, -19.0,
                    -71.0, -122.0, -95.0, -55.0, -9.0, 18.0 },
            { -94.0, -48.0, 17.0, 52.0, 45.0, 31.0, -1.0, -8.0, 4.0, 67.0,
                    94.0, 101.0, 73.0, 20.0, -18.0, -55.0 },
            { 75.0, 15.0, -35.0, -72.0, -60.0, -29.0, -6.0, 8.0, -47.0, -84.0,
                    -106.0, -100.0, -50.0, 10.0, 60.0, 74.0 },
            { -35.0, 28.0, 72.0, 78.0, 48.0, 10.0, -2.0, 25.0, 53.0, 96.0,
                    97.0, 68.0, 6.0, -62.0, -70.0, -75.0 },
            { -30.0, -84.0, -84.0, -77.0, -33.0, 5.0, 5.0, -28.0, -76.0, -93.0,
                    -59.0, -26.0, 34.0, 81.0, 81.0, 67.0 },
            { 72.0, 93.0, 99.0, 62.0, 27.0, -10.0, 10.0, 36.0, 64.0, 75.0,
                    39.0, -30.0, -73.0, -93.0, -83.0, -38.0 },
            { -93.0, -104.0, -90.0, -49.0, 3.0, 22.0, 2.0, -31.0, -51.0, -45.0,
                    20.0, 64.0, 95.0, 112.0, 64.0, 32.0 },
            { 109.0, 111.0, 59.0, 16.0, -15.0, -28.0, 18.0, 27.0, 43.0, -9.0,
                    -62.0, -94.0, -123.0, -81.0, -52.0, -1.0 },
            { -111.0, -91.0, -18.0, 26.0, 31.0, 12.0, 0.0, -24.0, -10.0, 25.0,
                    78.0, 104.0, 97.0, 64.0, 17.0, -29.0 },
            { 92.0, 37.0, -7.0, -59.0, -55.0, -21.0, 5.0, 1.0, -10.0, -56.0,
                    -91.0, -118.0, -82.0, -34.0, 18.0, 44.0 },
            { -69.0, -4.0, 47.0, 63.0, 51.0, 11.0, -13.0, 9.0, 49.0, 74.0,
                    105.0, 82.0, 29.0, -20.0, -56.0, -77.0 },
            { 18.0, -39.0, -72.0, -87.0, -39.0, -1.0, 9.0, -9.0, -50.0, -79.0,
                    -92.0, -56.0, 15.0, 66.0, 87.0, 79.0 },
            { 21.0, 71.0, 103.0, 64.0, 38.0, 6.0, 13.0, 23.0, 67.0, 91.0, 63.0,
                    18.0, -41.0, -98.0, -102.0, -56.0 },
            { -79.0, -94.0, -97.0, -50.0, -24.0, -4.0, -8.0, -49.0, -71.0,
                    -54.0, -33.0, 41.0, 94.0, 104.0, 81.0, 40.0 },
            { 99.0, 103.0, 79.0, 33.0, -14.0, -2.0, 17.0, 31.0, 47.0, 23.0,
                    -12.0, -68.0, -97.0, -107.0, -63.0, -11.0 },
            { -120.0, -113.0, -48.0, -8.0, 34.0, 12.0, -11.0, -45.0, -36.0,
                    6.0, 65.0, 95.0, 123.0, 88.0, 32.0, -16.0 },
            { 119.0, 80.0, 25.0, -33.0, -29.0, -29.0, 20.0, 14.0, 5.0, -28.0,
                    -90.0, -110.0, -93.0, -50.0, -11.0, 37.0 },
            { -102.0, -31.0, 24.0, 60.0, 54.0, 10.0, -18.0, 0.0, 11.0, 60.0,
                    95.0, 96.0, 76.0, 25.0, -38.0, -64.0 },
            { 50.0, 5.0, -61.0, -72.0, -44.0, -7.0, 8.0, -2.0, -38.0, -86.0,
                    -92.0, -81.0, -36.0, 16.0, 62.0, 78.0 },
            { -15.0, 48.0, 88.0, 80.0, 52.0, 0.0, 9.0, 29.0, 50.0, 84.0, 83.0,
                    40.0, -2.0, -62.0, -87.0, -76.0 },
            { -44.0, -81.0, -95.0, -64.0, -26.0, -12.0, -14.0, -44.0, -76.0,
                    -84.0, -48.0, -2.0, 46.0, 86.0, 81.0, 52.0 },
            { 66.0, 116.0, 94.0, 54.0, 3.0, -2.0, 16.0, 32.0, 61.0, 52.0, 26.0,
                    -51.0, -99.0, -97.0, -81.0, -52.0 },
            { -109.0, -120.0, -89.0, -29.0, 18.0, 3.0, -2.0, -33.0, -60.0,
                    -17.0, 35.0, 79.0, 118.0, 112.0, 53.0, 20.0 },
            { 110.0, 89.0, 49.0, -3.0, -36.0, -22.0, 9.0, 38.0, 34.0, -5.0,
                    -70.0, -97.0, -116.0, -76.0, -23.0, 22.0 },
            { -108.0, -62.0, -13.0, 37.0, 51.0, 31.0, -11.0, -20.0, -11.0,
                    37.0, 91.0, 117.0, 102.0, 60.0, -14.0, -41.0 },
            { 97.0, 25.0, -36.0, -63.0, -39.0, -19.0, 5.0, 9.0, -31.0, -73.0,
                    -103.0, -98.0, -56.0, -20.0, 36.0, 51.0 },
            { -59.0, 4.0, 52.0, 65.0, 54.0, 5.0, 5.0, 6.0, 40.0, 76.0, 103.0,
                    76.0, 33.0, -22.0, -64.0, -79.0 },
            { 11.0, -46.0, -83.0, -67.0, -49.0, -13.0, 8.0, -23.0, -59.0,
                    -89.0, -74.0, -29.0, 22.0, 64.0, 96.0, 58.0 },
            { 48.0, 82.0, 99.0, 66.0, 21.0, 6.0, 10.0, 26.0, 70.0, 85.0, 52.0,
                    -9.0, -69.0, -85.0, -90.0, -51.0 },
            { -72.0, -109.0, -93.0, -58.0, -4.0, 16.0, 2.0, -31.0, -68.0,
                    -54.0, -7.0, 59.0, 104.0, 96.0, 71.0, 37.0 },
            { 108.0, 120.0, 68.0, 14.0, -10.0, -8.0, 12.0, 49.0, 38.0, 14.0,
                    -24.0, -95.0, -120.0, -103.0, -68.0, -13.0 },
            { -118.0, -102.0, -42.0, 14.0, 23.0, 19.0, -1.0, -42.0, -15.0,
                    27.0, 59.0, 98.0, 113.0, 77.0, 26.0, -11.0 },
            { 115.0, 71.0, -2.0, -45.0, -45.0, -24.0, 15.0, 10.0, -8.0, -57.0,
                    -105.0, -122.0, -89.0, -51.0, 4.0, 48.0 },
            { -81.0, -29.0, 32.0, 52.0, 57.0, 20.0, 0.0, -10.0, 30.0, 85.0,
                    94.0, 89.0, 69.0, 1.0, -55.0, -52.0 },
            { 47.0, -19.0, -56.0, -84.0, -40.0, -20.0, 13.0, -23.0, -58.0,
                    -92.0, -92.0, -65.0, -17.0, 51.0, 81.0, 74.0 },
            { 16.0, 54.0, 90.0, 86.0, 48.0, 3.0, -8.0, 37.0, 56.0, 80.0, 68.0,
                    31.0, -39.0, -66.0, -79.0, -57.0 },
            { -43.0, -84.0, -108.0, -72.0, -29.0, -5.0, -12.0, -42.0, -57.0,
                    -74.0, -41.0, 4.0, 77.0, 105.0, 100.0, 58.0 },
            { 92.0, 119.0, 101.0, 49.0, -1.0, -17.0, 3.0, 32.0, 67.0, 41.0,
                    -10.0, -68.0, -94.0, -96.0, -72.0, -36.0 },
            { -115.0, -119.0, -76.0, -10.0, 25.0, 10.0, 0.0, -47.0, -51.0,
                    -22.0, 51.0, 96.0, 123.0, 86.0, 60.0, 11.0 },
            { 112.0, 80.0, 46.0, -19.0, -41.0, -9.0, 20.0, 32.0, 21.0, -13.0,
                    -84.0, -119.0, -110.0, -67.0, -28.0, 32.0 },
            { -106.0, -59.0, 12.0, 33.0, 44.0, 10.0, -4.0, -24.0, -1.0, 62.0,
                    108.0, 109.0, 88.0, 31.0, -21.0, -41.0 },
            { 64.0, 7.0, -44.0, -60.0, -61.0, -15.0, 9.0, -9.0, -25.0, -73.0,
                    -112.0, -87.0, -57.0, 4.0, 42.0, 66.0 },
            { -23.0, 40.0, 64.0, 66.0, 56.0, 3.0, 9.0, 11.0, 60.0, 94.0, 87.0,
                    60.0, 10.0, -53.0, -72.0, -65.0 },
            { -4.0, -80.0, -84.0, -67.0, -29.0, -16.0, 6.0, -21.0, -61.0,
                    -87.0, -78.0, -13.0, 42.0, 89.0, 96.0, 76.0 },
            { 50.0, 104.0, 109.0, 72.0, 11.0, 8.0, -2.0, 28.0, 65.0, 67.0,
                    26.0, -27.0, -66.0, -103.0, -82.0, -45.0 },
            { -103.0, -106.0, -92.0, -34.0, -9.0, 11.0, 1.0, -49.0, -59.0,
                    -29.0, 14.0, 61.0, 110.0, 108.0, 83.0, 32.0 },
            { 104.0, 112.0, 75.0, 22.0, -27.0, -8.0, 15.0, 34.0, 27.0, 5.0,
                    -39.0, -86.0, -120.0, -83.0, -38.0, -10.0 },
            { -122.0, -76.0, -22.0, 24.0, 46.0, 31.0, -9.0, -37.0, -3.0, 39.0,
                    74.0, 104.0, 115.0, 70.0, 22.0, -29.0 },
            { 90.0, 55.0, -17.0, -56.0, -40.0, -11.0, 14.0, 16.0, -4.0, -51.0,
                    -90.0, -120.0, -90.0, -34.0, 35.0, 46.0 },
            { -66.0, 0.0, 36.0, 67.0, 50.0, 28.0, 1.0, 1.0, 44.0, 74.0, 101.0,
                    99.0, 37.0, -23.0, -63.0, -70.0 },
            { 16.0, -30.0, -79.0, -67.0, -54.0, -19.0, 6.0, -10.0, -67.0,
                    -79.0, -99.0, -49.0, 0.0, 49.0, 77.0, 64.0 },
            { 23.0, 66.0, 102.0, 66.0, 41.0, 13.0, 8.0, 24.0, 76.0, 88.0, 74.0,
                    12.0, -35.0, -87.0, -101.0, -60.0 },
            { -75.0, -92.0, -94.0, -59.0, -28.0, 14.0, 4.0, -32.0, -55.0,
                    -70.0, -21.0, 28.0, 87.0, 114.0, 78.0, 37.0 },
            { 92.0, 120.0, 76.0, 45.0, 7.0, -5.0, 19.0, 48.0, 56.0, 30.0,
                    -18.0, -68.0, -98.0, -106.0, -63.0, -18.0 },
            { -113.0, -95.0, -52.0, -10.0, 29.0, 29.0, -18.0, -39.0, -40.0,
                    -9.0, 60.0, 91.0, 121.0, 98.0, 33.0, -2.0 },
            { 108.0, 74.0, 35.0, -16.0, -48.0, -11.0, 9.0, 17.0, 16.0, -44.0,
                    -93.0, -115.0, -101.0, -69.0, 4.0, 29.0 },
            { -94.0, -54.0, 15.0, 55.0, 58.0, 17.0, -12.0, -6.0, 25.0, 73.0,
                    102.0, 98.0, 81.0, 22.0, -37.0, -57.0 },
            { 58.0, -7.0, -48.0, -80.0, -44.0, -19.0, 7.0, 0.0, -34.0, -77.0,
                    -111.0, -82.0, -47.0, 26.0, 61.0, 60.0 },
            { -29.0, 34.0, 76.0, 68.0, 48.0, 18.0, -10.0, 19.0, 48.0, 87.0,
                    79.0, 50.0, -17.0, -50.0, -75.0, -78.0 },
            { -37.0, -87.0, -96.0, -76.0, -26.0, -14.0, 6.0, -40.0, -73.0,
                    -89.0, -65.0, -1.0, 54.0, 82.0, 82.0, 72.0 },
            { 73.0, 113.0, 88.0, 70.0, 8.0, -15.0, 14.0, 29.0, 72.0, 70.0,
                    14.0, -46.0, -89.0, -108.0, -90.0, -34.0 },
            { -91.0, -118.0, -89.0, -40.0, 12.0, 21.0, -6.0, -45.0, -61.0,
                    -34.0, 10.0, 73.0, 103.0, 98.0, 60.0, 16.0 },
            { 108.0, 114.0, 67.0, 1.0, -19.0, -27.0, 16.0, 43.0, 22.0, 6.0,
                    -50.0, -94.0, -115.0, -87.0, -33.0, 17.0 },
            { -104.0, -73.0, -31.0, 33.0, 51.0, 14.0, -18.0, -13.0, -13.0,
                    32.0, 97.0, 117.0, 109.0, 62.0, 1.0, -45.0 },
            { 85.0, 41.0, -28.0, -63.0, -59.0, -31.0, 15.0, 15.0, -22.0, -60.0,
                    -111.0, -105.0, -80.0, -6.0, 36.0, 64.0 },
            { -63.0, -5.0, 63.0, 62.0, 52.0, 9.0, 3.0, -3.0, 32.0, 78.0, 96.0,
                    93.0, 26.0, -17.0, -61.0, -68.0 },
            { 23.0, -56.0, -93.0, -80.0, -49.0, -1.0, -8.0, -26.0, -62.0,
                    -95.0, -92.0, -56.0, 6.0, 60.0, 91.0, 77.0 },
            { 41.0, 93.0, 89.0, 66.0, 23.0, 9.0, 8.0, 41.0, 62.0, 88.0, 62.0,
                    3.0, -45.0, -102.0, -94.0, -54.0 },
            { -71.0, -116.0, -95.0, -59.0, -25.0, -1.0, -13.0, -30.0, -54.0,
                    -63.0, -14.0, 42.0, 79.0, 107.0, 96.0, 46.0 },
            { 112.0, 106.0, 90.0, 28.0, -1.0, -12.0, 16.0, 31.0, 60.0, 23.0,
                    -29.0, -74.0, -99.0, -113.0, -57.0, -15.0 },
            { -107.0, -101.0, -47.0, -13.0, 23.0, 15.0, -2.0, -21.0, -39.0,
                    17.0, 50.0, 101.0, 111.0, 88.0, 45.0, -19.0 },
            { 116.0, 80.0, 27.0, -38.0, -52.0, -27.0, -4.0, 22.0, 14.0, -43.0,
                    -98.0, -115.0, -93.0, -64.0, -7.0, 27.0 },
            { -103.0, -47.0, 30.0, 61.0, 43.0, 34.0, -1.0, 1.0, 28.0, 75.0,
                    92.0, 115.0, 78.0, 9.0, -43.0, -64.0 },
            { 48.0, -4.0, -60.0, -63.0, -61.0, -29.0, -8.0, 3.0, -51.0, -78.0,
                    -111.0, -73.0, -37.0, 37.0, 74.0, 60.0 },
            { -12.0, 42.0, 94.0, 78.0, 39.0, 9.0, 4.0, 10.0, 47.0, 79.0, 80.0,
                    53.0, -16.0, -65.0, -94.0, -79.0 },
            { -38.0, -73.0, -98.0, -71.0, -25.0, -9.0, 8.0, -23.0, -55.0,
                    -88.0, -45.0, 5.0, 65.0, 88.0, 101.0, 55.0 },
            { 68.0, 97.0, 110.0, 69.0, 25.0, -4.0, -4.0, 44.0, 63.0, 67.0,
                    14.0, -31.0, -95.0, -116.0, -93.0, -53.0 },
            { -92.0, -121.0, -90.0, -39.0, 17.0, 23.0, 5.0, -40.0, -46.0,
                    -37.0, 17.0, 87.0, 120.0, 94.0, 72.0, 15.0 },
            { 115.0, 105.0, 47.0, -6.0, -37.0, -17.0, -5.0, 40.0, 18.0, 1.0,
                    -60.0, -113.0, -113.0, -94.0, -39.0, 1.0 },
            { -123.0, -86.0, -24.0, 33.0, 50.0, 17.0, -12.0, -10.0, -4.0, 49.0,
                    83.0, 107.0, 91.0, 58.0, 9.0, -29.0 },
            { 93.0, 49.0, -24.0, -51.0, -52.0, -19.0, -6.0, 7.0, -28.0, -72.0,
                    -106.0, -112.0, -76.0, -9.0, 34.0, 58.0 },
            { -60.0, 7.0, 50.0, 65.0, 67.0, 30.0, 8.0, 1.0, 50.0, 77.0, 92.0,
                    85.0, 41.0, -37.0, -75.0, -65.0 },
            { 7.0, -53.0, -74.0, -82.0, -59.0, -24.0, 11.0, -8.0, -59.0, -76.0,
                    -94.0, -56.0, 3.0, 57.0, 79.0, 71.0 },
            { 39.0, 91.0, 94.0, 70.0, 39.0, -4.0, -7.0, 37.0, 64.0, 80.0, 57.0,
                    13.0, -63.0, -83.0, -95.0, -53.0 },
            { -75.0, -117.0, -91.0, -62.0, -7.0, -2.0, 7.0, -37.0, -64.0,
                    -56.0, -27.0, 34.0, 93.0, 97.0, 82.0, 41.0 },
            { 103.0, 123.0, 91.0, 30.0, 3.0, -22.0, 8.0, 39.0, 42.0, 37.0,
                    -30.0, -82.0, -99.0, -111.0, -74.0, -19.0 },
            { -111.0, -107.0, -49.0, -13.0, 36.0, 34.0, -14.0, -21.0, -23.0,
                    3.0, 61.0, 112.0, 105.0, 85.0, 30.0, -7.0 },
            { 107.0, 91.0, 20.0, -32.0, -39.0, -30.0, -7.0, 30.0, 4.0, -27.0,
                    -94.0, -103.0, -111.0, -52.0, 0.0, 37.0 },
            { -89.0, -52.0, 9.0, 48.0, 47.0, 36.0, -1.0, -19.0, 28.0, 73.0,
                    109.0, 106.0, 79.0, 11.0, -25.0, -68.0 },
            { 65.0, 11.0, -54.0, -85.0, -63.0, -13.0, 6.0, 5.0, -49.0, -89.0,
                    -110.0, -80.0, -44.0, 19.0, 75.0, 62.0 },
            { -28.0, 34.0, 73.0, 73.0, 44.0, 6.0, 9.0, 24.0, 52.0, 77.0, 95.0,
                    46.0, -15.0, -73.0, -88.0, -77.0 },
            { -32.0, -81.0, -92.0, -88.0, -47.0, -10.0, -4.0, -36.0, -68.0,
                    -86.0, -63.0, 2.0, 61.0, 101.0, 99.0, 68.0 },
            { 59.0, 101.0, 113.0, 75.0, 29.0, -16.0, 3.0, 38.0, 54.0, 68.0,
                    31.0, -29.0, -88.0, -102.0, -88.0, -37.0 },
            { -107.0, -105.0, -100.0, -38.0, 2.0, 26.0, 0.0, -25.0, -45.0,
                    -27.0, 19.0, 71.0, 98.0, 112.0, 60.0, 11.0 },
            { 106.0, 111.0, 71.0, 19.0, -19.0, -20.0, -3.0, 25.0, 21.0, 8.0,
                    -64.0, -107.0, -106.0, -94.0, -48.0, 7.0 },
            { -106.0, -93.0, -21.0, 31.0, 34.0, 35.0, -5.0, -25.0, 2.0, 31.0,
                    87.0, 108.0, 95.0, 54.0, -4.0, -45.0 },
            { 109.0, 59.0, -5.0, -59.0, -64.0, -28.0, 10.0, 18.0, -15.0, -54.0,
                    -101.0, -116.0, -75.0, -20.0, 25.0, 53.0 },
            { -71.0, -7.0, 47.0, 76.0, 62.0, 24.0, -6.0, 4.0, 31.0, 88.0, 94.0,
                    92.0, 49.0, -10.0, -71.0, -75.0 },
            { 37.0, -47.0, -70.0, -75.0, -61.0, -11.0, -5.0, -5.0, -41.0,
                    -93.0, -98.0, -63.0, -4.0, 68.0, 87.0, 65.0 },
            { 11.0, 69.0, 103.0, 89.0, 39.0, 8.0, 9.0, 17.0, 63.0, 80.0, 53.0,
                    4.0, -49.0, -84.0, -102.0, -72.0 },
            { -65.0, -111.0, -102.0, -59.0, -30.0, -5.0, 2.0, -32.0, -50.0,
                    -65.0, -22.0, 24.0, 90.0, 115.0, 93.0, 60.0 },
            { 103.0, 105.0, 94.0, 37.0, -4.0, -6.0, -10.0, 25.0, 43.0, 25.0,
                    -7.0, -70.0, -100.0, -104.0, -78.0, -28.0 },
            { -104.0, -110.0, -60.0, -21.0, 25.0, 16.0, 10.0, -38.0, -29.0,
                    -11.0, 57.0, 106.0, 118.0, 89.0, 35.0, -13.0 },
            { 109.0, 97.0, 43.0, -8.0, -32.0, -40.0, 7.0, 15.0, 19.0, -39.0,
                    -84.0, -121.0, -104.0, -69.0, -10.0, 40.0 },
            { -111.0, -46.0, 7.0, 51.0, 64.0, 22.0, 7.0, -21.0, 18.0, 61.0,
                    106.0, 107.0, 73.0, 38.0, -36.0, -47.0 },
            { 84.0, 7.0, -38.0, -63.0, -53.0, -23.0, -4.0, 7.0, -43.0, -66.0,
                    -102.0, -95.0, -56.0, 18.0, 67.0, 69.0 },
            { -24.0, 26.0, 76.0, 94.0, 49.0, 20.0, 4.0, 8.0, 41.0, 73.0, 97.0,
                    70.0, 0.0, -45.0, -93.0, -86.0 },
            { -7.0, -60.0, -106.0, -95.0, -38.0, 1.0, -7.0, -30.0, -50.0,
                    -69.0, -67.0, -30.0, 50.0, 92.0, 104.0, 77.0 },
            { 45.0, 89.0, 101.0, 65.0, 34.0, 5.0, 2.0, 26.0, 50.0, 74.0, 35.0,
                    -23.0, -84.0, -106.0, -95.0, -56.0 },
            { -79.0, -107.0, -107.0, -51.0, -14.0, 25.0, 5.0, -26.0, -45.0,
                    -43.0, 11.0, 69.0, 107.0, 118.0, 88.0, 27.0 },
            { 104.0, 102.0, 81.0, 12.0, -16.0, -17.0, -11.0, 32.0, 26.0, 19.0,
                    -37.0, -88.0, -124.0, -89.0, -45.0, 5.0 },
            { -124.0, -85.0, -52.0, 23.0, 49.0, 20.0, -9.0, -18.0, -19.0, 17.0,
                    75.0, 116.0, 110.0, 78.0, 18.0, -37.0 },
            { 104.0, 56.0, -7.0, -47.0, -54.0, -23.0, -10.0, 22.0, -7.0, -56.0,
                    -104.0, -103.0, -96.0, -36.0, 15.0, 46.0 },
            { -84.0, -27.0, 26.0, 59.0, 59.0, 24.0, -9.0, 7.0, 18.0, 63.0,
                    102.0, 85.0, 52.0, -3.0, -44.0, -70.0 },
            { 51.0, -20.0, -69.0, -81.0, -64.0, -32.0, -5.0, -12.0, -40.0,
                    -92.0, -102.0, -75.0, -4.0, 55.0, 79.0, 68.0 },
            { -8.0, 59.0, 104.0, 92.0, 39.0, 1.0, -2.0, 21.0, 56.0, 79.0, 67.0,
                    18.0, -23.0, -78.0, -91.0, -76.0 },
            { -55.0, -90.0, -115.0, -66.0, -40.0, 0.0, -3.0, -17.0, -68.0,
                    -68.0, -34.0, 19.0, 65.0, 104.0, 94.0, 49.0 },
            { 77.0, 109.0, 90.0, 58.0, 16.0, -19.0, -5.0, 31.0, 62.0, 46.0,
                    8.0, -47.0, -89.0, -99.0, -72.0, -44.0 },
            { -102.0, -115.0, -78.0, -20.0, 5.0, 33.0, 4.0, -19.0, -45.0, -5.0,
                    27.0, 97.0, 112.0, 97.0, 59.0, 6.0 },
            { 113.0, 90.0, 48.0, 4.0, -44.0, -39.0, -5.0, 14.0, 29.0, -22.0,
                    -58.0, -114.0, -102.0, -68.0, -24.0, 12.0 },
            { -113.0, -65.0, -19.0, 37.0, 42.0, 42.0, 6.0, -19.0, 10.0, 37.0,
                    89.0, 114.0, 92.0, 37.0, -14.0, -39.0 },
            { 85.0, 39.0, -19.0, -63.0, -67.0, -37.0, 3.0, 14.0, -14.0, -74.0,
                    -107.0, -109.0, -57.0, 1.0, 47.0, 76.0 },
            { -61.0, 10.0, 74.0, 71.0, 62.0, 15.0, 10.0, 18.0, 34.0, 72.0,
                    97.0, 65.0, 14.0, -28.0, -80.0, -85.0 },
            { -3.0, -54.0, -97.0, -96.0, -41.0, -8.0, 11.0, -8.0, -63.0, -91.0,
                    -69.0, -41.0, 34.0, 63.0, 86.0, 79.0 },
            { 45.0, 99.0, 111.0, 68.0, 43.0, -8.0, 10.0, 24.0, 55.0, 66.0,
                    50.0, 0.0, -73.0, -100.0, -98.0, -52.0 },
            { -86.0, -118.0, -111.0, -51.0, -4.0, 16.0, -10.0, -21.0, -62.0,
                    -43.0, -17.0, 45.0, 99.0, 99.0, 92.0, 49.0 },
            { 102.0, 122.0, 82.0, 43.0, -12.0, -11.0, -7.0, 31.0, 33.0, 18.0,
                    -36.0, -83.0, -120.0, -94.0, -71.0, -24.0 },
            { -109.0, -105.0, -46.0, -10.0, 21.0, 25.0, 8.0, -15.0, -32.0, 6.0,
                    52.0, 97.0, 123.0, 73.0, 41.0, -7.0 },
            { 111.0, 85.0, 29.0, -33.0, -53.0, -38.0, -3.0, 21.0, 7.0, -32.0,
                    -85.0, -106.0, -94.0, -43.0, 2.0, 41.0 },
            { -92.0, -34.0, 11.0, 68.0, 49.0, 33.0, -10.0, -12.0, 27.0, 75.0,
                    107.0, 104.0, 59.0, 21.0, -39.0, -71.0 },
            { 65.0, 5.0, -51.0, -76.0, -69.0, -17.0, 11.0, -4.0, -34.0, -89.0,
                    -107.0, -70.0, -23.0, 20.0, 62.0, 71.0 },
            { -14.0, 37.0, 89.0, 89.0, 46.0, 21.0, 0.0, 13.0, 64.0, 75.0, 90.0,
                    34.0, -13.0, -75.0, -87.0, -79.0 },
            { -26.0, -75.0, -99.0, -82.0, -48.0, 3.0, 2.0, -33.0, -55.0, -79.0,
                    -64.0, -10.0, 46.0, 84.0, 87.0, 67.0 },
            { 79.0, 101.0, 106.0, 59.0, 17.0, 2.0, 8.0, 22.0, 65.0, 45.0, 19.0,
                    -30.0, -81.0, -114.0, -80.0, -55.0 },
            { -99.0, -105.0, -90.0, -46.0, 16.0, 27.0, -11.0, -41.0, -54.0,
                    -35.0, 16.0, 66.0, 99.0, 95.0, 78.0, 9.0 },
            { 117.0, 96.0, 63.0, -2.0, -26.0, -20.0, 11.0, 32.0, 38.0, -14.0,
                    -55.0, -100.0, -123.0, -98.0, -44.0, 17.0 },
            { -105.0, -92.0, -22.0, 35.0, 43.0, 20.0, -10.0, -29.0, -5.0, 38.0,
                    75.0, 121.0, 111.0, 47.0, 4.0, -35.0 },
            { 106.0, 55.0, -10.0, -49.0, -63.0, -29.0, -5.0, 3.0, -15.0, -70.0,
                    -103.0, -98.0, -84.0, -24.0, 41.0, 54.0 },
            { -70.0, -13.0, 55.0, 84.0, 50.0, 17.0, 9.0, -6.0, 43.0, 69.0,
                    91.0, 75.0, 28.0, -26.0, -55.0, -76.0 },
            { 26.0, -50.0, -92.0, -79.0, -45.0, -9.0, 7.0, -26.0, -44.0, -80.0,
                    -80.0, -54.0, 10.0, 61.0, 80.0, 72.0 },
            { 29.0, 76.0, 109.0, 73.0, 40.0, 2.0, -6.0, 36.0, 70.0, 87.0, 52.0,
                    10.0, -58.0, -89.0, -98.0, -58.0 },
            { -60.0, -107.0, -111.0, -75.0, -10.0, -3.0, 0.0, -34.0, -68.0,
                    -64.0, -23.0, 42.0, 74.0, 104.0, 100.0, 44.0 },
            { 102.0, 115.0, 94.0, 51.0, -12.0, -22.0, -8.0, 24.0, 40.0, 36.0,
                    -11.0, -80.0, -110.0, -97.0, -66.0, -14.0 },
            { -105.0, -99.0, -55.0, -13.0, 22.0, 29.0, -13.0, -35.0, -28.0,
                    -11.0, 56.0, 89.0, 113.0, 82.0, 47.0, -4.0 },
            { 106.0, 95.0, 26.0, -24.0, -43.0, -34.0, 6.0, 32.0, 17.0, -42.0,
                    -77.0, -120.0, -109.0, -60.0, -1.0, 23.0 },
            { -105.0, -52.0, 0.0, 40.0, 52.0, 35.0, -7.0, -20.0, 4.0, 49.0,
                    97.0, 99.0, 84.0, 14.0, -30.0, -62.0 },
            { 64.0, 9.0, -43.0, -74.0, -54.0, -15.0, -4.0, -7.0, -46.0, -78.0,
                    -111.0, -79.0, -35.0, 10.0, 61.0, 79.0 },
            { -34.0, 30.0, 75.0, 92.0, 59.0, 20.0, -4.0, 23.0, 45.0, 77.0,
                    83.0, 66.0, 9.0, -67.0, -94.0, -72.0 },
            { -27.0, -71.0, -100.0, -79.0, -31.0, -16.0, 9.0, -30.0, -68.0,
                    -86.0, -53.0, -5.0, 42.0, 77.0, 104.0, 77.0 },
            { 53.0, 94.0, 111.0, 58.0, 25.0, 6.0, -5.0, 29.0, 66.0, 52.0, 38.0,
                    -37.0, -71.0, -112.0, -98.0, -46.0 },
            { -87.0, -117.0, -91.0, -34.0, 10.0, 3.0, -15.0, -30.0, -62.0,
                    -42.0, 10.0, 75.0, 96.0, 100.0, 67.0, 22.0 },
            { 124.0, 101.0, 56.0, 21.0, -17.0, -30.0, 15.0, 34.0, 41.0, 11.0,
                    -39.0, -95.0, -121.0, -83.0, -36.0, 11.0 },
            { -127.0, -90.0, -22.0, 9.0, 35.0, 15.0, -7.0, -21.0, -8.0, 38.0,
                    71.0, 112.0, 106.0, 56.0, 10.0, -20.0 },
            { 108.0, 58.0, 4.0, -50.0, -44.0, -27.0, -6.0, 22.0, -3.0, -60.0,
                    -107.0, -99.0, -91.0, -32.0, 35.0, 64.0 },
            { -61.0, -7.0, 54.0, 73.0, 52.0, 13.0, -2.0, 9.0, 33.0, 86.0, 98.0,
                    82.0, 48.0, -10.0, -49.0, -58.0 },
            { 29.0, -43.0, -76.0, -83.0, -61.0, -5.0, -10.0, -11.0, -43.0,
                    -84.0, -100.0, -50.0, 2.0, 49.0, 86.0, 84.0 },
            { 22.0, 70.0, 88.0, 68.0, 48.0, 15.0, 12.0, 37.0, 63.0, 87.0, 76.0,
                    11.0, -46.0, -82.0, -83.0, -62.0 },
            { -52.0, -89.0, -91.0, -61.0, -20.0, 11.0, -1.0, -44.0, -74.0,
                    -75.0, -33.0, 18.0, 80.0, 109.0, 100.0, 59.0 },
            { 95.0, 106.0, 80.0, 51.0, -8.0, -20.0, -3.0, 46.0, 63.0, 42.0,
                    1.0, -72.0, -95.0, -96.0, -70.0, -33.0 },
            { -120.0, -109.0, -77.0, -10.0, 24.0, 9.0, -1.0, -41.0, -46.0,
                    -11.0, 41.0, 102.0, 104.0, 98.0, 52.0, -7.0 },
            { 127.0, 81.0, 24.0, -24.0, -44.0, -14.0, 7.0, 26.0, 13.0, -21.0,
                    -89.0, -106.0, -110.0, -58.0, -16.0, 18.0 },
            { -107.0, -58.0, -3.0, 34.0, 49.0, 21.0, 3.0, -4.0, 22.0, 68.0,
                    95.0, 108.0, 78.0, 30.0, -23.0, -49.0 },
            { 78.0, 21.0, -51.0, -74.0, -52.0, -29.0, -2.0, 9.0, -44.0, -69.0,
                    -114.0, -103.0, -42.0, 7.0, 65.0, 72.0 },
            { -19.0, 27.0, 80.0, 71.0, 56.0, 18.0, -11.0, 16.0, 56.0, 79.0,
                    103.0, 52.0, 14.0, -62.0, -74.0, -71.0 },
            { -10.0, -62.0, -89.0, -75.0, -46.0, -13.0, -13.0, -39.0, -69.0,
                    -83.0, -77.0, -12.0, 34.0, 94.0, 87.0, 67.0 },
            { 64.0, 91.0, 107.0, 54.0, 11.0, 3.0, 4.0, 28.0, 57.0, 77.0, 39.0,
                    -33.0, -77.0, -112.0, -90.0, -43.0 },
            { -104.0, -109.0, -83.0, -48.0, 9.0, 13.0, -2.0, -38.0, -56.0,
                    -40.0, 17.0, 55.0, 95.0, 110.0, 65.0, 33.0 },
            { 122.0, 117.0, 72.0, 11.0, -28.0, -12.0, 1.0, 40.0, 37.0, -3.0,
                    -50.0, -95.0, -109.0, -100.0, -56.0, -10.0 },
            { -117.0, -83.0, -30.0, 7.0, 45.0, 28.0, -2.0, -34.0, -16.0, 39.0,
                    73.0, 106.0, 116.0, 57.0, 18.0, -37.0 },
            { 97.0, 45.0, -16.0, -44.0, -52.0, -20.0, 2.0, 9.0, -3.0, -69.0,
                    -100.0, -108.0, -86.0, -20.0, 20.0, 48.0 },
            { -75.0, -5.0, 34.0, 70.0, 51.0, 10.0, -10.0, -1.0, 48.0, 79.0,
                    101.0, 85.0, 41.0, -19.0, -61.0, -60.0 },
            { 33.0, -44.0, -72.0, -72.0, -35.0, -1.0, 0.0, -8.0, -52.0, -84.0,
                    -101.0, -61.0, -12.0, 51.0, 89.0, 80.0 },
            { 25.0, 75.0, 102.0, 82.0, 32.0, 14.0, 14.0, 23.0, 72.0, 79.0,
                    60.0, 23.0, -32.0, -83.0, -94.0, -63.0 },
            { -58.0, -109.0, -104.0, -70.0, -19.0, 10.0, -16.0, -38.0, -74.0,
                    -58.0, -39.0, 26.0, 69.0, 95.0, 86.0, 44.0 },
            { 87.0, 121.0, 91.0, 35.0, 10.0, -1.0, 9.0, 49.0, 65.0, 39.0,
                    -11.0, -76.0, -106.0, -94.0, -67.0, -34.0 },
            { -108.0, -114.0, -64.0, -5.0, 29.0, 24.0, -22.0, -38.0, -36.0,
                    1.0, 60.0, 107.0, 103.0, 98.0, 38.0, 8.0 },
            { 105.0, 74.0, 26.0, -29.0, -30.0, -7.0, 7.0, 27.0, 17.0, -41.0,
                    -92.0, -122.0, -98.0, -68.0, -3.0, 29.0 },
            { -94.0, -44.0, 5.0, 39.0, 54.0, 17.0, 0.0, -18.0, 6.0, 54.0, 98.0,
                    102.0, 72.0, 16.0, -36.0, -52.0 },
            { 56.0, 15.0, -56.0, -73.0, -38.0, -22.0, -4.0, 3.0, -35.0, -94.0,
                    -106.0, -96.0, -43.0, 25.0, 56.0, 54.0 },
            { -33.0, 47.0, 76.0, 81.0, 48.0, 14.0, -6.0, 26.0, 68.0, 81.0,
                    101.0, 62.0, 7.0, -46.0, -85.0, -74.0 },
            { -33.0, -79.0, -82.0, -81.0, -42.0, -13.0, -10.0, -24.0, -61.0,
                    -93.0, -68.0, -19.0, 42.0, 88.0, 99.0, 66.0 },
            { 57.0, 110.0, 91.0, 67.0, 7.0, -13.0, 16.0, 46.0, 71.0, 61.0,
                    18.0, -40.0, -82.0, -96.0, -88.0, -54.0 },
            { -90.0, -100.0, -80.0, -40.0, -8.0, 2.0, -23.0, -55.0, -67.0,
                    -41.0, 19.0, 77.0, 102.0, 102.0, 76.0, 16.0 },
            { 126.0, 93.0, 65.0, 2.0, -11.0, -13.0, 8.0, 36.0, 42.0, -8.0,
                    -57.0, -105.0, -120.0, -84.0, -32.0, 9.0 },
            { -117.0, -68.0, -23.0, 25.0, 24.0, 22.0, -13.0, -21.0, -2.0, 46.0,
                    93.0, 121.0, 103.0, 58.0, 3.0, -39.0 },
            { 105.0, 39.0, -8.0, -41.0, -41.0, -23.0, 2.0, 21.0, -16.0, -77.0,
                    -94.0, -99.0, -83.0, -18.0, 30.0, 56.0 },
            { -64.0, 1.0, 44.0, 70.0, 35.0, 4.0, -8.0, -2.0, 43.0, 78.0, 95.0,
                    97.0, 48.0, -30.0, -69.0, -55.0 },
            { 11.0, -40.0, -78.0, -66.0, -35.0, -1.0, 6.0, -13.0, -72.0, -95.0,
                    -86.0, -48.0, 6.0, 68.0, 89.0, 74.0 },
            { 40.0, 89.0, 102.0, 77.0, 38.0, -6.0, 1.0, 43.0, 80.0, 93.0, 56.0,
                    7.0, -40.0, -79.0, -81.0, -65.0 },
            { -81.0, -95.0, -102.0, -52.0, -10.0, 13.0, -23.0, -56.0, -79.0,
                    -56.0, -24.0, 27.0, 95.0, 101.0, 85.0, 42.0 },
            { 94.0, 106.0, 69.0, 21.0, -12.0, -9.0, 25.0, 41.0, 45.0, 41.0,
                    -15.0, -77.0, -100.0, -109.0, -71.0, -10.0 },
            { -113.0, -102.0, -57.0, -3.0, 11.0, 1.0, -8.0, -42.0, -35.0, 14.0,
                    60.0, 103.0, 105.0, 91.0, 31.0, -11.0 },
            { 105.0, 67.0, 8.0, -33.0, -25.0, -5.0, 15.0, 33.0, 11.0, -38.0,
                    -100.0, -107.0, -109.0, -51.0, 9.0, 23.0 },
            { -91.0, -46.0, 16.0, 59.0, 51.0, 13.0, -22.0, -2.0, 29.0, 74.0,
                    109.0, 101.0, 66.0, 25.0, -40.0, -43.0 },
            { 47.0, 1.0, -53.0, -72.0, -53.0, -20.0, -1.0, -4.0, -55.0, -87.0,
                    -98.0, -73.0, -41.0, 17.0, 52.0, 61.0 },
            { 1.0, 50.0, 88.0, 72.0, 35.0, -2.0, 1.0, 35.0, 71.0, 83.0, 92.0,
                    52.0, -12.0, -72.0, -91.0, -74.0 },
            { -46.0, -89.0, -82.0, -63.0, -16.0, -11.0, -18.0, -50.0, -68.0,
                    -80.0, -45.0, -7.0, 47.0, 81.0, 79.0, 44.0 },
            { 78.0, 99.0, 99.0, 60.0, 12.0, -4.0, 4.0, 41.0, 68.0, 48.0, 5.0,
                    -40.0, -80.0, -111.0, -75.0, -36.0 },
            { -103.0, -119.0, -70.0, -22.0, 17.0, 18.0, -27.0, -45.0, -46.0,
                    -15.0, 34.0, 75.0, 119.0, 93.0, 58.0, 17.0 },
            { 126.0, 85.0, 56.0, 0.0, -21.0, -20.0, 28.0, 47.0, 35.0, -17.0,
                    -70.0, -110.0, -116.0, -69.0, -39.0, 9.0 },
            { -104.0, -70.0, -2.0, 33.0, 26.0, 8.0, -12.0, -30.0, -9.0, 48.0,
                    105.0, 105.0, 88.0, 47.0, -13.0, -30.0 },
            { 78.0, 29.0, -16.0, -42.0, -51.0, -11.0, 11.0, -3.0, -36.0, -75.0,
                    -103.0, -100.0, -55.0, -14.0, 31.0, 50.0 },
            { -54.0, 13.0, 57.0, 59.0, 52.0, 3.0, -11.0, 3.0, 61.0, 95.0,
                    106.0, 73.0, 20.0, -43.0, -62.0, -64.0 },
            { 0.0, -50.0, -79.0, -61.0, -32.0, -7.0, 5.0, -20.0, -65.0, -103.0,
                    -80.0, -32.0, 12.0, 74.0, 88.0, 55.0 },
            { 49.0, 80.0, 85.0, 69.0, 16.0, -9.0, 10.0, 37.0, 64.0, 69.0, 39.0,
                    -4.0, -61.0, -101.0, -77.0, -53.0 },
            { -75.0, -116.0, -86.0, -54.0, 0.0, 13.0, -13.0, -47.0, -68.0,
                    -47.0, -14.0, 45.0, 105.0, 113.0, 73.0, 43.0 },
            { 100.0, 118.0, 80.0, 22.0, -6.0, -12.0, 9.0, 55.0, 58.0, 18.0,
                    -31.0, -94.0, -120.0, -106.0, -60.0, -1.0 },
            { -124.0, -84.0, -30.0, 13.0, 36.0, 6.0, -28.0, -38.0, -14.0, 19.0,
                    70.0, 119.0, 104.0, 78.0, 15.0, -13.0 },
            { 107.0, 58.0, -6.0, -24.0, -42.0, -11.0, 26.0, 11.0, 4.0, -64.0,
                    -108.0, -123.0, -82.0, -30.0, 21.0, 31.0 },
            { -89.0, -24.0, 39.0, 62.0, 47.0, 7.0, -8.0, 7.0, 27.0, 90.0,
                    103.0, 107.0, 54.0, 9.0, -44.0, -65.0 },
            { 48.0, -18.0, -72.0, -69.0, -48.0, -9.0, 11.0, -16.0, -64.0,
                    -83.0, -90.0, -60.0, -24.0, 37.0, 78.0, 64.0 },
            { 2.0, 73.0, 86.0, 62.0, 23.0, 8.0, 14.0, 23.0, 62.0, 102.0, 82.0,
                    35.0, -30.0, -74.0, -75.0, -57.0 },
            { -58.0, -96.0, -96.0, -65.0, -22.0, -3.0, -19.0, -34.0, -70.0,
                    -69.0, -31.0, 18.0, 80.0, 88.0, 81.0, 56.0 },
            { 81.0, 119.0, 76.0, 49.0, 13.0, 1.0, 13.0, 57.0, 74.0, 38.0,
                    -11.0, -53.0, -89.0, -92.0, -77.0, -38.0 },
            { -119.0, -116.0, -70.0, -20.0, 22.0, 20.0, -18.0, -44.0, -54.0,
                    -17.0, 37.0, 99.0, 122.0, 86.0, 40.0, 6.0 },
            { 114.0, 98.0, 39.0, -6.0, -39.0, -4.0, 28.0, 30.0, 19.0, -29.0,
                    -89.0, -101.0, -103.0, -78.0, -27.0, 25.0 },
            { -111.0, -57.0, 5.0, 30.0, 47.0, 3.0, -12.0, -11.0, 4.0, 66.0,
                    91.0, 122.0, 88.0, 40.0, -26.0, -45.0 },
            { 64.0, 10.0, -36.0, -64.0, -54.0, -2.0, 19.0, -10.0, -46.0, -88.0,
                    -117.0, -105.0, -58.0, -2.0, 59.0, 48.0 },
            { -37.0, 20.0, 68.0, 67.0, 31.0, 18.0, -5.0, 9.0, 70.0, 96.0,
                    106.0, 72.0, 16.0, -57.0, -65.0, -72.0 },
            { -10.0, -60.0, -79.0, -81.0, -22.0, -13.0, -13.0, -29.0, -63.0,
                    -97.0, -61.0, -22.0, 30.0, 71.0, 79.0, 69.0 },
            { 52.0, 101.0, 87.0, 50.0, 14.0, 6.0, 0.0, 52.0, 70.0, 81.0, 39.0,
                    -14.0, -71.0, -92.0, -90.0, -35.0 },
            { -103.0, -100.0, -90.0, -49.0, -8.0, 10.0, -9.0, -53.0, -57.0,
                    -36.0, 19.0, 71.0, 113.0, 111.0, 74.0, 34.0 },
            { 105.0, 98.0, 53.0, 5.0, -18.0, -18.0, 23.0, 46.0, 51.0, -2.0,
                    -50.0, -87.0, -111.0, -89.0, -33.0, 10.0 },
            { -125.0, -77.0, -20.0, 11.0, 24.0, 4.0, -6.0, -30.0, -4.0, 35.0,
                    83.0, 103.0, 111.0, 68.0, 21.0, -19.0 },
            { 98.0, 60.0, -19.0, -37.0, -34.0, -25.0, 19.0, 22.0, -10.0, -59.0,
                    -105.0, -113.0, -70.0, -18.0, 33.0, 57.0 },
            { -78.0, -14.0, 36.0, 71.0, 47.0, 14.0, -16.0, -1.0, 32.0, 75.0,
                    109.0, 98.0, 34.0, -5.0, -49.0, -66.0 },
            { 27.0, -37.0, -71.0, -84.0, -34.0, -19.0, 11.0, -11.0, -60.0,
                    -83.0, -86.0, -67.0, 9.0, 58.0, 68.0, 72.0 },
            { 11.0, 85.0, 100.0, 82.0, 41.0, 5.0, 14.0, 25.0, 80.0, 84.0, 76.0,
                    16.0, -47.0, -87.0, -96.0, -60.0 },
            { -60.0, -92.0, -106.0, -67.0, -23.0, -3.0, -20.0, -41.0, -76.0,
                    -56.0, -24.0, 30.0, 90.0, 109.0, 85.0, 54.0 },
            { 94.0, 119.0, 77.0, 47.0, 3.0, -8.0, 3.0, 35.0, 59.0, 34.0, -19.0,
                    -61.0, -99.0, -97.0, -73.0, -23.0 },
            { -105.0, -104.0, -50.0, -4.0, 28.0, 18.0, -4.0, -49.0, -27.0,
                    -10.0, 53.0, 98.0, 102.0, 94.0, 48.0, -2.0 },
            { 119.0, 72.0, 23.0, -32.0, -45.0, -8.0, 3.0, 18.0, 4.0, -44.0,
                    -87.0, -117.0, -94.0, -61.0, 4.0, 30.0 },
            { -100.0, -50.0, 14.0, 40.0, 54.0, 20.0, -10.0, -14.0, 8.0, 59.0,
                    110.0, 106.0, 83.0, 11.0, -21.0, -61.0 },
            { 54.0, 13.0, -51.0, -61.0, -39.0, -22.0, 11.0, -8.0, -51.0, -76.0,
                    -114.0, -81.0, -39.0, 15.0, 49.0, 64.0 },
            { -13.0, 31.0, 87.0, 79.0, 38.0, 14.0, -1.0, 14.0, 50.0, 81.0,
                    92.0, 59.0, 2.0, -68.0, -74.0, -77.0 },
            { -31.0, -77.0, -87.0, -63.0, -37.0, -10.0, -14.0, -44.0, -76.0,
                    -81.0, -60.0, -6.0, 43.0, 87.0, 99.0, 59.0 },
            { 61.0, 95.0, 105.0, 54.0, 8.0, -14.0, 5.0, 50.0, 72.0, 72.0, 31.0,
                    -46.0, -94.0, -100.0, -86.0, -36.0 },
            { -93.0, -102.0, -93.0, -45.0, 13.0, 14.0, -13.0, -31.0, -64.0,
                    -42.0, 21.0, 85.0, 117.0, 107.0, 64.0, 22.0 },
            { 107.0, 114.0, 69.0, 12.0, -26.0, -9.0, 20.0, 30.0, 23.0, -14.0,
                    -48.0, -111.0, -120.0, -76.0, -45.0, -3.0 },
            { -110.0, -70.0, -22.0, 15.0, 42.0, 22.0, -4.0, -20.0, -8.0, 36.0,
                    81.0, 106.0, 92.0, 66.0, 10.0, -41.0 },
            { 91.0, 46.0, -9.0, -43.0, -60.0, -14.0, 7.0, 18.0, -19.0, -76.0,
                    -114.0, -117.0, -63.0, -27.0, 23.0, 51.0 },
            { -51.0, 9.0, 60.0, 61.0, 62.0, 7.0, -13.0, 9.0, 32.0, 93.0, 106.0,
                    86.0, 25.0, -19.0, -67.0, -76.0 },
            { 28.0, -49.0, -77.0, -70.0, -46.0, -18.0, 6.0, -24.0, -69.0,
                    -96.0, -81.0, -41.0, 7.0, 52.0, 81.0, 68.0 },
            { 38.0, 71.0, 99.0, 66.0, 32.0, 9.0, -1.0, 23.0, 76.0, 90.0, 61.0,
                    -4.0, -61.0, -91.0, -82.0, -69.0 },
            { -76.0, -95.0, -96.0, -50.0, -22.0, 16.0, -3.0, -42.0, -72.0,
                    -64.0, -25.0, 31.0, 78.0, 115.0, 78.0, 38.0 },
            { 91.0, 104.0, 81.0, 29.0, -2.0, -12.0, -3.0, 35.0, 43.0, 36.0,
                    -31.0, -67.0, -112.0, -100.0, -58.0, -11.0 },
            { -117.0, -102.0, -66.0, -13.0, 17.0, 17.0, -8.0, -25.0, -39.0,
                    12.0, 58.0, 96.0, 119.0, 85.0, 29.0, -20.0 },
            { 106.0, 77.0, 16.0, -31.0, -38.0, -22.0, -4.0, 22.0, 11.0, -28.0,
                    -77.0, -103.0, -96.0, -63.0, -2.0, 27.0 },
            { -85.0, -46.0, 20.0, 53.0, 64.0, 29.0, 5.0, -2.0, 9.0, 63.0,
                    110.0, 112.0, 82.0, 26.0, -31.0, -63.0 },
            { 52.0, -1.0, -56.0, -84.0, -66.0, -15.0, 1.0, -12.0, -46.0, -82.0,
                    -97.0, -75.0, -29.0, 36.0, 56.0, 74.0 },
            { -21.0, 42.0, 73.0, 72.0, 49.0, 20.0, 0.0, 18.0, 47.0, 93.0, 87.0,
                    57.0, -13.0, -66.0, -96.0, -62.0 },
            { -18.0, -83.0, -108.0, -75.0, -30.0, -10.0, 9.0, -32.0, -61.0,
                    -87.0, -47.0, 5.0, 49.0, 82.0, 87.0, 72.0 },
            { 69.0, 105.0, 98.0, 53.0, 17.0, 2.0, 3.0, 28.0, 62.0, 57.0, 29.0,
                    -41.0, -97.0, -113.0, -90.0, -35.0 },
            { -101.0, -122.0, -92.0, -48.0, 3.0, 21.0, -12.0, -34.0, -59.0,
                    -38.0, 31.0, 86.0, 109.0, 94.0, 61.0, 9.0 },
            { 107.0, 116.0, 70.0, 9.0, -17.0, -35.0, 10.0, 22.0, 19.0, 6.0,
                    -55.0, -105.0, -104.0, -97.0, -42.0, 18.0 },
            { -121.0, -76.0, -22.0, 17.0, 54.0, 30.0, 8.0, -28.0, -16.0, 33.0,
                    76.0, 118.0, 98.0, 65.0, 6.0, -36.0 },
            { 99.0, 48.0, -26.0, -64.0, -57.0, -29.0, 12.0, 11.0, -15.0, -69.0,
                    -111.0, -97.0, -83.0, -17.0, 32.0, 51.0 },
            { -54.0, 3.0, 63.0, 70.0, 49.0, 34.0, -11.0, -3.0, 45.0, 69.0,
                    108.0, 92.0, 38.0, -26.0, -76.0, -62.0 },
            { 30.0, -33.0, -94.0, -94.0, -64.0, -26.0, 10.0, -20.0, -43.0,
                    -95.0, -90.0, -42.0, 20.0, 60.0, 80.0, 68.0 },
            { 34.0, 70.0, 107.0, 83.0, 31.0, 11.0, 10.0, 28.0, 70.0, 74.0,
                    47.0, -3.0, -43.0, -92.0, -86.0, -60.0 },
            { -75.0, -102.0, -114.0, -61.0, -27.0, 17.0, 1.0, -22.0, -50.0,
                    -67.0, -29.0, 47.0, 87.0, 117.0, 80.0, 56.0 },
            { 98.0, 107.0, 92.0, 46.0, 1.0, -26.0, -5.0, 21.0, 37.0, 34.0,
                    -11.0, -67.0, -102.0, -107.0, -63.0, -23.0 },
            { -108.0, -111.0, -74.0, 2.0, 31.0, 17.0, -5.0, -30.0, -37.0, 12.0,
                    65.0, 92.0, 113.0, 88.0, 31.0, -6.0 },
            { 105.0, 93.0, 24.0, -30.0, -38.0, -42.0, 5.0, 14.0, 6.0, -38.0,
                    -72.0, -104.0, -92.0, -58.0, -10.0, 32.0 },
            { -99.0, -58.0, 23.0, 62.0, 61.0, 43.0, 4.0, -18.0, 16.0, 51.0,
                    105.0, 106.0, 83.0, 21.0, -23.0, -66.0 },
            { 57.0, 12.0, -58.0, -85.0, -62.0, -18.0, 6.0, -5.0, -35.0, -75.0,
                    -108.0, -86.0, -35.0, 12.0, 76.0, 80.0 },
            { -14.0, 32.0, 76.0, 94.0, 62.0, 8.0, -11.0, 18.0, 54.0, 83.0,
                    75.0, 50.0, -15.0, -72.0, -91.0, -83.0 },
            { -12.0, -68.0, -112.0, -75.0, -33.0, 2.0, 11.0, -17.0, -46.0,
                    -67.0, -56.0, -2.0, 43.0, 81.0, 87.0, 68.0 },
            { 53.0, 114.0, 110.0, 69.0, 13.0, -11.0, -12.0, 25.0, 48.0, 49.0,
                    16.0, -42.0, -74.0, -109.0, -86.0, -58.0 },
            { -98.0, -111.0, -104.0, -37.0, -8.0, 21.0, 6.0, -34.0, -44.0,
                    -42.0, 13.0, 71.0, 114.0, 104.0, 77.0, 28.0 },
            { 120.0, 115.0, 67.0, 18.0, -23.0, -31.0, -1.0, 33.0, 25.0, 6.0,
                    -60.0, -98.0, -107.0, -87.0, -50.0, -3.0 },
            { -121.0, -96.0, -35.0, 11.0, 36.0, 29.0, -6.0, -22.0, -1.0, 37.0,
                    83.0, 113.0, 98.0, 64.0, -1.0, -30.0 },
            { 96.0, 59.0, -3.0, -59.0, -54.0, -30.0, -3.0, 4.0, -3.0, -46.0,
                    -87.0, -117.0, -89.0, -17.0, 20.0, 57.0 },
            { -60.0, -3.0, 58.0, 73.0, 70.0, 26.0, 11.0, 6.0, 32.0, 82.0, 98.0,
                    83.0, 42.0, -28.0, -73.0, -79.0 },
            { 23.0, -40.0, -71.0, -78.0, -69.0, -20.0, -10.0, -5.0, -46.0,
                    -89.0, -76.0, -52.0, 11.0, 65.0, 89.0, 75.0 },
            { 5.0, 81.0, 91.0, 80.0, 58.0, 8.0, -1.0, 26.0, 63.0, 85.0, 71.0,
                    5.0, -38.0, -83.0, -93.0, -83.0 },
            { -67.0, -112.0, -110.0, -67.0, -22.0, 7.0, 10.0, -22.0, -58.0,
                    -51.0, -29.0, 27.0, 86.0, 115.0, 99.0, 56.0 },
            { 82.0, 112.0, 108.0, 56.0, 2.0, -11.0, -15.0, 18.0, 51.0, 25.0,
                    1.0, -70.0, -99.0, -114.0, -85.0, -20.0 },
            { -120.0, -106.0, -71.0, -25.0, 18.0, 21.0, -1.0, -15.0, -20.0,
                    5.0, 44.0, 85.0, 110.0, 96.0, 40.0, -12.0 },
            { 124.0, 83.0, 48.0, -24.0, -45.0, -39.0, 3.0, 19.0, 13.0, -22.0,
                    -64.0, -99.0, -113.0, -74.0, -20.0, 37.0 },
            { -95.0, -50.0, -2.0, 51.0, 69.0, 39.0, 16.0, -5.0, 8.0, 58.0,
                    91.0, 116.0, 76.0, 26.0, -34.0, -47.0 },
            { 76.0, 8.0, -48.0, -83.0, -69.0, -30.0, 2.0, -3.0, -23.0, -66.0,
                    -107.0, -82.0, -46.0, 2.0, 61.0, 75.0 },
            { -34.0, 18.0, 81.0, 93.0, 54.0, 16.0, 1.0, 19.0, 44.0, 78.0, 98.0,
                    51.0, -4.0, -42.0, -94.0, -90.0 },
            { -4.0, -68.0, -89.0, -97.0, -43.0, -20.0, 3.0, -25.0, -58.0,
                    -65.0, -76.0, -14.0, 36.0, 75.0, 88.0, 79.0 },
            { 46.0, 99.0, 98.0, 88.0, 38.0, -13.0, -5.0, 24.0, 42.0, 53.0,
                    43.0, -23.0, -81.0, -105.0, -102.0, -69.0 },
            { -83.0, -105.0, -108.0, -65.0, 2.0, 26.0, 15.0, -31.0, -43.0,
                    -43.0, 7.0, 55.0, 93.0, 121.0, 92.0, 39.0 },
            { 108.0, 107.0, 71.0, 31.0, -9.0, -38.0, -5.0, 15.0, 41.0, 20.0,
                    -47.0, -82.0, -104.0, -95.0, -54.0, 5.0 },
            { -124.0, -97.0, -42.0, 17.0, 32.0, 29.0, 18.0, -18.0, -24.0, 12.0,
                    66.0, 96.0, 119.0, 76.0, 10.0, -28.0 },
            { 97.0, 57.0, 13.0, -54.0, -49.0, -42.0, -10.0, 2.0, -1.0, -37.0,
                    -79.0, -98.0, -79.0, -44.0, 27.0, 45.0 },
            { -72.0, -34.0, 46.0, 80.0, 77.0, 31.0, 15.0, 3.0, 23.0, 76.0,
                    107.0, 99.0, 54.0, 2.0, -51.0, -84.0 },
            { 53.0, -16.0, -62.0, -77.0, -56.0, -36.0, -12.0, -17.0, -41.0,
                    -82.0, -99.0, -57.0, -24.0, 50.0, 92.0, 92.0 },
            { -1.0, 51.0, 88.0, 81.0, 44.0, 8.0, -2.0, 25.0, 41.0, 85.0, 60.0,
                    24.0, -38.0, -87.0, -107.0, -69.0 },
            { -52.0, -96.0, -113.0, -87.0, -43.0, 5.0, -3.0, -13.0, -50.0,
                    -53.0, -30.0, 6.0, 63.0, 101.0, 89.0, 71.0 },
            { 71.0, 120.0, 93.0, 62.0, 1.0, -22.0, -17.0, 12.0, 45.0, 53.0,
                    5.0, -43.0, -107.0, -113.0, -95.0, -49.0 },
            { -98.0, -116.0, -81.0, -34.0, 5.0, 21.0, 17.0, -12.0, -26.0,
                    -25.0, 33.0, 94.0, 103.0, 95.0, 71.0, 19.0 },
            { 108.0, 112.0, 48.0, 4.0, -34.0, -43.0, -13.0, 7.0, 16.0, -19.0,
                    -73.0, -114.0, -108.0, -83.0, -37.0, 12.0 },
            { -115.0, -65.0, -2.0, 48.0, 46.0, 29.0, 9.0, -9.0, 11.0, 39.0,
                    90.0, 103.0, 104.0, 39.0, -21.0, -59.0 },
            { 76.0, 22.0, -18.0, -66.0, -57.0, -40.0, 1.0, -1.0, -11.0, -70.0,
                    -106.0, -102.0, -63.0, -15.0, 58.0, 81.0 },
            { -59.0, 20.0, 76.0, 95.0, 56.0, 26.0, -6.0, 16.0, 27.0, 70.0,
                    84.0, 81.0, 12.0, -48.0, -72.0, -77.0 },
            { 13.0, -44.0, -89.0, -80.0, -56.0, -24.0, -8.0, -12.0, -58.0,
                    -81.0, -64.0, -41.0, 17.0, 80.0, 97.0, 75.0 },
            { 42.0, 82.0, 107.0, 91.0, 33.0, -1.0, -12.0, 15.0, 62.0, 63.0,
                    44.0, -13.0, -54.0, -92.0, -105.0, -59.0 },
            { -66.0, -101.0, -96.0, -55.0, -26.0, 18.0, 5.0, -26.0, -57.0,
                    -41.0, -1.0, 51.0, 88.0, 115.0, 89.0, 35.0 },
            { 95.0, 126.0, 94.0, 42.0, 0.0, -15.0, 3.0, 33.0, 34.0, 17.0,
                    -23.0, -77.0, -103.0, -109.0, -72.0, -11.0 },
            { -106.0, -107.0, -49.0, 2.0, 36.0, 26.0, 6.0, -14.0, -30.0, 5.0,
                    48.0, 110.0, 103.0, 87.0, 37.0, -8.0 },
            { 116.0, 73.0, 9.0, -27.0, -62.0, -40.0, 3.0, 4.0, -6.0, -34.0,
                    -73.0, -104.0, -108.0, -54.0, 8.0, 52.0 },
            { -99.0, -48.0, 32.0, 63.0, 71.0, 31.0, -1.0, 3.0, 16.0, 50.0,
                    105.0, 109.0, 59.0, 2.0, -36.0, -68.0 },
            { 54.0, 5.0, -52.0, -91.0, -64.0, -29.0, 7.0, -8.0, -40.0, -85.0,
                    -94.0, -68.0, -20.0, 24.0, 81.0, 72.0 },
            { -6.0, 56.0, 98.0, 84.0, 67.0, 27.0, -10.0, 22.0, 58.0, 82.0,
                    89.0, 49.0, -11.0, -70.0, -103.0, -91.0 },
            { -39.0, -95.0, -103.0, -76.0, -31.0, -11.0, 10.0, -27.0, -48.0,
                    -79.0, -42.0, -9.0, 46.0, 86.0, 105.0, 60.0 },
            { 63.0, 116.0, 114.0, 58.0, 22.0, -1.0, 6.0, 17.0, 44.0, 52.0, 7.0,
                    -47.0, -79.0, -117.0, -95.0, -44.0 },
            { -96.0, -115.0, -91.0, -29.0, 8.0, 30.0, 3.0, -16.0, -35.0, -23.0,
                    10.0, 84.0, 99.0, 105.0, 63.0, 21.0 },
            { 121.0, 101.0, 68.0, 4.0, -20.0, -31.0, -6.0, 27.0, 15.0, -11.0,
                    -53.0, -95.0, -114.0, -79.0, -48.0, 8.0 },
            { -109.0, -71.0, -32.0, 28.0, 39.0, 34.0, -4.0, -26.0, -15.0, 43.0,
                    79.0, 100.0, 93.0, 54.0, -5.0, -32.0 },
            { 85.0, 49.0, -26.0, -50.0, -52.0, -44.0, -11.0, 13.0, -23.0,
                    -51.0, -105.0, -104.0, -64.0, -23.0, 33.0, 68.0 },
            { -52.0, 6.0, 44.0, 69.0, 57.0, 26.0, 11.0, 14.0, 34.0, 64.0, 94.0,
                    93.0, 35.0, -18.0, -76.0, -71.0 },
            { 26.0, -42.0, -90.0, -94.0, -54.0, -27.0, -9.0, -17.0, -53.0,
                    -77.0, -78.0, -42.0, 5.0, 72.0, 95.0, 77.0 },
            { 32.0, 76.0, 110.0, 86.0, 32.0, 3.0, -1.0, 29.0, 65.0, 70.0, 55.0,
                    3.0, -51.0, -98.0, -89.0, -71.0 },
            { -65.0, -115.0, -104.0, -71.0, -19.0, 15.0, 5.0, -37.0, -46.0,
                    -48.0, -19.0, 41.0, 88.0, 104.0, 85.0, 58.0 },
            { 89.0, 109.0, 80.0, 35.0, 7.0, -21.0, 0.0, 21.0, 49.0, 20.0,
                    -25.0, -62.0, -99.0, -100.0, -83.0, -31.0 },
            { -123.0, -97.0, -57.0, -10.0, 23.0, 24.0, -8.0, -18.0, -39.0,
                    -6.0, 55.0, 102.0, 107.0, 97.0, 49.0, 3.0 },
            { 125.0, 79.0, 35.0, -14.0, -37.0, -21.0, -7.0, 14.0, 10.0, -41.0,
                    -69.0, -103.0, -114.0, -52.0, 2.0, 26.0 },
            { -104.0, -48.0, 2.0, 49.0, 66.0, 37.0, 8.0, -8.0, 22.0, 56.0,
                    96.0, 116.0, 68.0, 30.0, -22.0, -51.0 },
            { 66.0, 15.0, -52.0, -76.0, -55.0, -28.0, 9.0, 2.0, -38.0, -66.0,
                    -96.0, -85.0, -51.0, 11.0, 66.0, 70.0 },
            { -30.0, 47.0, 88.0, 89.0, 52.0, 25.0, 1.0, 10.0, 51.0, 83.0, 96.0,
                    63.0, -10.0, -57.0, -76.0, -70.0 },
            { -18.0, -83.0, -108.0, -83.0, -41.0, -17.0, -11.0, -15.0, -59.0,
                    -78.0, -52.0, -24.0, 35.0, 99.0, 105.0, 76.0 },
            { 54.0, 101.0, 94.0, 75.0, 21.0, -7.0, 6.0, 29.0, 52.0, 62.0, 17.0,
                    -34.0, -91.0, -100.0, -100.0, -51.0 },
            { -105.0, -105.0, -91.0, -32.0, -5.0, 14.0, 1.0, -23.0, -39.0,
                    -23.0, 8.0, 58.0, 114.0, 98.0, 64.0, 24.0 },
            { 105.0, 108.0, 74.0, 1.0, -28.0, -25.0, 4.0, 25.0, 31.0, 12.0,
                    -41.0, -96.0, -111.0, -94.0, -43.0, 7.0 },
            { -124.0, -77.0, -40.0, 14.0, 47.0, 16.0, 6.0, -19.0, 0.0, 20.0,
                    73.0, 119.0, 108.0, 69.0, 0.0, -24.0 },
            { 109.0, 45.0, -9.0, -47.0, -62.0, -36.0, 5.0, 4.0, -4.0, -60.0,
                    -108.0, -117.0, -88.0, -31.0, 18.0, 53.0 },
            { -72.0, -16.0, 52.0, 76.0, 65.0, 17.0, -5.0, 1.0, 28.0, 88.0,
                    112.0, 94.0, 35.0, -24.0, -70.0, -81.0 },
            { 18.0, -32.0, -80.0, -78.0, -42.0, -25.0, 4.0, -24.0, -60.0,
                    -75.0, -93.0, -48.0, -5.0, 66.0, 74.0, 84.0 },
            { 25.0, 74.0, 105.0, 85.0, 29.0, 12.0, 13.0, 23.0, 67.0, 90.0,
                    55.0, 25.0, -35.0, -92.0, -89.0, -59.0 },
            { -70.0, -93.0, -89.0, -57.0, -19.0, 13.0, 4.0, -32.0, -71.0,
                    -66.0, -27.0, 35.0, 89.0, 94.0, 85.0, 43.0 },
            { 96.0, 105.0, 78.0, 35.0, 8.0, -8.0, 17.0, 30.0, 43.0, 46.0, -1.0,
                    -65.0, -102.0, -117.0, -68.0, -24.0 },
            { -124.0, -100.0, -72.0, -4.0, 13.0, 22.0, -18.0, -24.0, -44.0,
                    -10.0, 46.0, 107.0, 114.0, 83.0, 37.0, 5.0 },
            { 106.0, 91.0, 19.0, -9.0, -26.0, -11.0, 5.0, 34.0, 20.0, -36.0,
                    -89.0, -107.0, -114.0, -56.0, -13.0, 21.0 },
            { -109.0, -45.0, 19.0, 56.0, 37.0, 31.0, -16.0, -19.0, 7.0, 50.0,
                    105.0, 101.0, 90.0, 17.0, -19.0, -62.0 },
            { 58.0, 7.0, -45.0, -58.0, -41.0, -8.0, 14.0, -3.0, -48.0, -82.0,
                    -97.0, -93.0, -52.0, 25.0, 48.0, 69.0 },
            { -16.0, 45.0, 70.0, 65.0, 36.0, 22.0, -4.0, 17.0, 64.0, 92.0,
                    88.0, 65.0, 2.0, -61.0, -83.0, -68.0 },
            { -26.0, -82.0, -87.0, -70.0, -43.0, -8.0, 2.0, -41.0, -57.0,
                    -89.0, -57.0, -9.0, 53.0, 91.0, 98.0, 55.0 },
            { 55.0, 107.0, 88.0, 61.0, 15.0, -11.0, 2.0, 42.0, 76.0, 72.0,
                    29.0, -37.0, -77.0, -93.0, -77.0, -50.0 },
            { -100.0, -105.0, -79.0, -45.0, -2.0, 0.0, -22.0, -44.0, -54.0,
                    -44.0, 3.0, 64.0, 98.0, 96.0, 65.0, 34.0 },
            { 106.0, 112.0, 55.0, 6.0, -11.0, -5.0, 6.0, 47.0, 36.0, 12.0,
                    -42.0, -106.0, -123.0, -82.0, -45.0, -7.0 },
            { -118.0, -72.0, -37.0, 22.0, 33.0, 10.0, -17.0, -29.0, -7.0, 34.0,
                    88.0, 111.0, 100.0, 57.0, 16.0, -20.0 },
            { 90.0, 39.0, 0.0, -41.0, -46.0, -24.0, 1.0, 20.0, -20.0, -70.0,
                    -112.0, -116.0, -89.0, -15.0, 36.0, 45.0 },
            { -76.0, -12.0, 47.0, 54.0, 42.0, 13.0, -4.0, 14.0, 51.0, 87.0,
                    96.0, 81.0, 53.0, -6.0, -60.0, -55.0 },
            { 21.0, -37.0, -83.0, -62.0, -34.0, 0.0, 6.0, -31.0, -51.0, -95.0,
                    -102.0, -47.0, 11.0, 46.0, 87.0, 74.0 },
            { 20.0, 65.0, 98.0, 75.0, 30.0, -7.0, -5.0, 35.0, 77.0, 80.0, 74.0,
                    16.0, -49.0, -94.0, -90.0, -69.0 },
            { -58.0, -106.0, -103.0, -66.0, -23.0, -1.0, -22.0, -48.0, -67.0,
                    -57.0, -20.0, 22.0, 72.0, 105.0, 75.0, 52.0 },
            { 88.0, 110.0, 91.0, 25.0, -12.0, -17.0, 23.0, 56.0, 49.0, 27.0,
                    -4.0, -81.0, -97.0, -107.0, -67.0, -28.0 },
            { -125.0, -112.0, -47.0, -16.0, 11.0, 21.0, -12.0, -32.0, -39.0,
                    4.0, 46.0, 91.0, 115.0, 96.0, 50.0, -9.0 },
            { 125.0, 68.0, 20.0, -15.0, -29.0, -14.0, 16.0, 38.0, 19.0, -41.0,
                    -79.0, -119.0, -96.0, -50.0, -12.0, 37.0 },
            { -101.0, -34.0, 5.0, 48.0, 31.0, 11.0, -18.0, -12.0, 29.0, 65.0,
                    115.0, 113.0, 66.0, 23.0, -34.0, -40.0 },
            { 60.0, 2.0, -55.0, -66.0, -31.0, -18.0, 7.0, 4.0, -37.0, -94.0,
                    -111.0, -78.0, -29.0, 9.0, 61.0, 65.0 },
            { -21.0, 51.0, 79.0, 78.0, 27.0, 16.0, 0.0, 15.0, 61.0, 85.0, 99.0,
                    51.0, 2.0, -58.0, -69.0, -58.0 },
            { -28.0, -72.0, -79.0, -56.0, -20.0, -6.0, -10.0, -34.0, -70.0,
                    -81.0, -73.0, -9.0, 39.0, 79.0, 82.0, 46.0 },
            { 67.0, 102.0, 81.0, 59.0, 18.0, 5.0, 22.0, 50.0, 63.0, 56.0, 14.0,
                    -28.0, -78.0, -95.0, -86.0, -31.0 },
            { -98.0, -105.0, -72.0, -39.0, 2.0, 13.0, -30.0, -43.0, -57.0,
                    -27.0, 17.0, 64.0, 112.0, 94.0, 60.0, 28.0 },
            { 126.0, 99.0, 44.0, -6.0, -19.0, -18.0, 25.0, 35.0, 35.0, -12.0,
                    -57.0, -107.0, -109.0, -75.0, -28.0, -1.0 },
            { -123.0, -83.0, -28.0, 15.0, 34.0, 9.0, -16.0, -28.0, -18.0, 51.0,
                    82.0, 124.0, 92.0, 64.0, 10.0, -19.0 },
            { 101.0, 28.0, -9.0, -46.0, -45.0, 2.0, 14.0, 3.0, -20.0, -61.0,
                    -97.0, -98.0, -66.0, -8.0, 20.0, 54.0 },
            { -67.0, -6.0, 44.0, 71.0, 49.0, 15.0, -17.0, 19.0, 49.0, 101.0,
                    109.0, 75.0, 28.0, -15.0, -68.0, -56.0 },
            { 17.0, -53.0, -72.0, -57.0, -26.0, 7.0, -1.0, -21.0, -78.0, -88.0,
                    -91.0, -41.0, 2.0, 58.0, 68.0, 63.0 },
            { 38.0, 72.0, 99.0, 72.0, 30.0, 1.0, 4.0, 38.0, 73.0, 80.0, 49.0,
                    14.0, -62.0, -76.0, -77.0, -59.0 },
            { -69.0, -91.0, -86.0, -55.0, -15.0, -2.0, -7.0, -61.0, -83.0,
                    -53.0, -26.0, 36.0, 91.0, 110.0, 86.0, 39.0 },
            { 95.0, 100.0, 80.0, 20.0, -7.0, 4.0, 32.0, 61.0, 51.0, 20.0,
                    -20.0, -84.0, -112.0, -99.0, -49.0, -13.0 },
            { -126.0, -97.0, -53.0, 10.0, 24.0, 7.0, -15.0, -35.0, -24.0, 19.0,
                    75.0, 115.0, 120.0, 89.0, 22.0, 1.0 },
            { 109.0, 65.0, 12.0, -33.0, -36.0, 4.0, 29.0, 20.0, -7.0, -40.0,
                    -104.0, -114.0, -97.0, -59.0, 10.0, 29.0 },
            { -97.0, -42.0, 22.0, 37.0, 27.0, 7.0, -27.0, -7.0, 17.0, 67.0,
                    113.0, 96.0, 60.0, 1.0, -28.0, -38.0 },
            { 41.0, -12.0, -63.0, -68.0, -29.0, -14.0, 5.0, -18.0, -44.0,
                    -84.0, -103.0, -72.0, -30.0, 32.0, 70.0, 57.0 },
            { -16.0, 42.0, 69.0, 72.0, 26.0, -6.0, -9.0, 38.0, 73.0, 108.0,
                    97.0, 35.0, -27.0, -70.0, -77.0, -61.0 },
            { -30.0, -79.0, -98.0, -69.0, -26.0, 1.0, -3.0, -41.0, -80.0,
                    -75.0, -54.0, 3.0, 64.0, 94.0, 91.0, 53.0 },
            { 69.0, 112.0, 87.0, 35.0, 16.0, 4.0, 25.0, 62.0, 75.0, 52.0, 7.0,
                    -42.0, -94.0, -89.0, -76.0, -42.0 },
            { -113.0, -115.0, -59.0, -13.0, 3.0, 14.0, -15.0, -43.0, -47.0,
                    -24.0, 41.0, 94.0, 112.0, 85.0, 46.0, 9.0 },
            { 113.0, 83.0, 39.0, -12.0, -30.0, -3.0, 33.0, 38.0, 20.0, -14.0,
                    -62.0, -98.0, -102.0, -73.0, -35.0, 2.0 },
            { -102.0, -54.0, -8.0, 32.0, 32.0, 3.0, -13.0, -38.0, -7.0, 55.0,
                    94.0, 105.0, 82.0, 50.0, -5.0, -23.0 },
            { 84.0, 18.0, -17.0, -45.0, -32.0, -3.0, 14.0, 3.0, -22.0, -89.0,
                    -105.0, -103.0, -59.0, 3.0, 47.0, 57.0 },
            { -35.0, 26.0, 50.0, 53.0, 45.0, -7.0, -16.0, 25.0, 58.0, 86.0,
                    103.0, 83.0, 27.0, -44.0, -64.0, -49.0 },
            { -10.0, -47.0, -70.0, -72.0, -19.0, 4.0, -5.0, -45.0, -77.0,
                    -89.0, -91.0, -42.0, 14.0, 69.0, 71.0, 57.0 },
            { 56.0, 91.0, 82.0, 55.0, 11.0, 9.0, 5.0, 38.0, 81.0, 82.0, 37.0,
                    -17.0, -64.0, -93.0, -90.0, -55.0 },
            { -92.0, -108.0, -90.0, -49.0, 4.0, -7.0, -29.0, -64.0, -63.0,
                    -61.0, -1.0, 47.0, 95.0, 100.0, 73.0, 37.0 },
            { 113.0, 101.0, 63.0, 27.0, 0.0, 6.0, 35.0, 61.0, 62.0, 9.0, -28.0,
                    -79.0, -104.0, -88.0, -41.0, -16.0 },
            { -106.0, -99.0, -29.0, 15.0, 15.0, 3.0, -31.0, -37.0, -15.0, 27.0,
                    67.0, 102.0, 107.0, 68.0, 12.0, -21.0 },
            { 107.0, 52.0, 13.0, -40.0, -23.0, 5.0, 29.0, 15.0, -12.0, -48.0,
                    -91.0, -106.0, -79.0, -45.0, 5.0, 45.0 },
            { -81.0, -18.0, 22.0, 43.0, 42.0, 15.0, -9.0, 6.0, 42.0, 93.0,
                    100.0, 107.0, 48.0, -10.0, -47.0, -40.0 },
            { 28.0, -13.0, -54.0, -64.0, -42.0, 0.0, 12.0, -21.0, -61.0,
                    -108.0, -93.0, -71.0, -7.0, 36.0, 59.0, 48.0 },
            { 17.0, 70.0, 79.0, 76.0, 22.0, 10.0, 9.0, 44.0, 78.0, 99.0, 70.0,
                    38.0, -40.0, -82.0, -71.0, -52.0 },
            { -54.0, -85.0, -92.0, -67.0, -23.0, -3.0, -5.0, -56.0, -80.0,
                    -77.0, -49.0, 25.0, 76.0, 103.0, 90.0, 46.0 },
            { 90.0, 111.0, 76.0, 49.0, 10.0, 6.0, 18.0, 61.0, 77.0, 39.0,
                    -12.0, -59.0, -98.0, -105.0, -78.0, -16.0 },
            { -121.0, -94.0, -55.0, -13.0, 4.0, 16.0, -16.0, -61.0, -39.0,
                    -7.0, 36.0, 100.0, 107.0, 81.0, 35.0, 14.0 },
            { 121.0, 82.0, 43.0, -18.0, -17.0, -2.0, 14.0, 49.0, 18.0, -36.0,
                    -91.0, -111.0, -95.0, -73.0, -17.0, 28.0 },
            { -93.0, -50.0, 1.0, 34.0, 44.0, 7.0, -24.0, -11.0, 14.0, 52.0,
                    98.0, 118.0, 82.0, 38.0, -26.0, -30.0 },
            { 67.0, 15.0, -45.0, -51.0, -47.0, -16.0, 14.0, -10.0, -43.0,
                    -96.0, -115.0, -100.0, -52.0, 16.0, 40.0, 43.0 },
            { -23.0, 20.0, 63.0, 75.0, 30.0, 12.0, -13.0, 30.0, 58.0, 87.0,
                    109.0, 64.0, 6.0, -39.0, -80.0, -48.0 },
            { -13.0, -58.0, -87.0, -74.0, -27.0, 6.0, 3.0, -28.0, -82.0,
                    -102.0, -77.0, -13.0, 41.0, 76.0, 76.0, 47.0 },
            { 66.0, 90.0, 101.0, 50.0, 10.0, -5.0, 6.0, 43.0, 67.0, 82.0, 26.0,
                    -16.0, -86.0, -106.0, -88.0, -40.0 },
            { -95.0, -105.0, -91.0, -27.0, 5.0, 16.0, -26.0, -47.0, -60.0,
                    -33.0, 8.0, 76.0, 107.0, 100.0, 66.0, 14.0 },
            { 113.0, 98.0, 61.0, 8.0, -17.0, -5.0, 11.0, 41.0, 54.0, 6.0,
                    -55.0, -105.0, -116.0, -78.0, -43.0, 10.0 },
            { -106.0, -74.0, -37.0, 26.0, 37.0, 14.0, -10.0, -45.0, -21.0,
                    38.0, 76.0, 103.0, 105.0, 72.0, 0.0, -14.0 },
            { 108.0, 49.0, -2.0, -46.0, -45.0, -21.0, 27.0, 8.0, -9.0, -75.0,
                    -101.0, -115.0, -78.0, -30.0, 15.0, 49.0 },
            { -60.0, -16.0, 41.0, 69.0, 33.0, 20.0, -11.0, 2.0, 32.0, 79.0,
                    100.0, 86.0, 39.0, -22.0, -42.0, -60.0 },
            { 25.0, -32.0, -68.0, -71.0, -39.0, 3.0, 8.0, -11.0, -60.0, -87.0,
                    -106.0, -60.0, -9.0, 48.0, 82.0, 64.0 },
            { 24.0, 62.0, 82.0, 76.0, 30.0, 9.0, 12.0, 27.0, 75.0, 92.0, 78.0,
                    24.0, -47.0, -72.0, -85.0, -46.0 },
            { -59.0, -97.0, -100.0, -60.0, -6.0, -1.0, -9.0, -45.0, -64.0,
                    -68.0, -20.0, 23.0, 73.0, 108.0, 86.0, 51.0 },
            { 86.0, 106.0, 82.0, 39.0, 8.0, -4.0, 20.0, 45.0, 63.0, 41.0, -3.0,
                    -78.0, -99.0, -94.0, -75.0, -18.0 },
            { -105.0, -102.0, -51.0, -12.0, 9.0, 21.0, -10.0, -34.0, -30.0,
                    7.0, 63.0, 92.0, 121.0, 80.0, 42.0, -5.0 },
            { 122.0, 76.0, 18.0, -27.0, -38.0, -5.0, 7.0, 41.0, 14.0, -38.0,
                    -86.0, -124.0, -112.0, -49.0, -8.0, 28.0 },
            { -108.0, -54.0, 20.0, 56.0, 36.0, 9.0, -5.0, -21.0, 25.0, 73.0,
                    94.0, 119.0, 87.0, 13.0, -36.0, -52.0 },
            { 62.0, -4.0, -57.0, -59.0, -40.0, -3.0, -1.0, 6.0, -48.0, -79.0,
                    -108.0, -84.0, -47.0, 19.0, 47.0, 62.0 },
            { -32.0, 47.0, 83.0, 76.0, 49.0, 0.0, 7.0, 18.0, 52.0, 85.0, 85.0,
                    49.0, 5.0, -49.0, -72.0, -73.0 },
            { -15.0, -73.0, -92.0, -83.0, -23.0, 6.0, 4.0, -42.0, -75.0, -82.0,
                    -54.0, -2.0, 48.0, 77.0, 82.0, 54.0 },
            { 57.0, 97.0, 98.0, 70.0, 10.0, -1.0, 15.0, 52.0, 79.0, 56.0, 36.0,
                    -30.0, -75.0, -109.0, -82.0, -38.0 },
            { -88.0, -113.0, -77.0, -43.0, -8.0, 21.0, -1.0, -53.0, -48.0,
                    -29.0, 6.0, 78.0, 107.0, 105.0, 71.0, 30.0 },
            { 119.0, 96.0, 58.0, 0.0, -23.0, -25.0, 22.0, 48.0, 38.0, -2.0,
                    -55.0, -103.0, -105.0, -96.0, -46.0, -5.0 },
            { -106.0, -91.0, -16.0, 23.0, 48.0, 12.0, -12.0, -36.0, -16.0,
                    46.0, 93.0, 117.0, 111.0, 58.0, 8.0, -21.0 },
            { 88.0, 55.0, -22.0, -57.0, -54.0, -29.0, 1.0, 13.0, -26.0, -62.0,
                    -98.0, -99.0, -83.0, -29.0, 37.0, 55.0 },
            { -58.0, -8.0, 49.0, 78.0, 42.0, 10.0, 3.0, 4.0, 50.0, 90.0, 104.0,
                    94.0, 33.0, -20.0, -50.0, -59.0 },
            { 12.0, -47.0, -84.0, -88.0, -50.0, -9.0, 11.0, -26.0, -66.0,
                    -81.0, -99.0, -59.0, -2.0, 52.0, 89.0, 60.0 },
            { 31.0, 86.0, 107.0, 70.0, 30.0, -5.0, 12.0, 20.0, 75.0, 72.0,
                    71.0, 10.0, -59.0, -81.0, -82.0, -64.0 },
            { -64.0, -94.0, -106.0, -54.0, -9.0, 6.0, 5.0, -43.0, -59.0, -67.0,
                    -22.0, 26.0, 94.0, 94.0, 94.0, 44.0 },
            { 91.0, 124.0, 97.0, 49.0, -9.0, -6.0, 4.0, 46.0, 45.0, 30.0,
                    -13.0, -81.0, -118.0, -105.0, -70.0, -28.0 },
            { -111.0, -99.0, -53.0, 1.0, 32.0, 30.0, -11.0, -23.0, -26.0, -4.0,
                    48.0, 109.0, 123.0, 79.0, 47.0, 3.0 },
            { 125.0, 75.0, 28.0, -33.0, -52.0, -17.0, 15.0, 28.0, 16.0, -38.0,
                    -93.0, -121.0, -108.0, -58.0, -5.0, 29.0 },
            { -106.0, -39.0, 6.0, 43.0, 63.0, 19.0, -5.0, -14.0, 26.0, 53.0,
                    92.0, 106.0, 70.0, 21.0, -29.0, -46.0 },
            { 75.0, 1.0, -61.0, -84.0, -52.0, -33.0, -8.0, 2.0, -30.0, -70.0,
                    -96.0, -94.0, -46.0, 24.0, 53.0, 70.0 },
            { -25.0, 36.0, 92.0, 94.0, 57.0, 23.0, 10.0, 11.0, 44.0, 94.0,
                    95.0, 42.0, 1.0, -62.0, -85.0, -75.0 },
            { -15.0, -68.0, -103.0, -71.0, -31.0, -13.0, 10.0, -23.0, -61.0,
                    -88.0, -52.0, -1.0, 46.0, 91.0, 88.0, 56.0 },
            { 73.0, 96.0, 108.0, 66.0, 10.0, -8.0, 11.0, 41.0, 63.0, 60.0,
                    19.0, -43.0, -88.0, -112.0, -87.0, -47.0 },
            { -88.0, -111.0, -100.0, -46.0, 1.0, 7.0, 6.0, -23.0, -49.0, -21.0,
                    26.0, 82.0, 98.0, 116.0, 62.0, 32.0 },
            { 116.0, 115.0, 55.0, 17.0, -35.0, -32.0, 10.0, 22.0, 21.0, -4.0,
                    -63.0, -108.0, -123.0, -84.0, -47.0, -3.0 },
            { -106.0, -80.0, -37.0, 23.0, 41.0, 42.0, 10.0, -29.0, -11.0, 33.0,
                    78.0, 101.0, 112.0, 55.0, -4.0, -40.0 },
            { 108.0, 50.0, -2.0, -61.0, -57.0, -42.0, -7.0, -1.0, -15.0, -69.0,
                    -88.0, -104.0, -66.0, -28.0, 37.0, 66.0 },
            { -67.0, 4.0, 45.0, 79.0, 52.0, 30.0, -1.0, -7.0, 43.0, 68.0, 96.0,
                    82.0, 43.0, -12.0, -72.0, -82.0 },
            { 35.0, -44.0, -72.0, -97.0, -59.0, -22.0, 8.0, -21.0, -52.0,
                    -71.0, -95.0, -49.0, 3.0, 50.0, 81.0, 88.0 },
            { 23.0, 68.0, 93.0, 84.0, 33.0, 15.0, 8.0, 21.0, 48.0, 65.0, 63.0,
                    6.0, -41.0, -84.0, -99.0, -78.0 },
            { -73.0, -98.0, -105.0, -60.0, -32.0, 6.0, 3.0, -16.0, -48.0,
                    -68.0, -35.0, 41.0, 80.0, 111.0, 103.0, 62.0 },
            { 93.0, 123.0, 87.0, 53.0, -4.0, -22.0, -3.0, 17.0, 36.0, 29.0,
                    -21.0, -60.0, -116.0, -109.0, -72.0, -20.0 },
            { -119.0, -115.0, -69.0, -22.0, 27.0, 40.0, 7.0, -33.0, -31.0, 2.0,
                    59.0, 96.0, 112.0, 84.0, 54.0, 5.0 },
            { 125.0, 78.0, 38.0, -14.0, -42.0, -28.0, -15.0, 13.0, -1.0, -21.0,
                    -78.0, -106.0, -100.0, -66.0, -17.0, 28.0 },
            { -99.0, -62.0, 0.0, 62.0, 63.0, 34.0, -5.0, 2.0, 22.0, 65.0, 94.0,
                    102.0, 83.0, 29.0, -35.0, -71.0 },
            { 64.0, 9.0, -40.0, -81.0, -77.0, -33.0, -13.0, -12.0, -24.0,
                    -63.0, -89.0, -81.0, -50.0, 20.0, 54.0, 80.0 },
            { -21.0, 46.0, 89.0, 91.0, 71.0, 21.0, -10.0, 15.0, 34.0, 69.0,
                    94.0, 61.0, 2.0, -60.0, -97.0, -72.0 },
            { -8.0, -65.0, -97.0, -99.0, -54.0, 0.0, 2.0, -18.0, -49.0, -80.0,
                    -53.0, -25.0, 54.0, 80.0, 100.0, 67.0 },
            { 69.0, 113.0, 104.0, 78.0, 17.0, 4.0, 5.0, 13.0, 59.0, 67.0, 17.0,
                    -21.0, -77.0, -103.0, -94.0, -45.0 } };
}
