# Tests for the InternalErrorException class
#
# @Author: Christopher Hylands
#
# @Version: $Id: InternalErrorException.tcl,v 1.8 2005/02/28 20:17:11 cxh Exp $
#
# @Copyright (c) 1999-2005 The Regents of the University of California.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
#
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
#
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
#######################################################################

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then {
    source testDefs.tcl
} {}

# Uncomment this to get a full report, or set in your Tcl shell window.
# set VERBOSE 1

######################################################################
####
#
test InternalErrorException-3.1 {Create a InternalErrorException with a \
	detail message} {
    set pe [java::new {ptolemy.kernel.util.InternalErrorException String} \
	    "A message"]
    list [$pe getMessage] [$pe getLocalizedMessage]
} {{A message} {A message}}

######################################################################
####
#
test InternalErrorException-3.2 {Create a InternalErrorException with a \
	null detail message} {
    set pe [java::new {ptolemy.kernel.util.InternalErrorException String} \
	    [java::null]]
    list [$pe getMessage]
} {{}}

######################################################################
####
test InternalErrorException-3.3 {Create a InternalErrorException with \
	a detail message that is not a String} {
    set n1 [java::new ptolemy.kernel.util.NamedObj]
    # We can't check the error message here because Tcl Blend returns
    # a hex number that changes:
    #   expected object of type
    #  java.lang.String but got "java0x222" (ptolemy.kernel.util.NamedObj)
    catch {set pe \
	    [java::new {ptolemy.kernel.util.InternalErrorException String} \
	    $n1]}
} {1}

######################################################################
####
#
test InternalErrorException-3.4 {InternalErrorException with a cause} {
    set cause [java::new Exception "Cause Exception"]
    set pe [java::new {ptolemy.kernel.util.InternalErrorException Throwable} \
	    $cause]
    list [$pe getMessage]
} {{Because:
Cause Exception}}


######################################################################
####
#
test InternalErrorException-3.5 {InternalErrorException with a nameable \
	cause and no message} {
    set n1 [java::new ptolemy.kernel.util.NamedObj "myN1"]
    set cause [java::new Exception "Cause Exception"]
    set pe [java::new ptolemy.kernel.util.InternalErrorException \
	    $n1 $cause [java::null]]
    list [$pe getMessage]
} {{  in .myN1
Because:
Cause Exception}}

######################################################################
####
#
test InternalErrorException-3.6 {InternalErrorException with a nameable \
	cause and a detail message} {
    set n1 [java::new ptolemy.kernel.util.NamedObj "myN1"]
    set cause [java::new Exception "Cause Exception"]
    set pe [java::new ptolemy.kernel.util.InternalErrorException \
	    $n1 $cause "Detail Message"]
    list [$pe getMessage]
} {{Detail Message
  in .myN1
Because:
Cause Exception}}
