package apps;

import java.util.logging.Logger;

import misc.*;
import tools.*;
import data.*;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Creates a stream of synthetic data
 * 
 * <dt>Description:
 * 
 * <dd>Outputs a specified number of voxels worth of data synthesized from the
 * specified test function with the specified imaging parameters and noise
 * level.
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: SyntheticData.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public class SyntheticData {

    private static Logger logger = Logger.getLogger("camino.apps.SyntheticData");

    /**
     * Output manager
     */
    private static OutputManager om;


    public static void main(String[] args) {

        // The output defaults to float type.
        OutputManager.outputDataType = "float";
        // The intput defaults to double type.
        CL_Initializer.inputDataType = "double";

        // Parse the command line arguments
        CL_Initializer.CL_init(args);
                
        CL_Initializer.checkParsing(args);

        // Now initialize the acquisition scheme and model parameters.
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
     
        om = new OutputManager();
   
        
        // Check that a test function was specified.
        if (CL_Initializer.p == null && CL_Initializer.inputModel == null && CL_Initializer.brownianSimulation==false && CL_Initializer.bootstrap < 0) {
            throw new LoggedException("No test function or input model or input data specified.");
        }

        // Loop over the data outputting it
        while (CL_Initializer.data.more())
            try {

                om.output(CL_Initializer.data.nextVoxel());

            }
            catch (Exception e) {
                throw new LoggedException(e);
            }

        om.close();
    }

}
