package data;

import imaging.*;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Source of voxel order diffusion-weighted MRI data from a data file or
 * standard input.
 * 
 * <dt>Description:
 * 
 * <dd>This extends VoxelOrderDataSource adding some features specific to
 * diffusion-weighted MRI data. Specifically, the constructor uses an
 * Scheme object and the data reader uses that object to determine
 * whether any measurements should be discarded (as in, for example, the 54-6-6
 * ION sequence - bmx 7).
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: VoxelOrderDW_DataSource.java,v 1.5 2005/08/18 10:59:36 ucacmgh
 *          Exp $
 */
public class VoxelOrderDW_DataSource extends VoxelOrderDataSource {

    /**
     * The imaging parameters of the sequence used to acquire the data.
     */
    private Scheme ip;

    /**
     * Constructor requires the filename, the number of values in each voxel and
     * the data type. If the filename is null, the input stream provides the
     * data.
     * 
     * @param filename
     *            The name of the data file.
     * 
     * @param type
     *            A string indicating the data type: either "char", "short",
     *            "int", "long", "float" or "double".
     * 
     * @param imParams
     *            The sequence defining the DW data.
     */
    public VoxelOrderDW_DataSource(String filename, String type,
            Scheme imParams) {
        ip = imParams;
        int components = ip.numMeasurements() + ip.getIgnore();

	initFileInput(filename, false, 0);
	
        init(components, type);
    }

    /**
     * Puts the data for the current voxel into an array ready for return by
     * nextVoxel. Overrides the method in the superclass to take care of the
     * possibility that some measurements at the end of the list in each voxel
     * should be ignored.
     * 
     * @return An array containing the voxel data.
     */
    protected double[] retrieveCurrentVoxelData() {
        double[] vox = new double[numComponents - ip.getIgnore()];
        for (int i = 0; i < numComponents - ip.getIgnore(); i++) {
            vox[i] = next[i];
        }
        return vox;
    }
}
